package cn.kinyun.crm.common.service.dto.req.global;

import lombok.Data;

import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CrmGlobalSearchResultDto implements Serializable {

    /**
     * 前端展示唯一标识
     */
    private String id;

    private Long leadsId;

    private String leadsNum;

    /**
     * 名称
     */
    private String name;

    /**
     * 电话
     */
    private String mobile;


    /**
     * 地区信息
     */
    private String area;

    /**
     * 跟进次数
     */
    private Integer trackCount;

    /**
     * 渠道名称
     */
    private String channelName;

    /**
     * 录入方式
     */
    private String sourceTypeStr;

    /**
     * 阶段信息
     */
    private String stage;

    /**
     * 标签名称
     */
    private List<String> tagNames;

    /**
     * 录入人
     */
    private String importUserName;

    /**
     * 推广人
     */
    private String marketUserName;

    /**
     * 刷新次数
     */
    private Integer refreshCount;

    /**
     * 释放次数
     */
    private Integer releaseCount;

    /**
     * 最近刷新时间
     */
    private Date latestRefreshTime;

    /**
     * 末次释放原因
     */
    private String latestReleaseReason;

    private String customerNum;

    /**
     * 最新跟进时间
     */
    private Date latestFollowTime;

    /**
     * 最近跟进人
     */
    private String latestFollowUserName;

    /**
     * 剩余释放天数
     */
    private Integer remainBindingDays;


    /**
     * 剩余跟进天数
     */
    private Integer followRateRemainDays;

    /**
     * 绑定
     */
    private String bindingName;


    /**
     * 绑定时间
     */
    private Date bindTime;

    /**
     * 剩余时间
     */
    private Integer remainReleaseDays;

    /**
     * 库类型
     */
    private List<String> libTypeStrs;

    /**
     * 入库时间
     */
    private Date importTime;

    //以下为jyxb新增=======================
    /**
     * 资源类型
     */
    private String resourceType;

    /**
     * 备注名
     */
    private String remarkName;

    /**
     * 年级
     */
    private String grade;

    /**
     * 科目
     */
    private String subject;

    /**
     * 注册状态
     */
    private Integer registerStatus;

    /**
     * 注册时间
     */
    private Date registerTime;

    /**
     * 总呼叫次数
     */
    private Integer totalCallCount;

    /**
     * 总通话成功次数
     */
    private Integer totalCallSuccessCount;

    /**
     *
     * 上试听课
     */
    private Integer freeLessonCount;

    /**
     * 近30天消费
     */
    private Long consume30;
}
