package cn.kinyun.crm.common.service.dto.req;

import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author sunwen
 *
 * 订单业绩明细导出
 */
@Data
public class OrderPerformanceExportReq implements Serializable {

    /**
     * 业绩归属人
     */
    private List<String> userIds;

    /**
     * 业绩归属部门
     */
    private List<String> nodeIds;

    /**
     * 业绩类型
     * <p>
     * 1：普通充值 2：普通充值退费 3：推广渠道充值 4：推广渠道退费 5：老师推荐首充 6：老师推荐首充退费 7：换课中心购买 8：课程消耗
     */
    private List<Integer> performanceTypes;

    /**
     * 充值类型
     * 0:其他;1:首充;2:续费
     */
    private Integer chargeType;

    /**
     * 是否有效;0:无效;1:有效
     */
    private Integer valid;

    private Date startTime;

    private Date endTime;

    /**
     * 学生姓名，手机号模糊查询
     */
    private String query;

    /**
     * 交易编号
     */
    private String orderNo;

    private PageDto pageDto;
}
