/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service;

import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.crm.common.service.dto.req.CrmModMobileReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;

import java.util.List;
import java.util.Map;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/10/17
 */
public interface CrmLeadsService {

    /**
     * 查询线索
     *
     * @param params 线索信息
     * @return 线索ID
     */
    CrmLeadsInfoResp getLeads(CrmLeadsInfoReq params);

    /**
     * 添加线索
     *
     * @param params 线索信息
     * @return 线索ID
     */
    String addLeads(CrmLeadsReq params);

    /**
     * 修改线索手机号
     *
     * @param params 线索信息
     * @return 线索ID
     */
    void modAdLeads(CrmLeadsReq params);

    /**
     * 修改线索手机号
     *
     * @param params 线索信息
     * @return 线索ID
     */
    void modScrmLeads(CrmLeadsReq params);

    /**
     * 修改线索手机号
     *
     * @param params 线索信息
     * @return 线索ID
     */
    void modMobiles(CrmModMobileReq params);

    boolean exists(CrmLeadsInfoReq params);

    /**
     * 根据线索num查询分配情况
     * @param bizId
     * @param leadsLibNums
     * @param productLineNum
     * @return
     */
    Map<String, String> getAllocTarget(Long bizId, String productLineNum, List<String> leadsLibNums);

    /**
     * 获取线索最新的渠道
     *
     * @param bizId 商户id
     * @param customerNum 客户num
     * @return 线索最新渠道
     */
    Long getLeadsChannelId(Long bizId, String customerNum);
}