package cn.kinyun.crm.common.enums;

import com.kuaike.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * 线索分配对象
 *
 * @author luoxingke
 * @date 2021-08-29 16:15
 */
public enum SourceType implements EnumService {

    MANUAL(0, "手动录入"),
    BATCH_IMPORT(1, "批量导入"),
    API(2, "系统对接-API"),
    SCRM_SYNC(3, "系统对接-企业微信"),
    TRADE_SYNC(4, "系统对接-商品订单"),
    AD_SYNC(5, "系统对接-广告投放"),
    DYNAMIC_FORM_SYNC(6, "系统对接-动态表单"),
    JYXB(7, "系统对接-家有学霸"),
    ;

    private final int value;

    private final String desc;

    SourceType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private final static Map<Integer, SourceType> CACHE;

    static {
        Map<Integer, SourceType> map = new HashMap<>();
        for (SourceType e : values()) {
            map.put(e.value, e);
        }
        CACHE = map;
    }

    public static SourceType getType(Integer value) {
        return CACHE.get(value);
    }
}
