/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service.dto.resp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 线索信息
 *
 * @author lanye
 */
@Data
public class CrmLeadsInfoResp implements Serializable {

    private Long id;

    /**
     * 对外展示唯一标识
     */
    private String num;

    /**
     * 商户id
     */
    private Long bizId;

    /**
     * 企业Id，企业微信测唯一标识
     */
    private String corpId;

    /**
     * 销售线
     */
    private Long productLineId;

    /**
     * 客户ID
     */
    private Long customerId;

    /**
     * 阶段ID
     */
    private Long stageId;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 手机号1
     */
    private String mobile1;

    /**
     * 手机号2
     */
    private String mobile2;

    /**
     * 手机号3
     */
    private String mobile3;

    /**
     * 手机号4
     */
    private String mobile4;

    /**
     * 姓名
     */
    private String name;

    /**
     * 身份证号
     */
    private String idNum;

    /**
     * 所属区域
     */
    private String areaId;

    /**
     * 0表示未定义，1表示男性，2表示女性
     */
    private Integer gender;

    /**
     * QQ
     */
    private String qq;

    /**
     * 微信
     */
    private String wechat;

    /**
     * 邮箱
     */
    private String mail;

    /**
     * 年龄
     */
    private Integer age;

    /**
     * 学历
     */
    private String education;

    /**
     * 毕业院校
     */
    private String graduated;

    /**
     * 专业
     */
    private String major;

    /**
     * 渠道id
     */
    private Long channelId;

    /**
     * 市场/推广人id
     */
    private Long marketUserId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态：0=未处理，1=正在处理，2=转自动分配，3=转交到成员，4=转交到部门公海，5=废弃库
     */
    private Integer status;

    /**
     * 录入方式
     */
    private Integer sourceType;


    private Long createBy;

    private Date createTime;

    private Long updateBy;

    private Date updateTime;

    private Long bindingUserId;

    private Long bindingDeptId;

    private String customerNum;

    private String productLineNum;

    private Integer bindUserCount;
    /**
     * 是否是新线索
     */
    private Boolean isNewLeads;
}
