package cn.kinyun.crm.common.service.dto.req.dept;


import cn.kinyun.crm.common.dto.TagGroupPair;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

@Data
public class CrmDeptSearchReq implements Serializable {

    private Long bizId;

    private String userId;

    private String deptId;

    private Set<String> channelIds;

    private String areaId;

    private Integer leadType;

    private String productLineId;

    private Long stageId;

    private Date followStartTime;

    private Date followEndTime;

    private Integer followCountFrom;

    private Integer followCountTo;

    private Set<String> tagIds;

    private String query;

    private PageDto pageDto;

    private Integer isAssociateWework;

    private Integer isAssociateOfficial;

    private Integer isAssociateApplet;

    private String unionId;

    private Date importTimeBegin;

    private Date importTimeEnd;

    /**
     * 是否导出 1:是 导出的话手机号不加密
     */
    private Integer isExport = 1;

    private String productLineNum;

    private List<String> channelNums;

    private Integer sourceType;

    private Integer leadsType;

    private Integer remainReleaseDays;

    private Date bindingTimeBegin;

    private Date bindingTimeEnd;

    private Date latestFollowTimeBegin;

    private Date latestFollowTimeEnd;

    private Integer libType;

    private Integer remainDaysFrom;

    private Integer remainDaysTo;

    /**
     * 查询成交人企微好友关系
     */
    private String belongsUserId;

    /**
     * 订单成交人
     **/
    private List<String> orderUserIds;

    /**
     * 商品编号
     **/
    private String productId;

    /**
     * 自定义商品编号
     **/
    private String outProductId;

    /**
     * 订单编号
     **/
    private String orderNo;

    /**
     * 订单开始数量
     */
    private Integer orderStartCount;

    /**
     * 订单结束数量
     */
    private Integer orderEndCount;

    /**
     * 订单开始支付金额
     */
    private Long paidAmountStart;
    /**
     *订单结束支付金额
     */
    private Long paidAmountEnd;


    /**
     * 订单来源
     */
    private String orderSource;

    /**
     * 下单开始时间
     */
    private Date orderTimeStart;

    /**
     * 下单结束时间
     */
    private Date orderTimeEnd;


    private List<String> importByIds;

    /**
     * 当前这个线索属于那个库
     */
    private List<String> tbName;

    /**
     * 标签筛选条件 0:以下标签满足其中之一 1:以下标签同时满足 2:无任何标签
     **/
    private Integer tagCondition;

    /**
     * 包含的标签
     **/
    private List<TagGroupPair> includeTags;

    /**
     * 排除的标签逻辑关系 0: 满足其一，或；1：同时满足，与；2：无标签，不存在任何标签
     */
    private Integer excludeFilterType;

    /**
     * 排除的标签
     **/
    private List<TagGroupPair> excludeTags;

    /**
     * 最近跟进人
     **/
    private String lastFollowUserId;

    private Long userIdLong;
}
