package cn.kinyun.crm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author Created by chenjiaqiang on 2023/07/24
 **/
@Data
public class CrmTriggerUserStatisticsReq implements Serializable {

    /**
     * 必传，商户id
     */
    private Long bizId;

    /**
     * 必传，统计维度 1天 2周 3月
     */
    private Integer dimension;

    /**
     * 非必传，指定时间统计
     * 如果指定了 也是统计指定时间 的 上一个周期的数据
     */
    private Date specifiedTime;

    public void validateParams() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "商户id不能为空");
        Preconditions.checkArgument(Objects.nonNull(dimension), "统计维度不能为空");
    }

}
