package cn.kinyun.crm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.io.Serializable;
import java.util.Objects;

@Data
public class CrmTemplateReq implements Serializable {

    private Long bizId;

    private String corpId;

    private Long operatorId;

    private String productLineId;

    public void validateParams() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "商户id不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "企业id不能为空");
        if (Objects.isNull(operatorId)) {
            operatorId = NumberUtils.LONG_MINUS_ONE;
        }
        Preconditions.checkArgument(StringUtils.isNotBlank(productLineId), "销售线不能为空");
    }
}
