/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

/**
 * 给CRM客户打标签
 *
 * @author lanye
 */
@Data
public class CrmLeadsTagReq implements Serializable {
    private Long bizId;
    private String corpId;
    /**
     * 手机号
     */
    private String mobile;
    /**
     * 销售线ID（传手机号并多销售线时必填）
     */
    private Long productLineId;
    /**
     * 线索num，与手机号二选一
     */
    private Long leadsId;


    private List<Long> leadsIds;
    /**
     * 标签
     */
    private Collection<String> tags;
    /**
     * 是否记录操作日志 默认记录
     */
    private Integer saveLog = 1;

    public void validate() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "bizId is null");
        Preconditions.checkArgument(Objects.nonNull(corpId), "corpId is null");
    }
}
