/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service;

import cn.kinyun.crm.common.service.dto.req.CrmCustomerIsAssociateReq;
import cn.kinyun.crm.common.service.dto.req.CrmCustomerReq;
import cn.kinyun.crm.common.service.dto.req.CrmGroupSendFilterQuery;
import cn.kinyun.crm.common.service.dto.req.CustomerAreaReq;
import cn.kinyun.crm.common.service.dto.resp.CrmCustomerInfoResp;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsStatisticsResp;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Crm客户信息查询接口
 *
 * @author yanmaoyuan
 * @date 2021/9/16
 */
public interface CrmCustomerService {

    /**
     * 根据手机号查询客户基本信息（精确匹配）
     *
     * @param bizId  商户ID
     * @param mobile 手机号
     * @return 符合条件的客户信息
     */
    CrmCustomerInfoResp getByMobile(Long bizId, String mobile);

    /**
     * 推送客户信息给CRM
     *
     * @param params 客户信息
     * @return true 添加成功 false 添加失败
     */
    boolean add(CrmCustomerReq params);

    /**
     * 企微标识变更
     *
     * @param params 客户信息
     */
    void syncIsAssociateWework(CrmCustomerIsAssociateReq params);

    /**
     * 小程序标识变更
     *
     * @param params 客户信息
     */
    void syncIsAssociateMini(CrmCustomerIsAssociateReq params);

    /**
     * 公众号标识变更
     *
     * @param params 客户信息
     */
    void syncIsAssociateOfficial(CrmCustomerIsAssociateReq params);

    /**
     * 根据userId 查询首次绑定的客户
     */
    Map<Long, List<String>> queryUserNewCustomer(Long bizId, String productLine, List<Long> userIds,
                                                 Date bindStart, Date bindEnd);


    List<CrmLeadsStatisticsResp> getLeadsAreaStatistics(CustomerAreaReq leadsAreaReq);

    /**
     * 查询符合条件的customerNum集合
     * @param query
     * @return
     */
    Set<String> filterCustomerNumByLeadsTypes(CrmGroupSendFilterQuery query);

}
