/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service;

import cn.kinyun.crm.common.service.dto.req.CrmLeadsDictionaryReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsConfigResp;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsDictionaryResp;
import cn.kinyun.crm.common.service.dto.resp.CrmSalesConfigResp;
import cn.kinyun.crm.common.service.dto.resp.OrderAmountConfResp;

import java.util.List;

/**
 * desc: 销售设置
 *
 * @author yanmaoyuan
 * @date 2021/10/30
 */
public interface CrmConfigService {

    /**
     * 查询企业的销售设置
     *
     * @param corpId 企业ID
     * @return 销售设置
     */
    CrmSalesConfigResp getSalesConfig(String corpId);

    /**
     * 查询线索字段配置
     *
     * @param params 查询参数
     * @return 字段配置
     */
    List<CrmLeadsDictionaryResp> getLeadsDictionary(CrmLeadsDictionaryReq params);

    /**
     * 是否开启字段排重
     *
     * @param corpId
     * @param fieldName
     * @return
     */
    boolean openNoRepeat(String corpId, String fieldName);


    OrderAmountConfResp getOrderAmountConf(Long bizId);

    /**
     * 获取商户下对应销售线下用户自定义的可用的业务字段
     *
     * @param bizId 商户id
     * @param productLineId 销售线id
     * @return 自定义业务字段
     */
    List<CrmLeadsConfigResp> getAllEnabledBusinessField(Long bizId, Long productLineId);
}
