package cn.kinyun.crm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@Data
public class MobileCustomerDataReq implements Serializable {

    private Long bizId;

    private Date startTime;

    private Date endTime;

    public void validateParams() {
        Preconditions.checkArgument(Objects.nonNull(bizId), "商户id不能为空");
        Preconditions.checkArgument(Objects.nonNull(startTime), "起始时间不能为空");
        Preconditions.checkArgument(Objects.nonNull(endTime), "结束时间不能为空");
    }
}
