package cn.kinyun.crm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author louis
 * @date 2023/2/27
 */
@Data
public class CustomerAreaReq implements Serializable {

    private static final long serialVersionUID = 4911427187265227113L;

    /**
     * 查询客户分布的类型
     */
    private Integer mapType;

    private Long bizId;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * customerNum
     */
    private List<String> customerNums;


    public void validateParam() {
        Preconditions.checkArgument(bizId != null, "商户id 不能为空");
        Preconditions.checkArgument(Objects.nonNull(startTime), "开始时间 不能为空");
        Preconditions.checkArgument(Objects.nonNull(endTime), "结束时间 不能为空");

    }


}
