/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service.dto.req;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/10/17
 */
@Data
public class CrmOrderReq implements Serializable {

    ///////// 成单人信息 /////////

    private Long bizId;// 商户ID
    private String corpId;// 企业ID
    private Long userId;// 成单用户唯一标识

    private String source;// 订单来源

    ///////// 客户信息 /////////

    private String mobile;// 成单客户的手机号
    private String name;// 成单客户的姓名

    ///////// 订单信息 /////////

    private String orderNo;// 订单编号（订单唯一标识）
    private Long orderAmount;// 订单价格（放大10000倍）
    private Long orderTime;// 订单时间（时间戳，精确到毫秒）
    private Long orderCreatorId;// 订单创建人
    private String orderRemark;// 订单备注信息

    ///////// 商品信息 /////////

    private String skuNo;// 商品编号（商品的唯一标识）
    private String skuName;// 商品名称（商品名称）

    ///////// 支付信息 /////////
    /**
     * 支付系统的收款编码、退款编码。
     *
     * <p>一个订单可能分多次收款，每次收款都会在支付系统产生一个编码。</p>
     *
     * <p>在处理消息队列中的订单消息时，可以通过这个字段来排重。</p>
     */
    private String tradeNo;
    private Integer tradeType;// 交易操作类型 0-收款, 1-退款
    private String tradeChannel;// 支付渠道（例如：现金、微信、支付宝等）
    private Long tradeAmount;// 支付/退款金额（放大10000倍）
    private Long tradeTime;// 支付/退款时间(时间戳，精确到毫秒)
    private String tradeRemark;// 支付备注信息

    ///////// 定制信息 /////////

    private Integer ruleType;// 规则类型
    private Long channelId;// 渠道id
    private Boolean inContract;// 是否进成交库

    private String releaseReason;

    public void validate() {
        // 成单人的信息
        Preconditions.checkArgument(bizId != null, "bizId is null");
        Preconditions.checkArgument(StringUtils.isNotBlank(corpId), "corpId is null");
        Preconditions.checkArgument(StringUtils.isNotBlank(mobile), "mobile is null");

        Preconditions.checkArgument(source != null, "source is null");

        // 订单的必填字段
        Preconditions.checkArgument(StringUtils.isNotBlank(orderNo), "orderNo is null");
        Preconditions.checkArgument(orderNo.length() <= 128, "orderNo is too long");
        Preconditions.checkArgument(orderAmount != null, "orderAmount is null");
        Preconditions.checkArgument(orderAmount >= 0, "orderAmount is negative.");

        // 订单的非必填字段
        Preconditions.checkArgument(orderTime == null || orderTime >= 0, "orderTime is negative");
        Preconditions.checkArgument(orderRemark == null || orderRemark.length() <= 512, "orderRemark it too long");

        // 交易信息的必填字段
        Preconditions.checkArgument(tradeAmount != null, "tradeAmount is null");
        Preconditions.checkArgument(tradeAmount >= 0, "tradeAmount is negative");
    }

}
