/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service;

import cn.kinyun.crm.common.service.dto.req.*;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.crm.common.service.dto.resp.LeadsChannelDataResp;
import cn.kinyun.crm.common.service.dto.resp.MobileCustomerDataResp;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/10/17
 */
public interface CrmLeadsService {

    /**
     * 查询线索
     *
     * @param params 线索信息
     * @return 线索ID
     */
    CrmLeadsInfoResp getLeads(CrmLeadsInfoReq params);

    /**
     * 查询线索
     *
     * @param params 线索信息
     * @return 线索ID
     */
    List<CrmLeadsInfoResp> getLeadsList(CrmLeadsInfoReq params);

    /**
     * 添加线索
     *
     * @param params 线索信息
     * @return 线索ID
     */
    CrmLeadsInfoResp addLeads(CrmLeadsReq params);

    /**
     * 修改线索手机号
     *
     * @param params 线索信息
     * @return 线索ID
     */
    void modAdLeads(CrmLeadsReq params);

    /**
     * 修改线索手机号
     *
     * @param params 线索信息
     * @return 线索ID
     */
    void modScrmLeads(CrmLeadsReq params);


    /**
     * 修改线索手机号
     *
     * @param params 线索信息
     * @return 线索ID
     */
    void modMobiles(CrmModMobileReq params);

    boolean exists(CrmLeadsInfoReq params);

    /**
     * 根据线索num查询分配情况
     *
     * @param bizId
     * @param leadsLibNums
     * @param productLineNum
     * @return
     */
    Map<String, String> getAllocTarget(Long bizId, String productLineNum, List<String> leadsLibNums);

    boolean existMobileOrNameByLeadsNum(CrmLeadsInfoReq params);

    List<CrmLeadsInfoResp> countLeadsByBindUserId(LeadsStatisticsReq param);

    List<CrmLeadsInfoResp> queryBindInfoByMobile(CrmLeadsInfoReq param);

    MobileCustomerDataResp getMobileCustomerDataByTime(MobileCustomerDataReq req);

    List<LeadsChannelDataResp> getChannelData(ChannelDataReq req);
    void modLeadsAndAllocateAllInfo(CrmLeadsReq leadsReq);

    void updateLeadsToFollowed(Long bizId, String contactId);
}