package cn.kinyun.crm.common.service.dto.req;

import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.Date;

/**
 * @author louis
 * @date 2023/1/16
 */
@Data
public class CrmWeworkContactRelationReq implements Serializable {

    private static final long serialVersionUID = -5475179583887754727L;


    private Long id;

    /**
     * 方案唯一编码，加密id
     */

    private String num;

    /**
     * 商户id
     */
    private Long bizId;

    /**
     * 企业ID
     */
    private String corpId;

    /**
     * 成员id
     */
    private String weworkUserId;

    /**
     * 外部联系人id 对应external_user
     */
    private String contactId;

    /**
     * 成员给好友的备注名
     */
    private String remark;

    /**
     * 描述
     */
    private String description;

    /**
     * 成员给客户备注的标签数量，便于统计无标签客户。
     */
    private Integer tagCount;

    /**
     * 成员给客户备注的手机号数量，便于统计无备注手机号的客户。
     */
    private Integer mobileCount;

    /**
     * 添加外部联系人的时间
     */
    private Date addTime;

    /**
     * 该成员对此客户备注的企业名称
     */
    private String remarkCorpName;

    /**
     * 发起添加的userid
     */
    private String operUserId;

    /**
     * 0	未知来源 1.扫描二维码 2	搜索手机号 3 名片分享 4	群聊 5	手机通讯录 6 微信联系人 7 来自微信的添加好友申请 8 安装第三方应用时自动添加的客服人员 9	搜索邮箱 201 内部成员共享 202 管理员/负责人分配
     */
    private Integer addWay;

    /**
     * 是否是僵尸粉  0 不是  1 是
     */
    private Integer isZombieFans;

    private Long createBy;

    private Date createTime;

    private Long updateBy;

    private Date updateTime;

    private Integer isDeleted;

    /**
     * 好友关系删除时间
     */
    private Date deletedTime;

    /**
     * 在系统中给客户添加的地区信息
     */
    private String region;

    /**
     * 好友关系来源数据类型
     */
    private String extType;

    /**
     * 好友关系来源数据id
     */
    private String extValue;
}
