/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * desc: 客户成交订单的交易类型
 *
 * @author yanmaoyuan
 * @date 2021/10/13
 */
public enum OrderTradeType {
    PAID(0, "收款"), REFUND(1, "退款");

    private static final Map<Integer, OrderTradeType> CACHE;

    static {
        CACHE = new HashMap<>();
        for (OrderTradeType e : values()) {
            CACHE.put(e.value, e);
        }
    }

    public static OrderTradeType getType(Integer value) {
        return CACHE.get(value);
    }

    private int value;
    private String desc;

    OrderTradeType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
