/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * desc: 客户来源
 *
 * @author yanmaoyuan
 * @date 2021/10/13
 */
public enum OrderSource {
    OPEN_API(0, "API对接"),
    TRADE_ORDER(1, "商品订单系统");

    private static final Map<Integer, OrderSource> CACHE;

    static {
        CACHE = new HashMap<>();
        for (OrderSource e : values()) {
            CACHE.put(e.value, e);
        }
    }

    public static OrderSource getType(Integer value) {
        return CACHE.get(value);
    }

    private int value;
    private String desc;

    OrderSource(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
