package cn.kinyun.crm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum MapTypeEnum {

    CUSTOMER_MAP(0, "总客户分布"),
    ORDER_MAP(1, "总成交分布");

    private static final Map<Integer, MapTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (MapTypeEnum e : values()) {
            CACHE.put(e.getValue(), e);
        }
    }

    public static MapTypeEnum getByValue(int value) {
        return CACHE.get(value);
    }


    private int value;
    private String desc;

    MapTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
