/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/10/30
 */
public enum LeadsFieldType {
    TEXT(0, "文本"),
    INTEGER(1, "整数"),
    FLOAT(2, "浮点数"),
    DATE(3, "日期"),
    SELECT(4, "单选文本"),
    MULTI_SELECT(5, "多选文本"),
    DATETIME(6, "日期时间");

    final int value;
    final String desc;

    LeadsFieldType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    static final Map<Integer, LeadsFieldType> CACHE;

    static {
        CACHE = new HashMap<>();
        for (LeadsFieldType e : values()) {
            CACHE.put(e.value, e);
        }
    }

    public static LeadsFieldType getType(Integer value) {
        return CACHE.get(value);
    }
}