/*
 * kinyun.cn Inc.
 * Copyright (c) 2021. All Rights Reserved.
 */
package cn.kinyun.crm.common.service;

import cn.kinyun.crm.common.service.dto.resp.CrmProductLineResp;

import java.util.List;

/**
 * @author yanmaoyuan
 * @date 2021/10/17
 */
public interface CrmProductLineService {

    /**
     * 查询销售线列表
     *
     * @param bizId 商户ID
     * @return 商户下的所有销售线
     */
    List<CrmProductLineResp> getListByBizId(Long bizId);

    /**
     * 查询销售线
     *
     * @param bizId 商户ID
     * @param num   唯一编号
     * @return 销售线
     */
    CrmProductLineResp getByNum(Long bizId, String num);

    /**
     * 查询销售线
     *
     * @param bizId 商户ID
     * @param id    唯一ID
     * @return 销售线
     */
    CrmProductLineResp getById(Long bizId, Long id);


    /**
     * 若传入了销售线ID，校验销售线ID的有效性
     * 若没有传入销售线ID，则返回1个销售线。
     *
     * @param bizId          商户ID
     * @param productLineNum 销售线ID，可以传入null。若传入null且商户只有一个销售线，将会返回这个销售线ID。
     * @return 销售线ID
     */
    String validateProductLineNum(Long bizId, String productLineNum);
}