/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.canal.service;

import cn.kinyun.crm.common.service.CrmWeworkCRService;
import cn.kinyun.crm.common.service.dto.req.CrmWeworkContactRelationReq;
import cn.kinyun.crm.dal.util.BizTableContext;
import cn.kinyun.crm.dal.wework.entity.WeworkContactRelation;
import cn.kinyun.crm.dal.wework.mapper.WeworkContactRelationMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmWeworkCRServiceImpl
implements CrmWeworkCRService {
    private static final Logger log = LoggerFactory.getLogger(CrmWeworkCRServiceImpl.class);
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;

    public void butchUpdateHistoryWeworkContactRelation(List<CrmWeworkContactRelationReq> weworkContactRelation) {
        log.info("crm weworkContactRelation \u63d2\u5165\u64cd\u4f5c\uff1a{}", weworkContactRelation);
        if (CollectionUtils.isEmpty(weworkContactRelation)) {
            log.error("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        List contactRelations = weworkContactRelation.stream().filter(item -> Objects.nonNull(item.getId()) && Objects.nonNull(item.getBizId())).map(item -> {
            WeworkContactRelation contactRelation = new WeworkContactRelation();
            BeanUtils.copyProperties((Object)item, (Object)contactRelation);
            return contactRelation;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contactRelations)) {
            log.error("\u5408\u6cd5\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        Long bizId = ((WeworkContactRelation)contactRelations.stream().findFirst().get()).getBizId();
        BizTableContext.putBizId((Long)bizId);
        List relationIds = contactRelations.stream().map(WeworkContactRelation::getId).collect(Collectors.toList());
        List existRelationIds = this.weworkContactRelationMapper.selectByIdAndCorpId(bizId, relationIds);
        ArrayList toAdd = Lists.newArrayList();
        try {
            for (WeworkContactRelation contactRelation : contactRelations) {
                if (existRelationIds.contains(contactRelation.getId())) {
                    this.weworkContactRelationMapper.updateById((Object)contactRelation);
                    continue;
                }
                toAdd.add(contactRelation);
            }
            if (CollectionUtils.isNotEmpty((Collection)toAdd)) {
                this.weworkContactRelationMapper.insertBatch((Collection)toAdd);
            }
        }
        catch (Exception e) {
            log.error("update weworkContactRelation exception:{}", (Object)e.getMessage());
        }
    }
}

