/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.canal.handler;

import cn.kinyun.crm.canal.CanalMessage;
import cn.kinyun.crm.canal.annotation.CanalDataFetchHandle;
import cn.kinyun.crm.canal.entity.CanalWeworkCR;
import cn.kinyun.crm.canal.handler.AbstractCanalFetchHandler;
import cn.kinyun.crm.dal.wework.entity.WeworkContactRelation;
import cn.kinyun.crm.dal.wework.mapper.WeworkContactRelationMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
@CanalDataFetchHandle(tableName={"wework_contact_relation"})
public class WeworkCRHandler
extends AbstractCanalFetchHandler<CanalWeworkCR> {
    private static final Logger log = LoggerFactory.getLogger(WeworkCRHandler.class);
    @Resource
    private WeworkContactRelationMapper weworkContactRelationMapper;

    @Override
    public void insert(CanalMessage<CanalWeworkCR> canalMessage) {
        log.info("canal consumer case insert");
        List<CanalWeworkCR> entityList = canalMessage.getData();
        for (CanalWeworkCR canalWeworkCR : entityList) {
            WeworkContactRelation wcr = new WeworkContactRelation();
            BeanUtils.copyProperties((Object)canalWeworkCR, (Object)wcr);
            WeworkContactRelation contactRelation = this.weworkContactRelationMapper.selectAllByContactIdAndUserIdAndBizId(wcr.getBizId(), wcr.getWeworkUserId(), wcr.getContactId());
            if (Objects.nonNull(contactRelation)) {
                log.error("\u5f53\u524d\u5546\u6237\u4e0b \u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u63d2\u5165\u6570\u636e bizId:{},weworkUserId:{},contactId:{}", new Object[]{wcr.getBizId(), wcr.getWeworkUserId(), wcr.getContactId()});
                continue;
            }
            this.weworkContactRelationMapper.insert((Object)wcr);
        }
    }

    @Override
    public void update(CanalMessage<CanalWeworkCR> canalMessage) {
        log.info("canal consumer case update");
        CanalWeworkCR canalWeworkCR = canalMessage.getData().get(0);
        if (Objects.isNull(canalWeworkCR)) {
            log.error("canal \u4f20\u9001\u7684\u6570\u636e\u5b9e\u4f53\u4e3a\u7a7a");
            return;
        }
        List<CanalWeworkCR> oldList = canalMessage.getOld();
        WeworkContactRelation wcr = this.voToEntity(canalWeworkCR);
        WeworkContactRelation contactRelation = this.weworkContactRelationMapper.selectAllByContactIdAndUserIdAndBizId(wcr.getBizId(), wcr.getWeworkUserId(), wcr.getContactId());
        if (Objects.isNull(contactRelation)) {
            log.info("canal \u6570\u636e\u4e3a\u66f4\u65b0\u60c5\u51b5\u4e0b\uff0c\u5355\u6570crm \u4e2d\u6ca1\u6709\u627e\u5230\u6570\u636e: weworkContactRelation id:{}", (Object)wcr.getId());
            this.weworkContactRelationMapper.insert((Object)wcr);
            return;
        }
        if (CollectionUtils.isNotEmpty(oldList) && Objects.nonNull(oldList.get(0).getId()) && !canalWeworkCR.getId().equals(oldList.get(0).getId())) {
            this.weworkContactRelationMapper.update((Object)wcr, (Wrapper)Wrappers.update().eq((Object)"id", (Object)oldList.get(0).getId()));
            return;
        }
        if (Objects.isNull(wcr.getUpdateTime()) || Objects.isNull(contactRelation.getUpdateTime()) || wcr.getUpdateTime().getTime() < contactRelation.getUpdateTime().getTime()) {
            log.info("canal \u6570\u636e\u66f4\u65b0\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u6570\u636e\u66f4\u65b0\u65f6\u95f4\uff0c\u5ffd\u7565\u6267\u884c");
            return;
        }
        wcr.setId(contactRelation.getId());
        this.weworkContactRelationMapper.updateById((Object)wcr);
    }

    @Override
    public void delete(CanalMessage<CanalWeworkCR> canalMessage) {
        log.info("canal consumer case delete");
        CanalWeworkCR wcr = canalMessage.getData().get(0);
        WeworkContactRelation contactRelation = this.weworkContactRelationMapper.selectAllByContactIdAndUserIdAndBizId(wcr.getBizId(), wcr.getWeworkUserId(), wcr.getContactId());
        if (Objects.isNull(contactRelation)) {
            log.error("\u5f53\u524d\u6d88\u606f\u672a\u627e\u5230\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\uff1abizId:{}; weworkUserId:{}; contactId:{}", new Object[]{wcr.getBizId(), wcr.getWeworkUserId(), wcr.getContactId()});
            return;
        }
        this.weworkContactRelationMapper.deleteById((Object)contactRelation);
    }

    public WeworkContactRelation voToEntity(CanalWeworkCR canalWeworkCR) {
        WeworkContactRelation weworkContactRelation = new WeworkContactRelation();
        BeanUtils.copyProperties((Object)canalWeworkCR, (Object)weworkContactRelation);
        return weworkContactRelation;
    }
}

