/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.crm.canal.handler;

import cn.kinyun.crm.canal.CanalMessage;
import cn.kinyun.crm.canal.annotation.CanalDataFetchHandle;
import cn.kinyun.crm.canal.entity.CanalGlobalLib;
import cn.kinyun.crm.canal.handler.AbstractCanalFetchHandler;
import cn.kinyun.crm.common.enums.CanalGlobalMsgType;
import cn.kinyun.crm.dal.leads.entity.GlobalLib;
import cn.kinyun.crm.dal.leads.entity.LeadsLib;
import cn.kinyun.crm.dal.leads.mapper.GlobalLibMapper;
import cn.kinyun.crm.dal.leads.mapper.LeadsLibMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@CanalDataFetchHandle(tableName={"leads_binding_info", "public_lib", "dept_lib", "abandon_lib", "raw_leads_lib"})
public class CrmGlobalLibHandler
extends AbstractCanalFetchHandler<CanalGlobalLib> {
    private static final Logger log = LoggerFactory.getLogger(CrmGlobalLibHandler.class);
    @Autowired
    private GlobalLibMapper globalLibMapper;
    @Autowired
    private LeadsLibMapper leadsLibMapper;
    @Value(value="${crm.globalLib.partition.count:300}")
    private int partitionCount;

    @Override
    public void insert(CanalMessage<CanalGlobalLib> canalMessage) {
        log.info("insert: \u5199\u5165\u5168\u5c40\u8868, canalMessageId:{}", (Object)canalMessage.getId());
        this.insertOrUpdateCanalMsg(canalMessage);
    }

    @Override
    public void update(CanalMessage<CanalGlobalLib> canalMessage) {
        log.info("update: \u66f4\u65b0\u5168\u5c40\u8868, canalMessageId:{}", (Object)canalMessage.getId());
        this.insertOrUpdateCanalMsg(canalMessage);
    }

    private void insertOrUpdateCanalMsg(CanalMessage<CanalGlobalLib> canalMessage) {
        List<CanalGlobalLib> reqEntityList = canalMessage.getData();
        if (CollectionUtils.isEmpty(reqEntityList)) {
            log.warn("insertOrUpdateCanalMsg: \u6570\u636e\u4e3a\u7a7a");
            return;
        }
        String tableName = canalMessage.getTable();
        CanalGlobalMsgType canalGlobalMsgType = CanalGlobalMsgType.getType((String)tableName);
        if (canalGlobalMsgType == null) {
            log.warn("insertOrUpdateCanalMsg: \u8868\u540d\u9519\u8bef\uff0ctableName = {}", (Object)tableName);
            return;
        }
        Map<Long, List<CanalGlobalLib>> listMap = reqEntityList.stream().collect(Collectors.groupingBy(CanalGlobalLib::getBizId));
        for (Map.Entry<Long, List<CanalGlobalLib>> entry : listMap.entrySet()) {
            this.insertOrUpdateDb(tableName, entry.getKey(), entry.getValue());
        }
    }

    private void insertOrUpdateDb(String tableName, Long bizId, List<CanalGlobalLib> entityList) {
        log.info("insertOrUpdateDb: tableName:{}, bizId:{}, entityList:{}", new Object[]{tableName, bizId, entityList});
        HashSet queryNums = Sets.newHashSet();
        HashSet reqLeadsIds = Sets.newHashSet();
        for (CanalGlobalLib entity : entityList) {
            entity.validate(tableName);
            queryNums.add(entity.getNum());
            reqLeadsIds.add(entity.getLeadsId());
        }
        List reqLeadsList = this.leadsLibMapper.getByIds(bizId, (Collection)reqLeadsIds);
        Map<Long, Long> id2CustomerIdMap = reqLeadsList.stream().collect(Collectors.toMap(LeadsLib::getId, LeadsLib::getCustomerId));
        List existList = this.globalLibMapper.selectList((Wrapper)((QueryWrapper)Wrappers.query().eq((Object)"biz_id", (Object)bizId)).in((Object)"num", (Collection)queryNums));
        Map<String, GlobalLib> existGlobalMap = existList.stream().collect(Collectors.toMap(GlobalLib::getNum, a -> a, (k1, k2) -> k2));
        ArrayList insertList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (CanalGlobalLib reqGlobalLib : entityList) {
            String num = reqGlobalLib.getNum();
            Long leadsId = reqGlobalLib.getLeadsId();
            Long customerId = id2CustomerIdMap.get(leadsId);
            if (existGlobalMap.containsKey(num)) {
                GlobalLib existGlobalLib = existGlobalMap.get(num);
                this.updateGlobalLib(existGlobalLib, reqGlobalLib);
                if (customerId != null) {
                    existGlobalLib.setCustomerId(customerId);
                }
                updateList.add(existGlobalLib);
                continue;
            }
            GlobalLib newGlobalLib = this.newGlobalLib(reqGlobalLib);
            if (customerId != null) {
                newGlobalLib.setCustomerId(customerId);
            }
            insertList.add(newGlobalLib);
        }
        log.info("insertOrUpdateDb: \u65b0\u589e\u6216\u66f4\u65b0\u6570\u636e\uff0cinsertList:{}, updateList:{}", (Object)insertList, (Object)updateList);
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            Lists.partition((List)insertList, (int)this.partitionCount).forEach(list -> this.globalLibMapper.batchInsert(list));
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            Lists.partition((List)updateList, (int)this.partitionCount).forEach(list -> this.globalLibMapper.batchUpdate(list));
        }
    }

    private void deleteDb(String tableName, Long bizId, List<CanalGlobalLib> entityList) {
        log.info("deleteDb: tableName:{}, bizId:{}, entityList:{}", new Object[]{tableName, bizId, entityList});
        List queryNums = entityList.stream().map(CanalGlobalLib::getNum).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        log.info("deleteDb: \u5220\u9664\u6570\u636e\uff0cbizId:{}, queryNums:{}", (Object)bizId, queryNums);
        if (CollectionUtils.isNotEmpty(queryNums)) {
            Lists.partition(queryNums, (int)this.partitionCount).forEach(list -> this.globalLibMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"biz_id", (Object)bizId)).in((Object)"num", (Collection)list)));
        }
    }

    @Override
    public void delete(CanalMessage<CanalGlobalLib> canalMessage) {
        log.info("delete: \u5220\u9664\u5168\u5c40\u8868, canalMessageId:{}", (Object)canalMessage.getId());
        List<CanalGlobalLib> reqEntityList = canalMessage.getData();
        if (CollectionUtils.isEmpty(reqEntityList)) {
            log.warn("delete: \u6570\u636e\u4e3a\u7a7a");
            return;
        }
        String tableName = canalMessage.getTable();
        CanalGlobalMsgType canalGlobalMsgType = CanalGlobalMsgType.getType((String)tableName);
        if (canalGlobalMsgType == null) {
            log.warn("delete: \u8868\u540d\u9519\u8bef\uff0ctableName = {}", (Object)tableName);
            return;
        }
        Map<Long, List<CanalGlobalLib>> listMap = reqEntityList.stream().collect(Collectors.groupingBy(CanalGlobalLib::getBizId));
        for (Map.Entry<Long, List<CanalGlobalLib>> entry : listMap.entrySet()) {
            this.deleteDb(tableName, entry.getKey(), entry.getValue());
        }
    }

    private GlobalLib newGlobalLib(CanalGlobalLib canalGlobalLib) {
        GlobalLib globalLib = new GlobalLib();
        globalLib.setBizId(canalGlobalLib.getBizId());
        globalLib.setTbName(canalGlobalLib.getTbName());
        globalLib.setTbId(canalGlobalLib.getId());
        globalLib.setNum(canalGlobalLib.getNum());
        globalLib.setJoinDeptLibId(canalGlobalLib.getJoinDeptLibId());
        globalLib.setJoinPublicLibId(canalGlobalLib.getJoinPublicLibId());
        globalLib.setJoinAbandonLibId(canalGlobalLib.getJoinAbandonLibId());
        globalLib.setJoinRawLeadsLibId(canalGlobalLib.getJoinRawLeadsLibId());
        globalLib.setJoinLeadsBindingInfoId(canalGlobalLib.getJoinLeadsBindingInfoId());
        globalLib.setLeadsId(canalGlobalLib.getLeadsId());
        globalLib.setCreateBy(canalGlobalLib.getCreateBy());
        globalLib.setCreateTime(canalGlobalLib.getCreateTime());
        globalLib.setUpdateBy(canalGlobalLib.getUpdateBy());
        globalLib.setUpdateTime(canalGlobalLib.getUpdateTime());
        return globalLib;
    }

    private void updateGlobalLib(GlobalLib oldLib, CanalGlobalLib newLib) {
        oldLib.setLeadsId(newLib.getLeadsId());
        oldLib.setJoinDeptLibId(newLib.getJoinDeptLibId());
        oldLib.setJoinPublicLibId(newLib.getJoinPublicLibId());
        oldLib.setJoinAbandonLibId(newLib.getJoinAbandonLibId());
        oldLib.setJoinRawLeadsLibId(newLib.getJoinRawLeadsLibId());
        oldLib.setJoinLeadsBindingInfoId(newLib.getJoinLeadsBindingInfoId());
        oldLib.setCreateBy(newLib.getCreateBy());
        oldLib.setCreateTime(newLib.getCreateTime());
        oldLib.setUpdateBy(newLib.getUpdateBy());
        oldLib.setUpdateTime(newLib.getUpdateTime());
    }
}

