/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.log;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.IUser;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.core.serialize.SerializeFactory;
import cn.hangar.agp.platform.utils.GeneralUtil;
import cn.hangar.agp.service.log.AgpLogLevel;
import cn.hangar.agp.service.log.IAgpLogInfo;
import cn.hangar.agp.service.log.IAgpLogger;
import cn.hangar.agp.service.log.ILogApiBuilder;
import cn.hangar.agp.service.log.ILogConfigBuilder;
import cn.hangar.agp.service.log.ILogFlowBuilder;
import cn.hangar.agp.service.log.ILogInfoBuilder;
import cn.hangar.agp.service.log.ILogProgressBuilder;
import cn.hangar.agp.service.log.ILogSqlBuilder;
import cn.hangar.agp.service.log.ILogTimeTaskBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleAgpLogger
implements IAgpLogger {
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void log(Map<String, Object> config, IAgpLogInfo info) {
        String pre = "";
        if (info.getLevel() == AgpLogLevel.Info) {
            this.logger.info(String.format("%s %s", pre, SerializeFactory.toJson((Object)info.getContent(), (boolean)true)));
        }
        if (info.getLevel() == AgpLogLevel.Warn) {
            this.logger.warn(String.format("%s %s", pre, SerializeFactory.toJson((Object)info.getContent(), (boolean)true)));
        }
        if (info.getLevel() == AgpLogLevel.Error) {
            this.logger.error(String.format("%s %s", pre, SerializeFactory.toJson((Object)info.getContent(), (boolean)true)));
        }
    }

    @Override
    public <T extends ILogInfoBuilder> T newBuilder(Class<T> clazz) {
        return (T)new SimpleLogBuilder();
    }

    class SimpleLogBuilder
    extends ALogInfoBuilder
    implements ILogSqlBuilder,
    ILogApiBuilder,
    ILogTimeTaskBuilder,
    ILogFlowBuilder,
    ILogConfigBuilder,
    ILogProgressBuilder {
        SimpleLogBuilder() {
        }

        @Override
        public ILogSqlBuilder sql(String dbName, String sql, Map<String, Object> sqlParam) {
            this.logInfo("db", dbName);
            this.logInfo("sql", sql);
            this.logInfo("sqlParam", sqlParam != null && !sqlParam.isEmpty() ? sqlParam : null);
            return this;
        }

        @Override
        public ILogSqlBuilder resultCount(int count) {
            return (ILogSqlBuilder)this.logInfo("count", count);
        }

        @Override
        public ILogApiBuilder api(String apiName, Object apiParam) {
            this.logInfo("apiName", apiName);
            if (apiParam != null) {
                this.logInfo("apiParam", apiParam);
            }
            return this;
        }
    }

    abstract class ALogInfoBuilder
    implements ILogInfoBuilder {
        protected AgpLogInfo logInfo = new AgpLogInfo();
        protected Map<String, Object> infos = new ConcurrentHashMap<String, Object>();
        protected Map<String, Object> config = new HashMap<String, Object>();

        ALogInfoBuilder() {
        }

        @Override
        public <T extends ILogInfoBuilder> T config(String k, Object v) {
            if (k != null) {
                this.config.put(k, v);
            }
            return (T)this;
        }

        @Override
        public Map<String, Object> getConfig() {
            return this.config;
        }

        @Override
        public IAgpLogInfo build() {
            AgpLogInfo logInfo = this.logInfo.clone();
            logInfo.setAppId(AppContext.getCurrentAppId());
            logInfo.setClient(AppContext.Current().getDbgKey());
            logInfo.setGroup(AppContext.Current().getId());
            IUser user = AppContext.getCurrentUser();
            if (user != null) {
                logInfo.setUserId(user.getId());
                logInfo.setUserId(user.getName());
            }
            this.infos.put("_id", GeneralUtil.UUID());
            logInfo.setContent(this.infos);
            logInfo.setLogType(this.getLogType());
            return logInfo;
        }

        protected String getLogType() {
            return this.getClass().getSimpleName();
        }

        @Override
        public <T extends ILogInfoBuilder> T threadInfo(String threadInfo) {
            return this.logInfo("threadInfo", threadInfo);
        }

        @Override
        public <T extends ILogInfoBuilder> T start(Date start) {
            this.logInfo.setStart(start);
            return (T)this;
        }

        @Override
        public <T extends ILogInfoBuilder> T end(Date end) {
            this.logInfo.setEnd(end);
            return (T)this;
        }

        @Override
        public <T extends ILogInfoBuilder> T execTime(long exectime) {
            return this.logInfo("exectime", exectime + "ms");
        }

        @Override
        public <T extends ILogInfoBuilder> T msg(String msg) {
            return this.logInfo("msg", msg);
        }

        @Override
        public <T extends ILogInfoBuilder> T dbInfo(String dbInfo) {
            return this.logInfo("dbInfo", dbInfo);
        }

        @Override
        public <T extends ILogInfoBuilder> T serverInfo(String serverInfo) {
            return this.logInfo("serverInfo", serverInfo);
        }

        @Override
        public <T extends ILogInfoBuilder> T logInfo(String key, Object value) {
            if (value == null) {
                this.infos.remove(key);
            } else {
                this.infos.put(key, value);
            }
            return (T)this;
        }

        @Override
        public <T extends ILogInfoBuilder> T reset() {
            this.logInfo = new AgpLogInfo();
            this.infos.clear();
            return (T)this;
        }
    }

    public static class AgpLogInfo
    implements IAgpLogInfo,
    Cloneable {
        String group;
        String appId;
        String userId;
        String userName;
        Date start;
        Date end;
        String logType;
        AgpLogLevel level;
        Object content;
        transient String client;

        public AgpLogInfo clone() {
            AgpLogInfo agpInfo = (AgpLogInfo)SerializeFactory.clone((Object)this);
            agpInfo.setClient(this.client);
            return agpInfo;
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public String getAppId() {
            return this.appId;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        public String getUserName() {
            return this.userName;
        }

        public Date getStart() {
            return this.start;
        }

        public Date getEnd() {
            return this.end;
        }

        @Override
        public String getLogType() {
            return this.logType;
        }

        @Override
        public AgpLogLevel getLevel() {
            return this.level;
        }

        @Override
        public Object getContent() {
            return this.content;
        }

        @Override
        public String getClient() {
            return this.client;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setStart(Date start) {
            this.start = start;
        }

        public void setEnd(Date end) {
            this.end = end;
        }

        public void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public void setLevel(AgpLogLevel level) {
            this.level = level;
        }

        public void setContent(Object content) {
            this.content = content;
        }

        public void setClient(String client) {
            this.client = client;
        }
    }
}

