/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.log;

import cn.hangar.agp.platform.core.log.Logger;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.util.StringTokenizer;

public class LogInfoHelper {
    public static String getDbInfo() {
        return null;
    }

    public static String getServerInfo() {
        MonitorInfoBean monitorInfo;
        cpu c = new cpu();
        StringBuilder sb = new StringBuilder();
        try {
            monitorInfo = c.getMonitorInfoBean();
        }
        catch (Exception e) {
            Logger.error(LogInfoHelper.class, (Throwable)e);
            return "";
        }
        sb.append(String.format("os: %s ", monitorInfo.getOsName()));
        sb.append(String.format("free mem: %sMb(%s%%) ", monitorInfo.getFreeMemory() / 1000L, monitorInfo.getFreeMemory() * 100L / monitorInfo.getTotalMemorySize()));
        sb.append(String.format("threads: %s ", monitorInfo.getTotalThread()));
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        cpu c = new cpu();
        MonitorInfoBean monitorInfo = c.getMonitorInfoBean();
        System.out.println("cpu\u5360\u6709\u7387=" + monitorInfo.getCpuRatio());
        System.out.println("\u53ef\u4f7f\u7528\u5185\u5b58=" + monitorInfo.getTotalMemory());
        System.out.println("\u5269\u4f59\u5185\u5b58=" + monitorInfo.getFreeMemory());
        System.out.println("\u6700\u5927\u53ef\u4f7f\u7528\u5185\u5b58=" + monitorInfo.getMaxMemory());
        System.out.println("\u64cd\u4f5c\u7cfb\u7edf=" + monitorInfo.getOsName());
        System.out.println("\u603b\u7684\u7269\u7406\u5185\u5b58=" + monitorInfo.getTotalMemorySize() + "kb");
        System.out.println("\u5269\u4f59\u7684\u7269\u7406\u5185\u5b58=" + monitorInfo.getFreeMemory() + "kb");
        System.out.println("\u5df2\u4f7f\u7528\u7684\u7269\u7406\u5185\u5b58=" + monitorInfo.getUsedMemory() + "kb");
        System.out.println("\u7ebf\u7a0b\u603b\u6570=" + monitorInfo.getTotalThread());
    }

    static class Bytes {
        Bytes() {
        }

        public static String substring(String src, int start_idx, int end_idx) {
            byte[] b = src.getBytes();
            String tgt = "";
            for (int i = start_idx; i <= end_idx; ++i) {
                tgt = tgt + (char)b[i];
            }
            return tgt;
        }
    }

    public static class MonitorInfoBean {
        private long totalMemory;
        private long freeMemory;
        private long maxMemory;
        private String osName;
        private long totalMemorySize;
        private long freePhysicalMemorySize;
        private long usedMemory;
        private int totalThread;
        private double cpuRatio;

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public void setFreeMemory(long freeMemory) {
            this.freeMemory = freeMemory;
        }

        public long getFreePhysicalMemorySize() {
            return this.freePhysicalMemorySize;
        }

        public void setFreePhysicalMemorySize(long freePhysicalMemorySize) {
            this.freePhysicalMemorySize = freePhysicalMemorySize;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }

        public void setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
        }

        public String getOsName() {
            return this.osName;
        }

        public void setOsName(String osName) {
            this.osName = osName;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public void setTotalMemory(long totalMemory) {
            this.totalMemory = totalMemory;
        }

        public long getTotalMemorySize() {
            return this.totalMemorySize;
        }

        public void setTotalMemorySize(long totalMemorySize) {
            this.totalMemorySize = totalMemorySize;
        }

        public int getTotalThread() {
            return this.totalThread;
        }

        public void setTotalThread(int totalThread) {
            this.totalThread = totalThread;
        }

        public long getUsedMemory() {
            return this.usedMemory;
        }

        public void setUsedMemory(long usedMemory) {
            this.usedMemory = usedMemory;
        }

        public double getCpuRatio() {
            return this.cpuRatio;
        }

        public void setCpuRatio(double cpuRatio) {
            this.cpuRatio = cpuRatio;
        }
    }

    public static class cpu {
        private static final int CPUTIME = 30;
        private static final int PERCENT = 100;
        private static final int FAULTLENGTH = 10;
        private static String linuxVersion = null;

        public double getCpuRatio() {
            String osName = System.getProperty("os.name");
            if (osName.toLowerCase().startsWith("windows")) {
                return this.getCpuRatioForWindows();
            }
            return this.getCpuRateForLinux();
        }

        public MonitorInfoBean getMonitorInfoBean() throws Exception {
            int kb = 1024;
            long totalMemory = Runtime.getRuntime().totalMemory() / (long)kb;
            long freeMemory = Runtime.getRuntime().freeMemory() / (long)kb;
            long maxMemory = Runtime.getRuntime().maxMemory() / (long)kb;
            OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            String osName = System.getProperty("os.name");
            long totalMemorySize = osmxb.getTotalPhysicalMemorySize() / (long)kb;
            long freePhysicalMemorySize = osmxb.getFreePhysicalMemorySize() / (long)kb;
            long usedMemory = (osmxb.getTotalPhysicalMemorySize() - osmxb.getFreePhysicalMemorySize()) / (long)kb;
            ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
            while (parentThread.getParent() != null) {
                parentThread = parentThread.getParent();
            }
            int totalThread = parentThread.activeCount();
            double cpuRatio = osmxb.getSystemCpuLoad();
            MonitorInfoBean infoBean = new MonitorInfoBean();
            infoBean.setFreeMemory(freeMemory);
            infoBean.setFreePhysicalMemorySize(freePhysicalMemorySize);
            infoBean.setMaxMemory(maxMemory);
            infoBean.setOsName(osName);
            infoBean.setTotalMemory(totalMemory);
            infoBean.setTotalMemorySize(totalMemorySize);
            infoBean.setTotalThread(totalThread);
            infoBean.setUsedMemory(usedMemory);
            infoBean.setCpuRatio(cpuRatio);
            return infoBean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static double getCpuRateForLinux() {
            double d;
            StringTokenizer tokenStat;
            BufferedReader brStat;
            InputStreamReader isr;
            InputStream is;
            block5: {
                is = null;
                isr = null;
                brStat = null;
                tokenStat = null;
                System.out.println("Get usage rate of CUP , linux version: " + linuxVersion);
                Process process = Runtime.getRuntime().exec("top -b -n 1");
                is = process.getInputStream();
                isr = new InputStreamReader(is);
                brStat = new BufferedReader(isr);
                if (!linuxVersion.equals("2.4")) break block5;
                brStat.readLine();
                brStat.readLine();
                brStat.readLine();
                brStat.readLine();
                tokenStat = new StringTokenizer(brStat.readLine());
                tokenStat.nextToken();
                tokenStat.nextToken();
                String user = tokenStat.nextToken();
                tokenStat.nextToken();
                String system = tokenStat.nextToken();
                tokenStat.nextToken();
                String nice = tokenStat.nextToken();
                System.out.println(user + " , " + system + " , " + nice);
                user = user.substring(0, user.indexOf("%"));
                system = system.substring(0, system.indexOf("%"));
                nice = nice.substring(0, nice.indexOf("%"));
                float userUsage = new Float(user).floatValue();
                float systemUsage = new Float(system).floatValue();
                float niceUsage = new Float(nice).floatValue();
                double d2 = (userUsage + systemUsage + niceUsage) / 100.0f;
                cpu.freeResource(is, isr, brStat);
                return d2;
            }
            try {
                brStat.readLine();
                brStat.readLine();
                tokenStat = new StringTokenizer(brStat.readLine());
                tokenStat.nextToken();
                tokenStat.nextToken();
                tokenStat.nextToken();
                tokenStat.nextToken();
                tokenStat.nextToken();
                tokenStat.nextToken();
                tokenStat.nextToken();
                String cpuUsage = tokenStat.nextToken();
                System.out.println("CPU idle : " + cpuUsage);
                Float usage = new Float(cpuUsage.substring(0, cpuUsage.indexOf("%")));
                d = 1.0f - usage.floatValue() / 100.0f;
            }
            catch (IOException ioe) {
                double d3;
                try {
                    System.out.println(ioe.getMessage());
                    cpu.freeResource(is, isr, brStat);
                    d3 = 1.0;
                }
                catch (Throwable throwable) {
                    cpu.freeResource(is, isr, brStat);
                    throw throwable;
                }
                cpu.freeResource(is, isr, brStat);
                return d3;
            }
            cpu.freeResource(is, isr, brStat);
            return d;
        }

        private static void freeResource(InputStream is, InputStreamReader isr, BufferedReader br) {
            try {
                if (is != null) {
                    is.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }

        private double getCpuRatioForWindows() {
            try {
                String procCmd = System.getenv("windir") + "\\system32\\wbem\\wmic.exe process get Caption,CommandLine,KernelModeTime,ReadOperationCount,ThreadCount,UserModeTime,WriteOperationCount";
                long[] c0 = this.readCpu(Runtime.getRuntime().exec(procCmd));
                Thread.sleep(30L);
                long[] c1 = this.readCpu(Runtime.getRuntime().exec(procCmd));
                if (c0 != null && c1 != null) {
                    long idletime = c1[0] - c0[0];
                    long busytime = c1[1] - c0[1];
                    return 100L * busytime / (busytime + idletime);
                }
                return 0.0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0.0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long[] readCpu(Process proc) {
            long[] retn = new long[2];
            try {
                proc.getOutputStream().close();
                InputStreamReader ir = new InputStreamReader(proc.getInputStream());
                LineNumberReader input = new LineNumberReader(ir);
                String line = input.readLine();
                if (line == null || line.length() < 10) {
                    long[] lArray = null;
                    return lArray;
                }
                int capidx = line.indexOf("Caption");
                int cmdidx = line.indexOf("CommandLine");
                int rocidx = line.indexOf("ReadOperationCount");
                int umtidx = line.indexOf("UserModeTime");
                int kmtidx = line.indexOf("KernelModeTime");
                int wocidx = line.indexOf("WriteOperationCount");
                long idletime = 0L;
                long kneltime = 0L;
                long usertime = 0L;
                while ((line = input.readLine()) != null) {
                    if (line.length() < wocidx) continue;
                    String caption = Bytes.substring(line, capidx, cmdidx - 1).trim();
                    String cmd = Bytes.substring(line, cmdidx, kmtidx - 1).trim();
                    if (cmd.indexOf("wmic.exe") >= 0) continue;
                    if (caption.equals("System Idle Process") || caption.equals("System")) {
                        idletime += Long.valueOf(Bytes.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                        idletime += Long.valueOf(Bytes.substring(line, umtidx, wocidx - 1).trim()).longValue();
                        continue;
                    }
                    kneltime += Long.valueOf(Bytes.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                    usertime += Long.valueOf(Bytes.substring(line, umtidx, wocidx - 1).trim()).longValue();
                }
                retn[0] = idletime;
                retn[1] = kneltime + usertime;
                long[] lArray = retn;
                return lArray;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    proc.getInputStream().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

