/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.log;

import cn.hangar.agp.platform.core.log.ThrowableToString;
import cn.hangar.agp.service.log.IAgpLogInfo;
import cn.hangar.agp.service.log.IAgpLogger;
import java.util.Date;
import java.util.Map;

public interface ILogInfoBuilder {
    public IAgpLogInfo build();

    public <T extends ILogInfoBuilder> T config(String var1, Object var2);

    default public <T extends ILogInfoBuilder> T needConsole(boolean needConsole) {
        return this.config("_needAgpLogConsole", needConsole);
    }

    default public <T extends ILogInfoBuilder> T noLog(boolean noLog) {
        return this.config("_noAgpLog", noLog);
    }

    public Map<String, Object> getConfig();

    public <T extends ILogInfoBuilder> T start(Date var1);

    default public <T extends ILogInfoBuilder> T start() {
        return this.start(new Date());
    }

    public <T extends ILogInfoBuilder> T end(Date var1);

    default public <T extends ILogInfoBuilder> T end() {
        return this.end(new Date());
    }

    public <T extends ILogInfoBuilder> T execTime(long var1);

    public <T extends ILogInfoBuilder> T msg(String var1);

    public <T extends ILogInfoBuilder> T dbInfo(String var1);

    public <T extends ILogInfoBuilder> T serverInfo(String var1);

    public <T extends ILogInfoBuilder> T threadInfo(String var1);

    public <T extends ILogInfoBuilder> T logInfo(String var1, Object var2);

    public <T extends ILogInfoBuilder> T reset();

    default public void log() {
        IAgpLogger.instance().log(this.getConfig(), this.build());
    }

    default public void error() {
        IAgpLogger.error(this.getConfig(), this.build());
    }

    default public void warn() {
        IAgpLogger.warn(this.getConfig(), this.build());
    }

    default public void info() {
        IAgpLogger.info(this.getConfig(), this.build());
    }

    default public void info(String msg) {
        this.msg(msg);
        IAgpLogger.info(this.getConfig(), this.build());
    }

    default public void error(Exception e) {
        this.msg(ThrowableToString.convertToStr((Throwable)e));
        IAgpLogger.error(this.getConfig(), this.build());
    }

    default public void warn(Exception e) {
        this.msg(ThrowableToString.convertToStr((Throwable)e));
        IAgpLogger.warn(this.getConfig(), this.build());
    }

    default public void error(String msg) {
        this.msg(String.format("%s", msg));
        IAgpLogger.error(this.getConfig(), this.build());
    }

    default public void warn(String msg) {
        this.msg(String.format("%s", msg));
        IAgpLogger.warn(this.getConfig(), this.build());
    }

    default public void error(String msg, Exception e) {
        this.msg(String.format("%s\r\n%s", msg, ThrowableToString.convertToStr((Throwable)e)));
        IAgpLogger.error(this.getConfig(), this.build());
    }

    default public void warn(String msg, Exception e) {
        this.msg(String.format("%s\r\n%s", msg, ThrowableToString.convertToStr((Throwable)e)));
        IAgpLogger.warn(this.getConfig(), this.build());
    }
}

