/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.log;

import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.service.log.AgpLogLevel;
import cn.hangar.agp.service.log.IAgpLogInfo;
import cn.hangar.agp.service.log.ILogApiBuilder;
import cn.hangar.agp.service.log.ILogConfigBuilder;
import cn.hangar.agp.service.log.ILogFlowBuilder;
import cn.hangar.agp.service.log.ILogInfoBuilder;
import cn.hangar.agp.service.log.ILogProgressBuilder;
import cn.hangar.agp.service.log.ILogSqlBuilder;
import cn.hangar.agp.service.log.ILogTimeTaskBuilder;
import cn.hangar.agp.service.log.SimpleAgpLogger;
import java.util.Map;

public interface IAgpLogger {
    public static final String _NEEDCONSOLE = "_needAgpLogConsole";
    public static final String _NOLOG = "_noAgpLog";

    public static IAgpLogger instance() {
        return AgpLoggerInit.logger;
    }

    public static ILogProgressBuilder logProgress() {
        return IAgpLogger.logBuilder(ILogProgressBuilder.class);
    }

    public static ILogSqlBuilder logSqlBuilder() {
        return IAgpLogger.logBuilder(ILogSqlBuilder.class);
    }

    public static ILogApiBuilder logApiBuilder() {
        return IAgpLogger.logBuilder(ILogApiBuilder.class);
    }

    public static ILogTimeTaskBuilder logTimeTaskBuilder() {
        return IAgpLogger.logBuilder(ILogTimeTaskBuilder.class);
    }

    public static ILogFlowBuilder logFlowBuilder() {
        return IAgpLogger.logBuilder(ILogFlowBuilder.class);
    }

    public static ILogConfigBuilder logConfigBuilder() {
        return IAgpLogger.logBuilder(ILogConfigBuilder.class);
    }

    public static <T extends ILogInfoBuilder> T logBuilder(Class<T> clazz) {
        return IAgpLogger.instance().newBuilder(clazz);
    }

    public static void info(Map<String, Object> config, IAgpLogInfo info) {
        if (info == null) {
            return;
        }
        info.setLevel(AgpLogLevel.Info);
        IAgpLogger.instance().log(config, info);
    }

    public static void warn(Map<String, Object> config, IAgpLogInfo info) {
        if (info == null) {
            return;
        }
        info.setLevel(AgpLogLevel.Warn);
        IAgpLogger.instance().log(config, info);
    }

    public static void error(Map<String, Object> config, IAgpLogInfo info) {
        if (info == null) {
            return;
        }
        info.setLevel(AgpLogLevel.Error);
        IAgpLogger.instance().log(config, info);
    }

    public void log(Map<String, Object> var1, IAgpLogInfo var2);

    public <T extends ILogInfoBuilder> T newBuilder(Class<T> var1);

    public static class AgpLoggerInit {
        static IAgpLogger logger;

        static {
            try {
                logger = (IAgpLogger)ContextManager.findOne(IAgpLogger.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (logger == null) {
                logger = new SimpleAgpLogger();
            }
        }
    }
}

