/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util.encrypt;

import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.util.encrypt.Base64Util;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;

public class RSAEncryptUtil {
    public static Base64KeyPair generateKeyPair() {
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        generator.initialize(1024, new SecureRandom());
        KeyPair keyPair = generator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        byte[] privateEncode = privateKey.getEncoded();
        byte[] publicEncode = publicKey.getEncoded();
        Base64KeyPair base64KeyPair = new Base64KeyPair();
        base64KeyPair.setPrivateKey(Base64Util.encode(privateEncode));
        base64KeyPair.setPublicKey(Base64Util.encode(publicEncode));
        return base64KeyPair;
    }

    private static KeyFactory getRSAKeyFactory() {
        try {
            return KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String message, String publicKey) {
        if (StringUtils.isNotEmpty((String)message)) {
            byte[] key = Base64Util.decode(publicKey);
            KeyFactory keyFactory = RSAEncryptUtil.getRSAKeyFactory();
            PublicKey pubKey = null;
            try {
                pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(key));
            }
            catch (InvalidKeySpecException e) {
                e.printStackTrace();
            }
            try {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(1, pubKey);
                byte[] encryptMsg = RSAEncryptUtil.rsaGroupFinal(cipher, 1, message.getBytes());
                return Base64Util.encode(encryptMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String decrypt(String cipherText, String privateKey) {
        if (StringUtils.isNotEmpty((String)cipherText)) {
            byte[] key = Base64Util.decode(privateKey);
            KeyFactory keyFactory = RSAEncryptUtil.getRSAKeyFactory();
            PrivateKey priKey = null;
            try {
                priKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(key));
            }
            catch (InvalidKeySpecException e) {
                e.printStackTrace();
            }
            try {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, priKey);
                byte[] encryptMsg = Base64Util.decode(cipherText);
                byte[] msg = RSAEncryptUtil.rsaGroupFinal(cipher, 2, encryptMsg);
                return new String(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static byte[] rsaGroupFinal(Cipher cipher, int opmode, byte[] inputArray) throws Exception {
        int MAX_ENCRYPT_BLOCK = 2 == opmode ? 128 : 117;
        int offSet = 0;
        byte[] resultBytes = new byte[]{};
        byte[] cache = new byte[]{};
        int inputLength = inputArray.length;
        while (inputLength - offSet > 0) {
            if (inputLength - offSet > MAX_ENCRYPT_BLOCK) {
                cache = cipher.doFinal(inputArray, offSet, MAX_ENCRYPT_BLOCK);
                offSet += MAX_ENCRYPT_BLOCK;
            } else {
                cache = cipher.doFinal(inputArray, offSet, inputLength - offSet);
                offSet = inputLength;
            }
            resultBytes = Arrays.copyOf(resultBytes, resultBytes.length + cache.length);
            System.arraycopy(cache, 0, resultBytes, resultBytes.length - cache.length, cache.length);
        }
        return resultBytes;
    }

    public static class Base64KeyPair {
        private String privateKey;
        private String publicKey;

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }
    }
}

