/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util.encrypt;

import cn.hangar.agp.platform.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DigestUtil {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HmacSha256 = "HmacSHA256";

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            int high = b >> 4 & 0xF;
            int low = b & 0xF;
            sb.append(hexDigits[high]).append(hexDigits[low]);
        }
        return sb.toString();
    }

    public static String getMd5Hex(String message) {
        return DigestUtil.getMd5Hex(message, null);
    }

    public static String getMd5Hex(String message, String salt) {
        return DigestUtil.getMd5Hex(message.getBytes(), salt);
    }

    public static String getMd5Hex(byte[] input, String salt) {
        MessageDigest digest = DigestUtil.getMessageDigest("MD5");
        digest.update(input);
        if (StringUtils.isNotBlank((String)salt)) {
            digest.update(salt.getBytes());
        }
        byte[] bytes = digest.digest();
        return DigestUtil.toHexString(bytes);
    }

    public static String getSha1Hex(String message, String salt) {
        return DigestUtil.getSha1Hex(message.getBytes(), salt);
    }

    public static String getSha1Hex(String message) {
        return DigestUtil.getSha1Hex(message, null);
    }

    public static String getSha1Hex(byte[] input, String salt) {
        MessageDigest digest = DigestUtil.getMessageDigest("SHA-1");
        digest.update(input);
        if (StringUtils.isNotBlank((String)salt)) {
            digest.update(salt.getBytes());
        }
        byte[] bytes = digest.digest();
        return DigestUtil.toHexString(bytes);
    }

    public static String getHMacSha256Hex(String message, String key) {
        try {
            Mac mac = Mac.getInstance(HmacSha256);
            SecretKeySpec spec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), HmacSha256);
            mac.init(spec);
            byte[] bytes = mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                String stmp = Integer.toHexString(aByte & 0xFF);
                if (stmp.length() == 1) {
                    sb.append('0');
                }
                sb.append(stmp);
            }
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }
}

