/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.PowerException;
import cn.hangar.agp.platform.core.data.IResDataDict;
import cn.hangar.agp.platform.express.ExpressHelper;
import cn.hangar.agp.platform.utils.RefObject;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.DBService;
import cn.hangar.agp.service.core.util.DbHelper;
import cn.hangar.agp.service.model.datasource.ResDataDict;
import cn.hangar.agp.service.model.datasource.SysUserRange;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SysUserRangeUtils {
    private static DBService.SqlService getSqlService() {
        return DbHelper.getDBService().getSqlService();
    }

    private static IResDataDict getResDict(String resId) {
        return ResDataDict.getResDataDict((String)resId);
    }

    private static boolean checkLookRange(String resId, SysUserRange userRange, Map arg) {
        return true;
    }

    private static boolean checkUpdateRange(String resId, SysUserRange userRange, Map arg) {
        return SysUserRangeUtils.checkRangeByKey(resId, userRange.getUpdatePowerRange(), arg);
    }

    private static boolean checkDeleteRange(String resId, SysUserRange userRange, Map arg) {
        return SysUserRangeUtils.checkRangeByKey(resId, userRange.getDeletePowerRange(), arg);
    }

    private static boolean checkRangeByKey(String resId, String where, Map arg) {
        IResDataDict dict = SysUserRangeUtils.getResDict(resId);
        String keyValue = "";
        if (arg != null) {
            keyValue = arg.get(dict.getKeyColumnName());
        }
        if (keyValue == null) {
            keyValue = "";
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(dict.getKeyColumnName(), keyValue);
        where = StringUtils.isNotEmpty((String)where) ? where + " and " : "";
        where = where + dict.getKeyColumnName() + " = #{" + dict.getKeyColumnName() + "}";
        return SysUserRangeUtils.handlerRangeSql(dict, where, arg);
    }

    private static boolean handlerRangeSql(IResDataDict dict, String where, Map arg) {
        RefObject rangeObj;
        if (!StringUtils.isBlank((String)where) && ExpressHelper.isExpress((String)where) && ExpressHelper.replace((String)where, (RefObject)(rangeObj = new RefObject()), (Object[])new Object[]{arg})) {
            where = (String)rangeObj.getArgValue();
        }
        DBService.SqlService sqlService = SysUserRangeUtils.getSqlService();
        String sql1 = String.format("select COUNT(*) as count from %s where %s", dict.getStorageName(), where);
        List<Map<String, Object>> obj = sqlService.selectMaps(dict.getDBName(), sql1, null);
        return obj != null && obj.size() == 1;
    }

    public static void checkAddPower(String resId, SysUserRange userRange, List<Map> arg) {
        if (arg != null && !arg.isEmpty() && userRange != null && !SysUserRangeUtils.hasAddPower(userRange)) {
            throw new PowerException("\u6ca1\u6709\u65b0\u589e\u6743\u9650");
        }
    }

    public static void checkUpdatePower(String resId, SysUserRange userRange, List<Map> arg) {
        if (arg != null && !arg.isEmpty() && userRange != null) {
            if (SysUserRangeUtils.hasUpdatePower(userRange)) {
                for (Map item : arg) {
                    if (SysUserRangeUtils.checkUpdateRange(resId, userRange, item)) continue;
                    throw new PowerException("\u6ca1\u6709\u4fee\u6539\u6743\u9650");
                }
            } else {
                throw new PowerException("\u6ca1\u6709\u4fee\u6539\u6743\u9650");
            }
        }
    }

    public static void checkDeletePower(String resId, SysUserRange userRange, List<Map> arg) {
        if (arg != null && !arg.isEmpty() && userRange != null) {
            if (SysUserRangeUtils.hasDeletePower(userRange)) {
                for (Map item : arg) {
                    if (SysUserRangeUtils.checkDeleteRange(resId, userRange, item)) continue;
                    throw new PowerException("\u6ca1\u6709\u5220\u9664\u6743\u9650");
                }
            } else {
                throw new PowerException("\u6ca1\u6709\u5220\u9664\u6743\u9650");
            }
        }
    }

    public static void checkLookPower(String resId, SysUserRange userRange, Map arg) {
        if (userRange != null) {
            if (SysUserRangeUtils.hasLookPower(userRange)) {
                if (!SysUserRangeUtils.checkLookRange(resId, userRange, arg)) {
                    throw new PowerException("\u6ca1\u6709\u67e5\u8be2\u6743\u9650");
                }
            } else {
                throw new PowerException("\u6ca1\u6709\u67e5\u8be2\u6743\u9650");
            }
        }
    }

    public static boolean hasAddPower(SysUserRange userRange) {
        if (userRange == null) {
            return true;
        }
        return SysUserRangeUtils.execPowerExpress(userRange.getPermitAdd());
    }

    public static boolean hasUpdatePower(SysUserRange userRange) {
        if (userRange == null) {
            return true;
        }
        return SysUserRangeUtils.execPowerExpress(userRange.getPermitUpd());
    }

    public static boolean hasDeletePower(SysUserRange userRange) {
        if (userRange == null) {
            return true;
        }
        return SysUserRangeUtils.execPowerExpress(userRange.getPermitDelete());
    }

    public static boolean hasLookPower(SysUserRange userRange) {
        if (userRange == null) {
            return true;
        }
        return SysUserRangeUtils.execPowerExpress(userRange.getPermitLook());
    }

    public static boolean execPowerExpress(String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            String[] values;
            String v = value.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(" ", "");
            if ("1".equals(v)) {
                return true;
            }
            if ("0".equals(v)) {
                return false;
            }
            if (SysUserRangeUtils.isSimplePowerExpress(value) && (values = v.split("[=|>|<]{1}")).length == 2) {
                return v.contains("=") ? values[0].equals(values[1]) : (v.contains(">") ? Integer.parseInt(values[0]) > Integer.parseInt(values[1]) : v.contains("<") && Integer.parseInt(values[0]) < Integer.parseInt(values[1]));
            }
            return false;
        }
        return false;
    }

    public static boolean isSimplePowerExpress(String value) {
        return StringUtils.isNotEmpty((String)value) && value.replaceAll(" ", "").matches("[0-9]+[=|>|<]{1}[0-9]+");
    }

    public static void checkControlPower(String id) {
        boolean hasPower;
        List limitIds = (List)AppContext.getCurrentUser().getExtArgument().get("userLimitIds");
        boolean bl = hasPower = limitIds == null || !limitIds.contains(id);
        if (!hasPower) {
            throw new PowerException("\u65e0\u64cd\u4f5c\u6743\u9650");
        }
    }

    public static String andRange(String left, String right) {
        if (StringUtils.isEmpty((String)left)) {
            return right;
        }
        if (StringUtils.isEmpty((String)right)) {
            return left;
        }
        return left.trim() + " and " + right.trim();
    }

    public static void checkRoleObjPower(String partInstId, String power) {
        Map powers = (Map)AppContext.getCurrentUser().getExtArgument().get("roleObjPower");
        if (powers == null || powers.size() == 0) {
            return;
        }
        String value = (String)powers.get("ROLE_ADMIN");
        if (StringUtils.isNotEmpty((String)value)) {
            return;
        }
        value = (String)powers.get(partInstId);
        if (value != null) {
            String[] values;
            for (String item : values = value.split(",")) {
                if (!item.equalsIgnoreCase(power)) continue;
                return;
            }
            throw new PowerException("\u65e0\u64cd\u4f5c\u6743\u9650");
        }
    }

    public static boolean isRoleMatched(String role) {
        if (StringUtils.isNotEmpty((String)role)) {
            Map hasRoles = AppContext.getCurrentUser().getRoles();
            String[] roles = role.split(",");
            if (hasRoles != null) {
                for (String item : roles) {
                    if (hasRoles.get(item) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

