/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.util.SysUserRangeUtils;
import cn.hangar.agp.service.model.datasource.SysUserRange;
import cn.hangar.agp.service.model.sys.SysRoleResLimit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class SysUserRangeDataHelper {
    public static SysUserRange mergeResAndObjRange(SysUserRange resRange, SysUserRange objRange) {
        if (resRange == null && objRange == null) {
            return null;
        }
        if (resRange == null) {
            resRange = SysUserRange.createAllResPowerRange();
        }
        if (objRange != null) {
            if (SysUserRangeUtils.hasAddPower(resRange) && !SysUserRangeUtils.hasAddPower(objRange)) {
                resRange.setPermitAdd("0");
            }
            if (SysUserRangeUtils.hasUpdatePower(resRange)) {
                if (!SysUserRangeUtils.hasUpdatePower(objRange)) {
                    resRange.setPermitUpd("0");
                } else {
                    SysUserRangeDataHelper.mergeResAndObjPowerRange(resRange.getUpdatePowerRange(), objRange.getUpdatePowerRange(), arg_0 -> ((SysUserRange)resRange).setPermitUpd(arg_0), arg_0 -> ((SysUserRange)resRange).setUpdatePowerRange(arg_0));
                }
            }
            if (SysUserRangeUtils.hasDeletePower(resRange)) {
                if (!SysUserRangeUtils.hasDeletePower(objRange)) {
                    resRange.setPermitDelete("0");
                } else {
                    SysUserRangeDataHelper.mergeResAndObjPowerRange(resRange.getDeletePowerRange(), objRange.getDeletePowerRange(), arg_0 -> ((SysUserRange)resRange).setPermitDelete(arg_0), arg_0 -> ((SysUserRange)resRange).setDeletePowerRange(arg_0));
                }
            }
            if (SysUserRangeUtils.hasLookPower(resRange)) {
                if (!SysUserRangeUtils.hasLookPower(objRange)) {
                    resRange.setPermitLook("0");
                } else {
                    SysUserRangeDataHelper.mergeResAndObjPowerRange(resRange.getLookPowerRange(), objRange.getLookPowerRange(), arg_0 -> ((SysUserRange)resRange).setPermitLook(arg_0), arg_0 -> ((SysUserRange)resRange).setLookPowerRange(arg_0));
                }
            }
        }
        return resRange;
    }

    public static SysUserRange mergeResList(List<SysUserRange> resRanges) {
        if (resRanges != null && resRanges.size() > 0) {
            boolean execUpdatePower = false;
            boolean execLookPower = false;
            SysUserRange sysUserRange = new SysUserRange();
            sysUserRange.SetAsNotPowerRange();
            for (SysUserRange item : resRanges) {
                if (SysUserRangeUtils.hasAddPower(item)) {
                    sysUserRange.setPermitAdd("1");
                }
                if (SysUserRangeUtils.hasUpdatePower(item)) {
                    SysUserRangeDataHelper.mergeResPowerRange(item.getUpdatePowerRange(), sysUserRange.getUpdatePowerRange(), arg_0 -> ((SysUserRange)sysUserRange).setPermitUpd(arg_0), arg_0 -> ((SysUserRange)sysUserRange).setUpdatePowerRange(arg_0));
                    if (!execUpdatePower && SysUserRangeUtils.execPowerExpress(item.getLimitUpdRange())) {
                        execUpdatePower = true;
                    }
                }
                if (SysUserRangeUtils.hasDeletePower(item)) {
                    SysUserRangeDataHelper.mergeResPowerRange(item.getDeletePowerRange(), sysUserRange.getDeletePowerRange(), arg_0 -> ((SysUserRange)sysUserRange).setPermitDelete(arg_0), arg_0 -> ((SysUserRange)sysUserRange).setDeletePowerRange(arg_0));
                }
                if (!SysUserRangeUtils.hasLookPower(item)) continue;
                SysUserRangeDataHelper.mergeResPowerRange(item.getLookPowerRange(), sysUserRange.getLookPowerRange(), arg_0 -> ((SysUserRange)sysUserRange).setPermitLook(arg_0), arg_0 -> ((SysUserRange)sysUserRange).setLookPowerRange(arg_0));
                if (execLookPower || !SysUserRangeUtils.execPowerExpress(item.getLimitLookRange())) continue;
                execLookPower = true;
            }
            if (execUpdatePower) {
                sysUserRange.setUpdatePowerRange("");
                sysUserRange.setDeletePowerRange("");
                sysUserRange.setPermitDelete("1");
                sysUserRange.setPermitUpd("1");
            } else {
                sysUserRange.setUpdatePowerRange(SysUserRangeDataHelper.buildRangeSql(sysUserRange.getUpdatePowerRange()));
                sysUserRange.setDeletePowerRange(SysUserRangeDataHelper.buildRangeSql(sysUserRange.getDeletePowerRange()));
            }
            if (execLookPower) {
                sysUserRange.setLookPowerRange("");
                sysUserRange.setPermitLook("1");
            } else {
                sysUserRange.setLookPowerRange(SysUserRangeDataHelper.buildRangeSql(sysUserRange.getLookPowerRange()));
            }
            return sysUserRange;
        }
        return null;
    }

    private static String buildRangeSql(String range) {
        String trim;
        if (StringUtils.isNotBlank((String)range) && (!(trim = range.trim().toLowerCase()).startsWith("(") || !trim.endsWith(")") || trim.contains(" and ") || trim.contains(" or "))) {
            return "(" + range + ")";
        }
        return range;
    }

    private static void mergeResAndObjPowerRange(String resRange, String objRange, Consumer<String> updatePower, Consumer<String> updateRange) {
        if (StringUtils.isNotEmpty((String)objRange)) {
            if (SysUserRangeUtils.isSimplePowerExpress(objRange)) {
                if (!SysUserRangeUtils.execPowerExpress(objRange)) {
                    updatePower.accept("0");
                }
            } else {
                if (StringUtils.isNotEmpty((String)(resRange = StringUtils.isNotEmpty((String)resRange) ? "(" + resRange + ") and " : ""))) {
                    objRange = "(" + objRange + ")";
                }
                updateRange.accept(resRange + objRange);
            }
        }
    }

    private static void mergeResPowerRange(String srcResRange, String targetResRange, Consumer<String> updatePower, Consumer<String> updateRange) {
        if (SysUserRangeUtils.isSimplePowerExpress(srcResRange)) {
            if (SysUserRangeUtils.execPowerExpress(srcResRange)) {
                updatePower.accept("1");
                updateRange.accept("");
            }
        } else {
            updatePower.accept("1");
            if (StringUtils.isNotEmpty((String)srcResRange)) {
                if (targetResRange == null) {
                    targetResRange = "";
                }
                targetResRange = StringUtils.isNotEmpty((String)targetResRange) ? targetResRange + " OR ( " + srcResRange + " )" : "(" + srcResRange + ")";
            }
            updateRange.accept(targetResRange);
        }
    }

    public static String buildRangeSql(List<String> filters, Boolean isAnd) {
        ArrayList<String> filterSet = new ArrayList<String>();
        boolean hasPower = false;
        boolean hasNoPower = false;
        for (String item : filters) {
            if (!StringUtils.isNotEmpty((String)item) || filterSet.contains(item)) continue;
            filterSet.add(item);
            if (!SysUserRangeUtils.isSimplePowerExpress(item)) continue;
            if (SysUserRangeUtils.execPowerExpress(item)) {
                hasPower = true;
                continue;
            }
            hasNoPower = true;
        }
        if (filterSet.size() > 1) {
            if (isAnd.booleanValue()) {
                if (hasNoPower) {
                    return "1=0";
                }
            } else if (hasPower) {
                return "1=1";
            }
            String delimiter = isAnd != false ? " AND " : " OR ";
            return String.format("(%s)", String.join((CharSequence)delimiter, filterSet));
        }
        if (filterSet.size() > 0) {
            return (String)filterSet.get(0);
        }
        return "";
    }

    public static void buildPowerRangeByLimitRange(SysUserRange userRange) {
        ArrayList<String> look = new ArrayList<String>();
        ArrayList<String> del = new ArrayList<String>();
        ArrayList<String> upd = new ArrayList<String>();
        if (SysUserRangeDataHelper.dealPowerWithRange(SysUserRangeUtils.hasUpdatePower(userRange), userRange.getLimitUpdRange(), upd)) {
            userRange.setPermitUpd("1");
        }
        if (SysUserRangeDataHelper.dealPowerWithRange(SysUserRangeUtils.hasDeletePower(userRange), userRange.getLimitUpdRange(), del)) {
            userRange.setPermitDelete("1");
        }
        if (SysUserRangeDataHelper.dealPowerWithRange(SysUserRangeUtils.hasLookPower(userRange), userRange.getLimitLookRange(), look)) {
            userRange.setPermitLook("1");
        }
        if (StringUtils.isNotEmpty((String)userRange.getUpdatePowerRange())) {
            upd.add(userRange.getUpdatePowerRange());
        }
        if (StringUtils.isNotEmpty((String)userRange.getDeletePowerRange())) {
            del.add(userRange.getDeletePowerRange());
        }
        if (StringUtils.isNotEmpty((String)userRange.getLookPowerRange())) {
            look.add(userRange.getLookPowerRange());
        }
        if (!look.isEmpty()) {
            userRange.setLookPowerRange(SysUserRangeDataHelper.buildRangeSql(look, false));
        }
        if (!del.isEmpty()) {
            userRange.setDeletePowerRange(SysUserRangeDataHelper.buildRangeSql(del, false));
        }
        if (!upd.isEmpty()) {
            userRange.setUpdatePowerRange(SysUserRangeDataHelper.buildRangeSql(upd, false));
        }
        if (StringUtils.isNotEmpty((String)userRange.getLayerRange())) {
            ArrayList<String> where = new ArrayList<String>();
            where.add(userRange.getLayerRange());
            userRange.setLayerRange(SysUserRangeDataHelper.buildRangeSql(where, false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dealPowerWithRange(boolean hasPower, String lookRange, List<String> ranges) {
        if (!hasPower) return false;
        if (!StringUtils.isNotEmpty((String)lookRange)) return true;
        if (SysUserRangeUtils.isSimplePowerExpress(lookRange)) {
            if (!SysUserRangeUtils.execPowerExpress(lookRange)) return false;
            return true;
        }
        ranges.add(lookRange);
        return true;
    }

    public static SysRoleResLimit convertResLimit(Map data) {
        SysRoleResLimit limit = new SysRoleResLimit();
        if (data != null) {
            limit.setLimitId(String.valueOf(data.get("limitId")));
            limit.setRoleId(String.valueOf(data.get("roleId")));
            limit.setResId(String.valueOf(data.get("resId")));
            boolean isNewRole = data.containsKey("permitLook");
            Object value = data.get("lookRange");
            if (value != null) {
                if (isNewRole) {
                    limit.setLookRange(String.valueOf(value));
                } else if (SysUserRangeUtils.isSimplePowerExpress(value.toString())) {
                    if (SysUserRangeUtils.execPowerExpress(value.toString())) {
                        limit.setPermitLook("1");
                    } else {
                        limit.setPermitLook("0");
                    }
                } else {
                    limit.setLookRange(String.valueOf(value));
                    limit.setPermitLook("1");
                }
            }
            if ((value = data.get("updateRange")) != null && !isNewRole) {
                if (SysUserRangeUtils.isSimplePowerExpress(value.toString())) {
                    if (SysUserRangeUtils.execPowerExpress(value.toString())) {
                        limit.setPermitUpd("1");
                    } else {
                        limit.setPermitUpd("0");
                    }
                } else {
                    limit.setUpdateRange(String.valueOf(value));
                    limit.setPermitUpd("1");
                }
            }
            if ((value = data.get("deleteRange")) != null && !isNewRole) {
                if (SysUserRangeUtils.isSimplePowerExpress(value.toString())) {
                    if (SysUserRangeUtils.execPowerExpress(value.toString())) {
                        limit.setPermitDel("1");
                    } else {
                        limit.setPermitDel("0");
                    }
                } else {
                    limit.setDeleteRange(String.valueOf(value));
                    limit.setPermitDel("1");
                }
            }
            if ((value = data.get("updRange")) != null) {
                limit.setUpdRange(String.valueOf(value));
            }
            if ((value = data.get("permitAdd")) != null) {
                limit.setPermitAdd(String.valueOf(value));
            }
            if ((value = data.get("permitLook")) != null) {
                limit.setPermitLook(String.valueOf(value));
            }
            if ((value = data.get("permitDel")) != null) {
                limit.setPermitDel(String.valueOf(value));
            }
            if ((value = data.get("permitUpd")) != null) {
                limit.setPermitUpd(String.valueOf(value));
            }
            limit.setAppId(String.valueOf(data.get("appId")));
        }
        return limit;
    }
}

