/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.utils.ByteUtil;
import cn.hangar.agp.platform.utils.CryptoTools;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.util.AppHelper;
import cn.hangar.agp.service.core.util.encrypt.HGRSAEncryUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;

public class SecurityHelper {
    static Logger log = LoggerFactory.getLogger(SecurityHelper.class);
    private static final String strKey = "_hangar_";
    private static final String strIV = "@@hangar";

    public static String getSecretMode() {
        return AppHelper.getAppSecretMode(AppContext.getCurrentAppId());
    }

    public static String encode(String str) {
        if (AppContext.isCurrentMiniApp()) {
            return str;
        }
        if (str == null) {
            return null;
        }
        return HGRSAEncryUtil.encrypt(str);
    }

    public static String decode(String str) {
        if (AppContext.isCurrentMiniApp()) {
            return str;
        }
        if (str == null) {
            return null;
        }
        return HGRSAEncryUtil.decrypt(str);
    }

    public static String encodeSecret(String passWord) {
        return SecurityHelper.encodeSecret(passWord, null);
    }

    public static String encodeSecret(String passWord, String secretMode) {
        if (StringUtils.isBlank((String)passWord)) {
            return "";
        }
        if (secretMode == null) {
            secretMode = SecurityHelper.getSecretMode();
        }
        if (secretMode.equals("1")) {
            return ByteUtil.Crpyt((String)passWord);
        }
        if (secretMode.equals("2")) {
            byte[] bytValue = new byte[]{};
            String encodeStr = "";
            try {
                bytValue = passWord.getBytes("UTF8");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                encodeStr = ByteUtil.byte2HexString((byte[])md5.digest(bytValue), (boolean)false);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            return encodeStr.toUpperCase();
        }
        if (secretMode.equals("3")) {
            return DigestUtils.md5Hex((String)passWord);
        }
        try {
            CryptoTools crypt = new CryptoTools(strKey, strIV);
            String str = crypt.encode(passWord);
            return str;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
    }

    public static String decodeSecret(String passWord) {
        return SecurityHelper.decodeSecret(passWord, null);
    }

    public static String decodeSecret(String passWord, String secretMode) {
        if (StringUtils.isBlank((String)passWord)) {
            return passWord;
        }
        if (secretMode == null) {
            secretMode = SecurityHelper.getSecretMode();
        }
        if (secretMode.equals("1")) {
            return ByteUtil.UnCrpyt((String)passWord);
        }
        if (secretMode.equals("2")) {
            return passWord;
        }
        try {
            CryptoTools crypt = new CryptoTools(strKey, strIV);
            String str = crypt.decode(passWord);
            return str;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
    }
}

