/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.util.SecureSokcetTrustManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SSLUtil {
    public static SSLContext getSSLContext(String keyStoreType, String keyStoreFile, String keyStorePassword, String keyPassword, String caCrtFile, String crtFile, String keyFile, String sslProtocol) throws Exception {
        return SSLUtil.getSSLContext(false, keyStoreType, keyStoreFile, keyStorePassword, keyPassword, caCrtFile, crtFile, keyFile, sslProtocol);
    }

    public static SSLContext getSSLContext(boolean isOneway, String keyStoreType, String keyStoreFile, String keyStorePassword, String keyPassword, String caCrtFile, String crtFile, String keyFile, String sslProtocol) throws Exception {
        if (keyStoreType != null && keyStoreType.equalsIgnoreCase("crt")) {
            return SSLUtil.getSSLContextCrt(isOneway, caCrtFile, crtFile, keyFile, keyPassword, sslProtocol);
        }
        return SSLUtil.getSSLContext(isOneway, keyStoreType, keyStoreFile, keyStorePassword, keyPassword, sslProtocol);
    }

    public static SSLContext getSSLContextCrt(boolean isOneway, String caCrtFile, String crtFile, String keyFile, String keyPassword, String sslProtocol) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate caCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Files.readAllBytes(Paths.get(caCrtFile, new String[0]))));
        KeyStore caKs = KeyStore.getInstance(KeyStore.getDefaultType());
        caKs.load(null, null);
        caKs.setCertificateEntry("ca-certificate", caCert);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(caKs);
        TrustManager[] tm = SecureSokcetTrustManagerFactory.getTrustManagers(tmf.getTrustManagers());
        KeyManager[] km = null;
        if (isOneway) {
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Files.readAllBytes(Paths.get(caCrtFile, new String[0]))));
            ObjectInputStream oi = new ObjectInputStream(new ByteArrayInputStream(Files.readAllBytes(Paths.get(keyFile, new String[0]))));
            KeyPair key = (KeyPair)oi.readObject();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, null);
            ks.setCertificateEntry("certificate", cert);
            ks.setKeyEntry("private-key", key.getPrivate(), keyPassword.toCharArray(), new Certificate[]{cert});
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keyPassword.toCharArray());
            km = kmf.getKeyManagers();
        }
        if (StringUtils.isEmpty((String)sslProtocol)) {
            sslProtocol = "TLSv1";
        }
        SSLContext context = SSLContext.getInstance(sslProtocol);
        context.init(km, tm, null);
        return context;
    }

    public static SSLContext getSSLContext(boolean isOneway, String keyStoreType, String keyStoreFile, String keyStorePassword, String keyPassword, String sslProtocol) throws Exception {
        KeyManager[] km = null;
        TrustManager[] tm = null;
        if (keyStoreFile != null) {
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            URL tsUrl = FileUtil.getResource((String)keyStoreFile);
            File tsFile = new File(tsUrl.toURI());
            KeyStore trustStore = KeyStore.getInstance(keyStoreType == null ? KeyStore.getDefaultType() : keyStoreType);
            try (FileInputStream tsFileInputStream = new FileInputStream(tsFile);){
                trustStore.load(tsFileInputStream, keyStorePassword.toCharArray());
            }
            tmFactory.init(trustStore);
            if (!isOneway) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                URL ksUrl = FileUtil.getResource((String)keyStoreFile);
                File ksFile = new File(ksUrl.toURI());
                KeyStore ks = KeyStore.getInstance(keyStoreType == null ? KeyStore.getDefaultType() : keyStoreType);
                try (FileInputStream ksFileInputStream = new FileInputStream(ksFile);){
                    ks.load(ksFileInputStream, keyStorePassword.toCharArray());
                }
                kmf.init(ks, keyPassword == null ? null : keyPassword.toCharArray());
                km = kmf.getKeyManagers();
            }
            tm = SecureSokcetTrustManagerFactory.getTrustManagers(tmFactory.getTrustManagers());
        }
        if (StringUtils.isEmpty((String)sslProtocol)) {
            sslProtocol = "TLS";
        }
        SSLContext sslContext = SSLContext.getInstance(sslProtocol);
        sslContext.init(km, tm, null);
        return sslContext;
    }
}

