/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.utils.StringUtils;
import java.util.function.Function;

public interface ISqlCoder {
    public static ISqlCoder instance() {
        return new SimpleSqlCoder();
    }

    public String getRowNumSqlFormat(int var1, String var2, String var3, boolean var4);

    public String getRowNumSqlFormatNoPage(int var1, String var2, String var3, boolean var4);

    public String convertToStringPart(int var1, String var2);

    public String buildMultiFKDisplayPart(int var1, String var2, String var3, String var4, String var5);

    public String buildMultiStatusDisplayPart(int var1, String var2, Function<String, String> var3);

    public String buildMutiFKDisplayPart(int var1, String var2, String var3, String var4, String var5, String var6);

    public static class SimpleSqlCoder
    implements ISqlCoder {
        private ISqlCoder getSqlCoder(int dbVendor) {
            if (dbVendor == 2) {
                return new OracleSqlCoder();
            }
            if (dbVendor == 3) {
                return new SqlServerSqlCoder();
            }
            if (dbVendor == 1) {
                return new MySqlSqlCoder();
            }
            if (dbVendor == 6) {
                return new SqliteCoder();
            }
            if (dbVendor == 13) {
                return new PostgreSQLCoder();
            }
            return new MySqlSqlCoder();
        }

        @Override
        public String getRowNumSqlFormat(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
            ISqlCoder sqlCoder = this.getSqlCoder(dbVendor);
            return sqlCoder.getRowNumSqlFormat(dbVendor, keyFieldName, keyFieldHolder, isGroup);
        }

        @Override
        public String getRowNumSqlFormatNoPage(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
            ISqlCoder sqlCoder = this.getSqlCoder(dbVendor);
            return sqlCoder.getRowNumSqlFormatNoPage(dbVendor, keyFieldName, keyFieldHolder, isGroup);
        }

        @Override
        public String convertToStringPart(int dbVendor, String fieldPart) {
            ISqlCoder sqlCoder = this.getSqlCoder(dbVendor);
            return sqlCoder.convertToStringPart(dbVendor, fieldPart);
        }

        @Override
        public String buildMultiFKDisplayPart(int dbVendor, String fieldPart, String relatedTable, String keyField, String displayField) {
            ISqlCoder sqlCoder = this.getSqlCoder(dbVendor);
            return sqlCoder.buildMultiFKDisplayPart(dbVendor, fieldPart, relatedTable, keyField, displayField);
        }

        @Override
        public String buildMultiStatusDisplayPart(int dbVendor, String fieldPart, Function<String, String> getStatusCaseWhenPart) {
            ISqlCoder sqlCoder = this.getSqlCoder(dbVendor);
            return sqlCoder.buildMultiStatusDisplayPart(dbVendor, fieldPart, getStatusCaseWhenPart);
        }

        @Override
        public String buildMutiFKDisplayPart(int dbVendor, String fieldPart, String relatedTable, String keyField, String displayField, String extFitler) {
            ISqlCoder sqlCoder = this.getSqlCoder(dbVendor);
            return sqlCoder.buildMutiFKDisplayPart(dbVendor, fieldPart, relatedTable, keyField, displayField, extFitler);
        }

        class SqliteCoder
        extends MySqlSqlCoder {
            private static final String IDField = "___id___";

            SqliteCoder() {
            }

            @Override
            public String getRowNumSqlFormat(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
                String rowNumSqlFormat = null;
                rowNumSqlFormat = String.format(" %%3$s %%1$s limit %%5$s offset %%4$s ", new Object[0]);
                return rowNumSqlFormat;
            }
        }

        class PostgreSQLCoder
        extends ASqlCoder {
            PostgreSQLCoder() {
            }
        }

        class MySqlSqlCoder
        extends ASqlCoder {
            MySqlSqlCoder() {
            }

            @Override
            public String getRowNumSqlFormat(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
                String rowNumSqlFormat = null;
                rowNumSqlFormat = isGroup ? String.format(",@rownum :=@rownum + 1  AS  PAM_ROWNUMBER ;, (select @rownum:=0) o ; %%2$s where  %%2$s.PAM_ROWNUMBER> %%4$s and %%2$s.PAM_ROWNUMBER <= %%5$s  ORDER BY %%2$s.PAM_ROWNUMBER", keyFieldName, keyFieldHolder) : String.format("(select  %1$s  %1$s0001,rownum_ PAM_ROWNUM,rownum_ PAM_ROWNUMBER %%6$s from ( select @rownum :=@rownum + 1  AS rownum_ ,tr.%2$s %%6$s from (select %1$s from %%2$s  %%3$s %%1$s ) tr\r\n, (select @rownum:=0) o) ir \r\n where  rownum_> %%4$s and rownum_ <= %%5$s) kr WHERE %2$s =kr.%1$s0001 order by kr.PAM_ROWNUM ; 1", keyFieldName, keyFieldName);
                return rowNumSqlFormat;
            }

            @Override
            public String getRowNumSqlFormatNoPage(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
                String rowNumSqlFormat = null;
                rowNumSqlFormat = isGroup ? String.format(",@rownum :=@rownum + 1  AS  PAM_ROWNUMBER ;, (select @rownum:=0) o ; %%2$s ORDER BY %%2$s.PAM_ROWNUMBER", keyFieldName, keyFieldHolder) : String.format("(select  %1$s  %1$s0001,rownum_ PAM_ROWNUM,rownum_ PAM_ROWNUMBER %%6$s from ( select @rownum :=@rownum + 1  AS rownum_ ,tr.%2$s %%6$s from (select %1$s from %%2$s  %%3$s %%1$s ) tr\r\n, (select @rownum:=0) o) ir ) kr WHERE %2$s =kr.%1$s0001 order by kr.PAM_ROWNUM ; 1", keyFieldName, keyFieldName);
                return rowNumSqlFormat;
            }

            @Override
            public String buildMultiStatusDisplayPart(int dbVendor, String fieldPart, Function<String, String> getStatusTableSql) {
                if (getStatusTableSql == null || StringUtils.isEmpty((String)fieldPart)) {
                    return null;
                }
                String tableSql = getStatusTableSql.apply(null);
                String format = "(select group_concat(DISTINCT %1$s) %1$s FROM %2$s where instr(%4$s,%3$s))";
                return String.format(format, "n", tableSql, "v", fieldPart);
            }

            @Override
            public String buildMultiFKDisplayPart(int dbVendor, String fieldPart, String relatedTable, String keyField, String displayField) {
                String format = "(select group_concat(DISTINCT %1$s) %1$s FROM %2$s where instr(%4$s,%3$s))";
                return String.format(format, displayField, relatedTable, keyField, fieldPart);
            }

            @Override
            public String buildMutiFKDisplayPart(int dbVendor, String fieldPart, String relatedTable, String keyField, String displayField, String extFitler) {
                if (StringUtils.isEmpty((String)extFitler)) {
                    return this.buildMultiFKDisplayPart(dbVendor, fieldPart, relatedTable, keyField, displayField);
                }
                String format = "(select group_concat(DISTINCT %1$s) %1$s FROM %2$s where %5$s and instr(%4$s,%3$s))";
                return String.format(format, displayField, relatedTable, keyField, fieldPart, extFitler);
            }

            @Override
            public String convertToStringPart(int dbVendor, String fieldPart) {
                return String.format("CAST(%s AS CHAR)", fieldPart);
            }
        }

        class SqlServerSqlCoder
        extends ASqlCoder {
            SqlServerSqlCoder() {
            }

            @Override
            public String getRowNumSqlFormat(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
                String rowNumSqlFormat = null;
                rowNumSqlFormat = isGroup ? String.format(",ROW_NUMBER() OVER( %%1$s ) AS PAM_ROWNUMBER ;; %%2$s  where  %%2$s.PAM_ROWNUMBER> %%4$s and %%2$s.PAM_ROWNUMBER <= %%5$s  ORDER BY %%2$s.PAM_ROWNUMBER", keyFieldName, keyFieldHolder) : String.format("(select %1$s %1$s0001,rownum_ PAM_ROWNUM,rownum_ PAM_ROWNUMBER %%6$s from ( select ROW_NUMBER() OVER( %%1$s ) AS rownum_ ,%2$s %%6$s from  %%2$s %%3$s ) ir \n where  rownum_> %%4$s and rownum_ <= %%5$s) kr WHERE %2$s =kr.%1$s0001 order by kr.PAM_ROWNUM ; (select 1)", keyFieldName, keyFieldHolder);
                return rowNumSqlFormat;
            }

            @Override
            public String getRowNumSqlFormatNoPage(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
                String rowNumSqlFormat = null;
                rowNumSqlFormat = isGroup ? String.format(",ROW_NUMBER() OVER( %%1$s ) AS PAM_ROWNUMBER ;; %%2$s ORDER BY %%2$s.PAM_ROWNUMBER", keyFieldName, keyFieldHolder) : String.format("(select %1$s %1$s0001,rownum_ PAM_ROWNUM,rownum_ PAM_ROWNUMBER %%6$s from ( select ROW_NUMBER() OVER( %%1$s ) AS rownum_ ,%2$s %%6$s from  %%2$s %%3$s ) ir ) kr WHERE %2$s =kr.%1$s0001 order by kr.PAM_ROWNUM ; (select 1)", keyFieldName, keyFieldHolder);
                return rowNumSqlFormat;
            }

            @Override
            public String buildMultiStatusDisplayPart(int dbVendor, String fieldPart, Function<String, String> getStatusCaseWhenPart) {
                return this.buildMultiStatusDisplayPart(dbVendor, fieldPart, getStatusCaseWhenPart, "ID");
            }
        }

        class OracleSqlCoder
        extends ASqlCoder {
            OracleSqlCoder() {
            }

            @Override
            public String convertToStringPart(int dbVendor, String fieldPart) {
                return String.format("to_char(%s)", fieldPart);
            }

            @Override
            public String buildMultiStatusDisplayPart(int dbVendor, String fieldPart, Function<String, String> getStatusCaseWhenPart) {
                return this.buildMultiStatusDisplayPart(dbVendor, fieldPart, getStatusCaseWhenPart, "COLUMN_VALUE");
            }

            @Override
            protected String buildMultiStatusDisplayPart(int dbVendor, String fieldPart, Function<String, String> getStatusCaseWhenPart, String idName) {
                if (getStatusCaseWhenPart == null || StringUtils.isEmpty((String)fieldPart)) {
                    return null;
                }
                String statusCaseWhenPart = getStatusCaseWhenPart.apply(idName);
                if (StringUtils.isEmpty((String)statusCaseWhenPart)) {
                    return null;
                }
                if (idName.equals(statusCaseWhenPart)) {
                    return fieldPart;
                }
                String format = "(SELECT to_char(wm_concat(%s)) FROM TABLE(dbo.sys_ssplit(%s)))";
                return String.format(format, statusCaseWhenPart, fieldPart);
            }

            @Override
            public String buildMultiFKDisplayPart(int dbVendor, String fieldPart, String relatedTable, String keyField, String displayField) {
                String format = "(SELECT to_char(wm_concat(%s)) FROM %s WHERE %s IN(SELECT COLUMN_VALUE FROM TABLE(dbo.sys_ssplit(%s))))";
                return String.format(format, displayField, relatedTable, keyField, fieldPart);
            }

            @Override
            public String buildMutiFKDisplayPart(int dbVendor, String fieldPart, String relatedTable, String keyField, String displayField, String extFitler) {
                if (StringUtils.isBlank((String)extFitler)) {
                    return this.buildMultiFKDisplayPart(2, fieldPart, relatedTable, keyField, displayField);
                }
                return String.format("(SELECT to_char(wm_concat(%1$s)) FROM %2$s  WHERE %5$s and %3$s IN(SELECT COLUMN_VALUE FROM TABLE(dbo.sys_ssplit(%4$s))))", displayField, relatedTable, keyField, fieldPart, extFitler);
            }
        }

        abstract class ASqlCoder
        implements ISqlCoder {
            ASqlCoder() {
            }

            @Override
            public String getRowNumSqlFormat(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
                String rowNumSqlFormat = null;
                rowNumSqlFormat = isGroup ? String.format(",ROW_NUMBER() OVER( %%1$s ) AS PAM_ROWNUMBER ;; %%2$s  where  %%2$s.PAM_ROWNUMBER> %%4$s and %%2$s.PAM_ROWNUMBER <= %%5$s  ORDER BY %%2$s.PAM_ROWNUMBER", keyFieldName, keyFieldHolder) : String.format("(select %1$s %1$s0001,rownum_ PAM_ROWNUM,rownum_ PAM_ROWNUMBER %%6$s from ( select ROW_NUMBER() OVER( %%1$s ) AS rownum_ ,%2$s %%6$s from  %%2$s %%3$s ) ir \n where  rownum_> %%4$s and rownum_ <= %%5$s) kr WHERE %2$s =kr.%1$s0001 order by kr.PAM_ROWNUM ; 1", keyFieldName, keyFieldHolder);
                return rowNumSqlFormat;
            }

            @Override
            public String getRowNumSqlFormatNoPage(int dbVendor, String keyFieldName, String keyFieldHolder, boolean isGroup) {
                String rowNumSqlFormat = null;
                rowNumSqlFormat = isGroup ? String.format(",ROW_NUMBER() OVER( %%1$s ) AS PAM_ROWNUMBER ;; %%2$s ORDER BY %%2$s.PAM_ROWNUMBER", keyFieldName, keyFieldHolder) : String.format("(select %1$s %1$s0001,rownum_ PAM_ROWNUM,rownum_ PAM_ROWNUMBER %%6$s from ( select ROW_NUMBER() OVER( %%1$s ) AS rownum_ ,%2$s %%6$s from  %%2$s %%3$s ) ir ) kr WHERE %2$s =kr.%1$s0001 order by kr.PAM_ROWNUM ; 1", keyFieldName, keyFieldHolder);
                return rowNumSqlFormat;
            }

            @Override
            public String convertToStringPart(int dbVendor, String fieldPart) {
                return String.format("CAST(%s AS VARCHAR)", fieldPart);
            }

            @Override
            public String buildMultiStatusDisplayPart(int dbVendor, String fieldPart, Function<String, String> getStatusCaseWhenPart) {
                return this.buildMultiStatusDisplayPart(dbVendor, fieldPart, getStatusCaseWhenPart, "COLUMN_VALUE");
            }

            protected String buildMultiStatusDisplayPart(int dbVendor, String fieldPart, Function<String, String> getStatusCaseWhenPart, String idName) {
                if (getStatusCaseWhenPart == null || StringUtils.isEmpty((String)fieldPart)) {
                    return null;
                }
                String statusCaseWhenPart = getStatusCaseWhenPart.apply(idName);
                if (StringUtils.isEmpty((String)statusCaseWhenPart)) {
                    return null;
                }
                if (idName.equals(statusCaseWhenPart)) {
                    return fieldPart;
                }
                return "(SELECT STUFF((SELECT ','+" + statusCaseWhenPart + " FROM idstable(" + fieldPart + ") FOR XML PATH('')),1,1,''))";
            }

            @Override
            public String buildMultiFKDisplayPart(int dbVendor, String fieldPart, String relatedTable, String keyField, String displayField) {
                String format = "(SELECT STUFF((SELECT ','+%s FROM %s WHERE %s in (" + this.toSsplit("%s") + ") FOR XML PATH('')),1,1,''))";
                return String.format(format, displayField, relatedTable, keyField, fieldPart);
            }

            @Override
            public String buildMutiFKDisplayPart(int dbVendor, String fieldPart, String relatedTable, String keyField, String displayField, String extFitler) {
                if (StringUtils.isEmpty((String)extFitler)) {
                    return this.buildMultiFKDisplayPart(dbVendor, fieldPart, relatedTable, keyField, displayField);
                }
                return String.format("(SELECT STUFF((SELECT ','+%1$s FROM %2$s WHERE %5$s and %3$s in (" + this.toSsplit("%4$s") + ") FOR XML PATH('')),1,1,''))", displayField, relatedTable, keyField, fieldPart, extFitler);
            }

            protected String toSsplit(String field) {
                return String.format("select id from idstable(%s)", field);
            }
        }
    }
}

