/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.service.core.util.encrypt.AESEncryptUtil;
import cn.hangar.agp.service.core.util.encrypt.Base64Util;
import cn.hangar.agp.service.core.util.encrypt.DESEncryptUtil;
import cn.hangar.agp.service.core.util.encrypt.DigestUtil;
import cn.hangar.agp.service.core.util.encrypt.EncryptType;
import cn.hangar.agp.service.core.util.encrypt.RSAEncryptUtil;

public class EncryptHelper {
    public static String encrypt(Integer type, String message, String encodeKey) {
        if (type == null) {
            return message;
        }
        return EncryptHelper.encrypt(EncryptType.valOf(type), message, encodeKey);
    }

    public static String encrypt(String type, String message, String encodeKey) {
        EncryptType type1 = EncryptType.strValOf(type);
        return EncryptHelper.encrypt(type1, message, encodeKey);
    }

    public static String encrypt(EncryptType type1, String message, String encodeKey) {
        if (type1 == null || type1 == EncryptType.None) {
            return message;
        }
        switch (type1) {
            case Base64: {
                return Base64Util.encode(message);
            }
            case MD5: {
                return DigestUtil.getMd5Hex(message, encodeKey);
            }
            case SHA1: {
                return DigestUtil.getSha1Hex(message, encodeKey);
            }
            case DES: {
                return DESEncryptUtil.encrypt(message, encodeKey);
            }
            case AES: {
                return AESEncryptUtil.encrypt(message, encodeKey);
            }
            case RSA: {
                return RSAEncryptUtil.encrypt(message, encodeKey);
            }
            case HmacSha256: {
                return DigestUtil.getHMacSha256Hex(message, encodeKey);
            }
        }
        return null;
    }

    public static String decrypt(String type, String cipher, String key) {
        EncryptType encryptType = EncryptType.strValOf(type);
        if (encryptType == null || encryptType == EncryptType.None) {
            return cipher;
        }
        switch (encryptType) {
            case Base64: {
                return new String(Base64Util.decode(cipher));
            }
            case MD5: {
                throw new RuntimeException("can not decryptType : " + (Object)((Object)EncryptType.MD5));
            }
            case SHA1: {
                throw new RuntimeException("can not decryptType : " + (Object)((Object)EncryptType.SHA1));
            }
            case DES: {
                return DESEncryptUtil.decrypt(cipher, key);
            }
            case AES: {
                return AESEncryptUtil.decrypt(cipher, key);
            }
            case RSA: {
                return RSAEncryptUtil.decrypt(cipher, key);
            }
        }
        return null;
    }
}

