/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.core.data.BeanHelper;
import cn.hangar.agp.platform.core.data.ColumnRelation;
import cn.hangar.agp.platform.core.data.DataType;
import cn.hangar.agp.platform.core.data.DataTypeHelper;
import cn.hangar.agp.platform.core.data.IColumnInfo;
import cn.hangar.agp.platform.core.data.IResDataDict;
import cn.hangar.agp.platform.core.data.MobileDictionary;
import cn.hangar.agp.platform.core.data.table.DataTable;
import cn.hangar.agp.platform.core.db.ConnectStringElement;
import cn.hangar.agp.platform.core.db.Dialect;
import cn.hangar.agp.platform.core.db.IDB;
import cn.hangar.agp.platform.core.db.IDBFactory;
import cn.hangar.agp.platform.core.db.TableSchema;
import cn.hangar.agp.platform.core.db.dynamic.DBSourceFactory;
import cn.hangar.agp.platform.core.db.query.DatabaseEventProvd;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.core.ioc.CustomConditionalOnMissing;
import cn.hangar.agp.platform.core.sqlbuilder.FilterType;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.ReflectUtils;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.DBService;
import cn.hangar.agp.service.core.util.EmptyDBService;
import cn.hangar.agp.service.core.util.ISqlCoder;
import cn.hangar.agp.service.log.IAgpLogger;
import cn.hangar.agp.service.log.ILogSqlBuilder;
import cn.hangar.agp.service.model.datasource.ResDataDict;
import cn.hangar.agp.service.model.datasource.StatusGroup;
import cn.hangar.agp.service.model.datasource.StatusItem;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.stereotype.Component;

public class DbHelper {
    public static IDB createDB(String dbName) {
        IDB db = IDBFactory.instance().createDB(dbName);
        return db;
    }

    public static IDB createDataBase() {
        return DbHelper.createDB(null);
    }

    public static IDB createDataBase(String name) {
        return DbHelper.createDB(name);
    }

    public static TableSchema getTableSchema(String dbName, String sessiontablename) {
        return DbHelper.getDBService().getSqlService().getTableSchema(dbName, sessiontablename);
    }

    public static void clearTableSchemaCache(String appId) {
        DbHelper.getDBService().getSqlService().clearTableSchemaCache(appId);
    }

    public static int getDbVendor(String dbName) {
        String dbType = DbHelper.getDBService().getDbType(dbName);
        if (ConnectStringElement.DbTypeSection.MySql.name().equalsIgnoreCase(dbType)) {
            return 1;
        }
        if (ConnectStringElement.DbTypeSection.Oracle.name().equalsIgnoreCase(dbType)) {
            return 2;
        }
        if (ConnectStringElement.DbTypeSection.SqlServer.name().equalsIgnoreCase(dbType)) {
            return 3;
        }
        if (ConnectStringElement.DbTypeSection.PostgreSQL.name().equalsIgnoreCase(dbType)) {
            return 13;
        }
        return 2;
    }

    public static DBService getDBService() {
        if (ContextManager.getContext() == null) {
            return new EmptyDBService();
        }
        return (DBService)ContextManager.findService(DBService.class);
    }

    public static boolean checkDbType(String dbName, String type) {
        String t = DbHelper.getDBService().getDbType(dbName);
        return StringUtils.equalsIgnoreCase((String)type, (String)t);
    }

    public static String toFilterSql(Integer filterType, Object field, Object value) {
        return DbHelper.toFilterSql(FilterType.valueOf((Integer)filterType), field, value);
    }

    public static String toFilterSql(FilterType filterType, Object field, Object value) {
        return DbHelper.toFilterSql(filterType, field, value, null);
    }

    public static String toFilterSql(Integer filterType, Object field, Object value, Integer dataType) {
        return DbHelper.toFilterSql(FilterType.valueOf((Integer)filterType), field, value, DataType.valueOf((Integer)dataType));
    }

    public static String toFilterSql(Integer filterType, Object field, Object value, DataType dataType) {
        return DbHelper.toFilterSql(FilterType.valueOf((Integer)filterType), field, value, dataType);
    }

    public static String toFilterSql(FilterType filterType, Object field, Object value, DataType dataType) {
        return DbHelper.toFilterSql(null, filterType, field, value, dataType);
    }

    public static String toFilterSql(String dbName, Integer filterType, Object field, Object value, Integer dataType) {
        return DbHelper.toFilterSql(dbName, FilterType.valueOf((Integer)filterType), field, value, DataType.valueOf((Integer)dataType));
    }

    public static String toFilterSql(String dbName, FilterType filterType, Object field, Object value, DataType dataType) {
        String format = "";
        FilterType filterType2 = filterType = filterType == null ? FilterType.Equal : filterType;
        if (value != null && dataType == null) {
            dataType = DataTypeHelper.ToDataType(value.getClass());
        }
        dataType = dataType == null ? DataType.String : dataType;
        Object relvalue = DbHelper.toSaveValue(dbName, value, dataType);
        if (filterType.equals((Object)FilterType.Equal)) {
            format = "%1$s = %2$s";
        } else if (!filterType.equals((Object)FilterType.GroupAnd) && !filterType.equals((Object)FilterType.GroupOr)) {
            if (filterType.equals((Object)FilterType.Express)) {
                format = field == null ? "" : field.toString();
            } else if (filterType.equals((Object)FilterType.Like)) {
                relvalue = value;
                format = "%1$s like '%%%2$s%%'";
            } else if (filterType.equals((Object)FilterType.In)) {
                format = "%1$s in (%2$s)";
                relvalue = DbHelper.toInValue(dbName, value, dataType);
            } else if (filterType.equals((Object)FilterType.NotIn)) {
                format = "%1$s not in (%2$s)";
                relvalue = DbHelper.toInValue(dbName, value, dataType);
            } else if (filterType.equals((Object)FilterType.NotEqual)) {
                format = "%1$s <> %2$s";
            } else if (filterType.equals((Object)FilterType.Greater)) {
                format = "%1$s > %2$s";
            } else if (filterType.equals((Object)FilterType.GreaterOrEqual)) {
                format = "%1$s >= %2$s";
            } else if (filterType.equals((Object)FilterType.Less)) {
                format = "%1$s < %2$s";
            } else if (filterType.equals((Object)FilterType.LessOrEqual)) {
                format = "%1$s <= %2$s";
            } else if (filterType.equals((Object)FilterType.IsNull)) {
                format = "%1$s is null";
            } else if (filterType.equals((Object)FilterType.Between)) {
                format = "%1$s is not null";
            } else if (filterType.equals((Object)FilterType.StartWith)) {
                relvalue = value;
                format = "%1$s like '%2$s%%'";
            }
        }
        return String.format(format, field, relvalue);
    }

    private static String toInValue(String dbName, Object value, DataType dataType) {
        String[] list = value.toString().split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(DbHelper.toSaveValue(dbName, list[i], dataType));
        }
        return sb.toString();
    }

    private static Object toSaveValue(String dbName, Object v, DataType type) {
        switch (type) {
            case Byte: 
            case Decimal: 
            case Double: 
            case Int16: 
            case Int32: 
            case Int64: 
            case SByte: 
            case Single: 
            case UInt16: 
            case UInt32: 
            case UInt64: {
                String val = v.toString();
                if (StringUtils.isNum((String)val)) {
                    return val;
                }
                return "'" + val + "'";
            }
            case Time: 
            case DateTime: 
            case Date: {
                Object obj = Convert.toObj((Object)v, Date.class);
                if (obj != null) {
                    String value = type == DataType.Date ? StringUtils.toString((Date)((Date)obj), (String)"yyyy-MM-dd") : StringUtils.toString((Date)((Date)obj), (String)"yyyy-MM-dd HH:mm:ss");
                    return String.format("%s", DbHelper.getDBService().getSqlService().buildDateTime(dbName, value, type));
                }
                return String.format("%s", DbHelper.getDBService().getSqlService().buildDateTime(dbName, Convert.toString((Object)obj), type));
            }
        }
        return "'" + (v == null ? "" : v) + "'";
    }

    public static String buildParameterName(String dbName, String columnName) {
        return DbHelper.getDBService().getSqlService().buildParameterName(dbName, columnName);
    }

    public static String buildParamHolder(String dbName, String columnName) {
        return DbHelper.getDBService().getSqlService().buildParamHolder(dbName, columnName);
    }

    public static List<Map<String, Object>> selectMaps(String dbName, String sql, Map<String, Object> params) {
        return DbHelper.getDBService().getSqlService().selectMaps(dbName, sql, params);
    }

    public static Map<?, ?> selectMapOne(String dbName, String sql, Map<String, Object> params) {
        return DbHelper.getDBService().getSqlService().selectMapOne(dbName, sql, params);
    }

    public static List selectObjs(String dbname, String sql, Map<String, Object> params) {
        return DbHelper.getDBService().getSqlService().selectObjs(dbname, sql, params);
    }

    public static Object selectObjOne(String dbName, String cmd, Map<String, Object> params) {
        return DbHelper.getDBService().getSqlService().selectObjOne(dbName, cmd, params);
    }

    public static void mapToEntity(Map map, Object obj) {
        DbHelper.getDBService().mapToEntity(map, obj);
    }

    public static <T> T mapToEntity(Map map, Class<T> clazz) {
        return DbHelper.getDBService().mapToEntity(map, clazz);
    }

    public static Object executeScalar(String dbName, String cmd, Map<String, Object> params) {
        return DbHelper.getDBService().getSqlService().executeScalar(dbName, cmd, params);
    }

    public static int executeUpdate(String dbName, String cmd, Map<String, Object> params) {
        return DbHelper.getDBService().getSqlService().executeUpdate(dbName, cmd, params);
    }

    public static boolean fillDictionary(String dbName, IResDataDict resDict, Object keyId, String[] fieldNames, Map<String, Object> dict) {
        return DbHelper.getDBService().getSqlService().fillDictionary(dbName, resDict, keyId, fieldNames, dict);
    }

    public static boolean hasField(String dbName, String storageName, String columnName) {
        return DbHelper.getDBService().getSqlService().hasField(dbName, storageName, columnName);
    }

    public static int delete(String dbName, IResDataDict dict, Object keyId) {
        return DbHelper.getDBService().getSqlService().delete(dbName, dict, keyId);
    }

    public static int update(String dbName, IResDataDict dict, Object keyId, Map<String, Object> entity) {
        return DbHelper.getDBService().getSqlService().update(dbName, dict, keyId, entity);
    }

    public static int insert(String dbName, IResDataDict dict, Map<String, Object> entity) {
        return DbHelper.getDBService().getSqlService().insert(dbName, dict, entity);
    }

    public static boolean hasTable(String dbName, String name) {
        DBService dbService = DbHelper.getDBService();
        return dbService.getSqlService().hasTable(dbName, name);
    }

    public static int insert(String dbName, Map<String, Object> entity, String tableName) {
        return DbHelper.getDBService().getSqlService().insert(dbName, entity, tableName);
    }

    public static DataTable executeDataSet(String dbName, String sql, Map<String, Object> params) {
        return DbHelper.getDBService().getSqlService().executeDataSet(dbName, sql, params);
    }

    public static String executeAnonymousProcedure(String dbName, String sql, Map<String, Object> params) {
        return DbHelper.getDBService().getSqlService().executeAnonymousProcedure(dbName, sql, params);
    }

    public static String buildDateTime(String dbName, String date, DataType datetime) {
        return DbHelper.getDBService().getSqlService().buildDateTime(dbName, date, datetime);
    }

    public static Date getDbTime(String db) {
        return DbHelper.getDBService().getSqlService().getDbTime(db);
    }

    public static String buildSelectCommand(IDB db, String tableName, List<String> fields, String whereFilter) {
        StringBuilder sb = null;
        boolean first = true;
        for (String fd : fields) {
            if (StringUtils.isEmpty((String)fd)) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
                sb = new StringBuilder("SELECT ");
            }
            sb.append(DbHelper.buildColumnName(db, fd));
        }
        if (sb != null) {
            sb.append(String.format(" FROM %s ", tableName));
            if (!StringUtils.isEmpty((String)whereFilter)) {
                sb.append(" WHERE ");
                sb.append(whereFilter);
            }
            return sb.toString();
        }
        return null;
    }

    public static String buildInsertCommand(IDB db, String table, Map params) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object param : params.keySet()) {
            keys.add((String)param);
        }
        return DbHelper.buildInsertCommand(db, table, keys);
    }

    public static String buildInsertCommand(IDB db, String table, List<String> keys) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        int paramerIndex = 0;
        for (String key : keys) {
            if (paramerIndex != 0) {
                sb.append(',');
                sb1.append(',');
            }
            sb.append(DbHelper.buildColumnName(db, key.toString()));
            sb1.append(db.buildParamHolder(key.toString()));
            ++paramerIndex;
        }
        String sql = String.format("insert into %s (%s) values(%s)", table, sb, sb1);
        return sql;
    }

    public static String buildUpdateCommand(IDB db, String table, Map params, String where) {
        StringBuilder sb = new StringBuilder();
        int paramerIndex = 0;
        for (Object key : params.keySet()) {
            if (paramerIndex != 0) {
                sb.append(',');
            }
            sb.append(String.format("%s = %s ", DbHelper.buildColumnName(db, key.toString()), db.buildParamHolder(key.toString())));
            ++paramerIndex;
        }
        String sql = "";
        sql = !StringUtils.isEmpty((String)where) ? String.format("update %s set %s where %s", table, sb, where) : String.format("update %s set %s", table, sb);
        return sql;
    }

    public static String buildUpdateCommand(IDB db, String tableName, List<String> fieldNames, String where) {
        StringBuilder setValues = null;
        String command = null;
        boolean first = true;
        for (String fieldName : fieldNames) {
            if (!first) {
                setValues.append(',');
            } else {
                first = false;
                setValues = new StringBuilder();
            }
            setValues.append(String.format("%s = %s ", DbHelper.buildColumnName(db, fieldName), db.buildParamHolder(fieldName)));
        }
        command = !StringUtils.isBlank((String)where) ? String.format("update %s set %s where %s", tableName, setValues, where) : String.format("update %s set %s ", tableName, setValues);
        return command;
    }

    public static byte[] bolbToBytes(Object v) {
        if (v != null && v.toString().startsWith("oracle.sql.BLOB")) {
            InvocationHandler proxy = Proxy.getInvocationHandler(v);
            try {
                Blob b = (Blob)ReflectUtils.invoke((Object)proxy, (String)"getWrappedBlob", (Object[])new Object[0]);
                byte[] bs = new byte[]{};
                bs = new byte[(int)b.length()];
                b.getBinaryStream().read(bs);
                return bs;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return (byte[])v;
        }
        catch (Throwable throwable) {
            return new byte[0];
        }
    }

    public static String colbToString(Object v) {
        if (v != null && v.toString().startsWith("oracle.sql.CLOB")) {
            InvocationHandler proxy = Proxy.getInvocationHandler(v);
            try {
                Clob b = (Clob)ReflectUtils.invoke((Object)proxy, (String)"getWrappedClob", (Object[])new Object[0]);
                char[] bs = new char[]{};
                bs = new char[(int)b.length()];
                b.getCharacterStream().read(bs);
                return new String(bs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String buildDisplayExpress(IColumnInfo field) {
        return DbHelper.buildDisplayExpress(field, DbHelper.createDataBase().getDbVendor());
    }

    public static String buildDisplayExpress(IColumnInfo field, int dbVendor) {
        ColumnRelation refType = field.getRelation();
        switch (refType) {
            case BusiStatusGroup: {
                return DbHelper.buildDisplayWithBusiStatusGroup(field);
            }
            case ForeignKeyWithSingle: {
                return DbHelper.buildDisplayWithForeignKeyWithSingle(field);
            }
            case ForeignKeyWithMuti: {
                return DbHelper.buildDisplayWithForeignKeyWithMuti(field);
            }
            case DynamicForeignKeyWithSingle: {
                return DbHelper.buildDisplayWithDynamicForeignKey(field, false);
            }
            case DynamicForeignKeyWithMuti: {
                return DbHelper.buildDisplayWithDynamicForeignKey(field, true);
            }
            case StatusGroup: {
                return DbHelper.buildDisplayWithStatusGroup(field, dbVendor);
            }
            case StatusGroupWithMuti: 
            case BusiStatusGroupWithMuti: {
                return DbHelper.buildDisplayWithBusiStatusGroupWithMuti(field);
            }
        }
        return null;
    }

    public static String buildStatusGroupCodeExpress(IColumnInfo column, int dbVendor) {
        if (!DbHelper.needDisplayColumn(column)) {
            return null;
        }
        ColumnRelation refType = column.getRelation();
        switch (refType) {
            case StatusGroup: {
                return DbHelper.buildDisplayWithStatusGroupCode(column, dbVendor);
            }
        }
        return null;
    }

    private static String buildDisplayWithBusiStatusGroupWithMuti(IColumnInfo field) {
        String relationid = field.getRelationId();
        StatusGroup statusGroup = StatusGroup.getStatusGroup((String)relationid, (boolean)true);
        return DbHelper.buildDisplayWithBusiStatusGroupWithMuti(field, statusGroup, s -> s.getStatusname());
    }

    private static String buildDisplayWithBusiStatusGroupWithMuti(IColumnInfo field, StatusGroup statusGroup, Function<StatusItem, Object> vfun) {
        String fieldPart = DbHelper.buildFieldPart(field.getColumnName(), field);
        String exp = null;
        ISqlCoder dbCoder = ISqlCoder.instance();
        if (dbCoder != null) {
            int dataType = field.getDataType().getValue();
            exp = dbCoder.buildMultiStatusDisplayPart(DbHelper.createDataBase().getDbVendor(), fieldPart, s -> {
                if (s == null) {
                    return DbHelper.buildDisplayStatusTable(dataType, statusGroup, vfun);
                }
                return DbHelper.buildDisplayWithStatus(dataType, s, statusGroup, vfun, DbHelper.createDataBase().getDbVendor());
            });
        }
        return exp;
    }

    private static String buildDisplayStatusTable(Integer dataType, StatusGroup statusGroup, Function<StatusItem, Object> vfun) {
        List statusItems = statusGroup.getItems();
        if (statusItems == null || statusItems.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean needQuote = DbHelper.needQuoteType(dataType);
        String condition = needQuote ? "select '%s' v,'%s' n from dual" : "select %s v,'%s' n from dual ";
        MobileDictionary items = new MobileDictionary();
        for (StatusItem item : statusItems) {
            Object obj;
            if (item.getStatusvalue() == null || (obj = vfun.apply(item)) == null) continue;
            items.add(item.getStatusvalue(), obj);
        }
        if (items.size() <= 0) {
            return null;
        }
        int i = 0;
        for (String key : items.getKeySet()) {
            String str = String.format(condition, key, items.get(key).toString());
            if (i > 0) {
                sb.append(" union ");
            }
            sb.append(str);
        }
        sb.append(") _st");
        return sb.toString();
    }

    public static String buildDisplayWithStatusGroup(IColumnInfo column, int dbVendor) {
        return DbHelper.buildDisplayWithStatus(column, s -> s.getStatusname(), dbVendor);
    }

    public static String buildDisplayWithStatusGroupCode(IColumnInfo column, int dbVendor) {
        return DbHelper.buildDisplayWithStatus(column, s -> s.getStatuscode(), dbVendor);
    }

    private static String buildDisplayWithStatus(IColumnInfo column, Function<StatusItem, Object> vfun, int dbVendor) {
        String relationid = column.getRelationId();
        int dataType = column.getDataType().getValue();
        String fieldPart = DbHelper.buildFieldPart(column.getColumnName(), column);
        StatusGroup statusGroup = StatusGroup.getStatusGroup((String)relationid, (boolean)true);
        return DbHelper.buildDisplayWithStatus(dataType, fieldPart, statusGroup, vfun, dbVendor);
    }

    private static String buildDisplayWithStatus(int dataType, String fieldPart, StatusGroup statusGroup, Function<StatusItem, Object> vfun, int dbVendor) {
        Integer dbType = 0;
        if (statusGroup == null) {
            return null;
        }
        List statusItems = statusGroup.getItems();
        if (statusItems == null || statusItems.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CASE ");
        boolean needQuote = DbHelper.needQuoteType(dataType);
        if (dbType == 2 && needQuote) {
            sb.append("to_char(").append(fieldPart).append(") ");
        } else {
            sb.append(fieldPart).append(" ");
        }
        String condition = needQuote ? "WHEN '%s' THEN '%s' " : "WHEN %s THEN '%s' ";
        MobileDictionary items = new MobileDictionary();
        for (StatusItem item : statusItems) {
            Object obj;
            if (item.getStatusvalue() == null || (obj = vfun.apply(item)) == null) continue;
            items.add(item.getStatusvalue(), obj);
        }
        if (items.size() <= 0) {
            return null;
        }
        for (String key : items.getKeySet()) {
            String str = String.format(condition, key, items.get(key).toString());
            sb.append(str);
        }
        sb.append("ELSE ").append(needQuote && dbType != 2 ? fieldPart : DbHelper.convertToStringPart(fieldPart, dbVendor)).append(" ");
        sb.append("END");
        return sb.toString();
    }

    private static String convertToStringPart(String fieldPart, int dbVendor) {
        ISqlCoder dbCoder = ISqlCoder.instance();
        if (dbCoder != null) {
            return dbCoder.convertToStringPart(dbVendor, fieldPart);
        }
        return String.format("to_char(%s)", fieldPart);
    }

    private static String buildDisplayWithDynamicForeignKey(IColumnInfo column, boolean isMuti) {
        String fieldPart = DbHelper.buildFieldPart(column.getColumnName(), column);
        String sb = DbHelper.getDynamicDisplayPart(column, fieldPart, isMuti);
        return sb;
    }

    static String getDynamicDisplayPart(IColumnInfo refColumn, String fieldPart, boolean isMuti) {
        String relationid = refColumn.getRelationId();
        Integer dataType = refColumn.getDataType().getValue();
        Integer dbType = 0;
        StatusGroup statusGroup = StatusGroup.getStatusGroup((String)relationid, (boolean)true);
        if (statusGroup == null) {
            return null;
        }
        List statusItems = statusGroup.getItems();
        if (statusItems == null || statusItems.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CASE ");
        boolean needQuote = DbHelper.needQuoteType(dataType);
        if (dbType == 2 && needQuote) {
            sb.append("to_char(").append(fieldPart).append(") ");
        } else {
            sb.append(fieldPart).append(" ");
        }
        String condition = needQuote ? "WHEN '%s' THEN '%s' " : "WHEN %s THEN '%s' ";
        MobileDictionary items = new MobileDictionary();
        for (StatusItem item : statusItems) {
            items.add(item.getStatusvalue(), (Object)item.getStatusname());
        }
        boolean hasItem = false;
        for (String key : items.getKeySet()) {
            if (StringUtils.isBlank((String)key)) continue;
            IResDataDict resDict = ResDataDict.getResDataDict((String)key, (boolean)true);
            String fkPart = isMuti ? DbHelper.getMutiFKDisplayPart(resDict, fieldPart) : DbHelper.getFKDisplayPart(resDict, fieldPart);
            String str = String.format(condition, key, StringUtils.isBlank((String)fkPart) ? fieldPart : "(" + fkPart + ")");
            sb.append(str);
            hasItem = true;
        }
        sb.append("END");
        if (hasItem) {
            return sb.toString();
        }
        return null;
    }

    public static boolean needQuoteType(Integer dataType) {
        DataType type = DataType.valueOf((Integer)dataType);
        switch (type) {
            case DateTime: 
            case Date: 
            case Guid: 
            case String: {
                return true;
            }
        }
        return false;
    }

    private static String buildDisplayWithForeignKeyWithMuti(IColumnInfo column) {
        String relationid = column.getRelationId();
        String fieldPart = DbHelper.buildFieldPart(column.getColumnName(), column);
        IResDataDict resDict = ResDataDict.getResDataDict((String)relationid, (boolean)true);
        if (resDict == null) {
            return null;
        }
        return DbHelper.getMutiFKDisplayPart(resDict, fieldPart);
    }

    public static String getMutiFKDisplayPart(IResDataDict resDict, String fieldPart) {
        if (resDict == null) {
            return null;
        }
        if (StringUtils.isBlank((String)resDict.getDisplayColumnName())) {
            return fieldPart;
        }
        String displayField = resDict.getDisplayColumnName();
        String exp = null;
        ISqlCoder dbCoder = (ISqlCoder)ContextManager.find(ISqlCoder.class);
        if (dbCoder != null) {
            exp = dbCoder.buildMultiFKDisplayPart(DbHelper.createDataBase().getDbVendor(), fieldPart, resDict.getStorageName(), resDict.getKeyColumnName(), displayField);
        }
        return exp;
    }

    private static String buildDisplayWithForeignKeyWithSingle(IColumnInfo column) {
        String relationid = column.getRelationId();
        String fieldPart = DbHelper.buildFieldPart(column.getColumnName(), column);
        IResDataDict resDict = ResDataDict.getResDataDict((String)relationid, (boolean)true);
        String exp = DbHelper.getFKDisplayPart(resDict, fieldPart);
        if (resDict == null) {
            return null;
        }
        if (StringUtils.isBlank((String)resDict.getDisplayColumnName())) {
            exp = fieldPart;
        } else if (resDict.getEntitytype() == 3) {
            exp = String.format("SELECT a0.displayname FROM SYS_EXTRESINSNAME a0 WHERE a0.RESID='%s' and a0.resinsid=(%s)", resDict.getResId(), fieldPart);
        } else {
            String displayField = resDict.getDisplayColumnName();
            exp = String.format("SELECT a0.%s FROM %s a0 WHERE a0.%s=(%s)", displayField, resDict.getStorageName(), resDict.getKeyColumnName(), fieldPart);
        }
        return exp;
    }

    private static String buildDisplayWithBusiStatusGroup(IColumnInfo column) {
        return null;
    }

    private static String buildFieldPart(String fieldName, IColumnInfo fieldInfo) {
        if (!StringUtils.isBlank((String)fieldInfo.getColumnExpress()) && (fieldInfo.isExpressColumn() || fieldInfo.isVirtualColumn())) {
            String exp = fieldInfo.getColumnExpress();
            if (StringUtils.isBlank((String)exp)) {
                exp = "null";
            }
            return "(" + exp + ")";
        }
        if (fieldInfo.getColumnOwner() == null) {
            return fieldName;
        }
        return String.format("%s.%s", fieldInfo.getColumnOwner().getStorageName(), fieldName);
    }

    static String getFKDisplayPart(IResDataDict resDict, String fieldPart) {
        if (resDict == null) {
            return null;
        }
        String exp = null;
        if (StringUtils.isBlank((String)resDict.getDisplayColumnName())) {
            exp = fieldPart;
        } else if (resDict.getEntitytype() == 3) {
            exp = String.format("SELECT a0.displayname FROM SYS_EXTRESINSNAME a0 WHERE a0.RESID='%s' and a0.resinsid=(%s)", resDict.getResId(), fieldPart);
        } else {
            String displayField = resDict.getDisplayColumnName();
            exp = String.format("SELECT a0.%s FROM %s a0 WHERE a0.%s=(%s)", displayField, resDict.getStorageName(), resDict.getKeyColumnName(), fieldPart);
        }
        return exp;
    }

    public static boolean needDisplayColumn(IColumnInfo field) {
        if (field.isKeyColumn()) {
            return false;
        }
        ColumnRelation refType = field.getRelation();
        if (refType == null || refType == ColumnRelation.None) {
            return false;
        }
        switch (refType) {
            case BusiStatusGroup: 
            case ForeignKeyWithSingle: 
            case ForeignKeyWithMuti: 
            case DynamicForeignKeyWithSingle: 
            case DynamicForeignKeyWithMuti: 
            case StatusGroup: 
            case StatusGroupWithMuti: 
            case BusiStatusGroupWithMuti: {
                return true;
            }
        }
        return false;
    }

    public static Object getTableName(Class<?> clazz) {
        return BeanHelper.getTableName(clazz);
    }

    public static String buildTopSqlFormat(IDB db, String where) {
        String dbType = db.getDbType().toLowerCase();
        if (dbType.contains("oracle")) {
            return StringUtils.isEmpty((String)where) ? "select * from %1$s where rownum <= %2$s order by rownum asc" : "select * from %1$s where " + where + "and rownum <= %2$s order by rownum asc";
        }
        if (dbType.contains("mysql")) {
            return StringUtils.isEmpty((String)where) ? "select * from %1$s limit %2$s" : "select * from %1$s where " + where + " limit %2$s";
        }
        return StringUtils.isEmpty((String)where) ? "select top %2$s * from %1$s" : "select top %2$s * from %1$s where " + where;
    }

    public static String buildColumnName(IDB db, String colName) {
        return db.getDialect().buildColumnName(colName);
    }

    public static String buildColumnName(int dbVendor, String colName) {
        try {
            Dialect dialect = DBSourceFactory.instance().getDialect(dbVendor);
            return dialect.buildColumnName(colName);
        }
        catch (Exception e) {
            return colName;
        }
    }

    @Component
    @CustomConditionalOnMissing(value={IDB.IDatabaseEventProvd.class})
    public static class MyDatabaseEventProvd
    extends DatabaseEventProvd
    implements IDB.IDatabaseEventProvd {
        public void FireBeginCommandExecutedEvent(IDB database, Date startTime, IDB.IDbCommand command) {
            super.FireBeginCommandExecutedEvent(database, startTime, command);
        }

        public void FireEndCommandExecutedEvent(IDB database, Date startTime, Date endTime, IDB.IDbCommand command) {
            super.FireEndCommandExecutedEvent(database, startTime, endTime, command);
        }

        public void FireCommandFailedEvent(IDB database, IDB.IDbCommand command, String connectionString, Exception exception) {
            super.FireCommandFailedEvent(database, command, connectionString, exception);
        }

        public void FireConnectionFailedEvent(IDB database, String connectionString, Exception exception) {
            super.FireConnectionFailedEvent(database, connectionString, exception);
            ILogSqlBuilder log = IAgpLogger.logSqlBuilder();
            log.logInfo("connection", connectionString).error(exception);
        }
    }
}

