/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.cache.ICacheKey;
import cn.hangar.agp.platform.core.cache.ICacheManager;
import cn.hangar.agp.platform.core.cache.IRegionCache;
import cn.hangar.agp.platform.core.data.BeanHelper;
import cn.hangar.agp.platform.core.data.IResDataDict;
import cn.hangar.agp.platform.core.data.PropertyValueHelper;
import cn.hangar.agp.platform.core.db.IDB;
import cn.hangar.agp.platform.core.db.transaction.DataSourceTransactionScope;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.paramer.ExpressHelper;
import cn.hangar.agp.platform.core.serialize.SerializeFactory;
import cn.hangar.agp.platform.utils.CollectionUtil;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.ExecutorServiceHelper;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.CacheService;
import cn.hangar.agp.service.core.DataSourceService;
import cn.hangar.agp.service.core.util.DbHelper;
import cn.hangar.agp.service.model.datasource.DataSourceItemSaveArg;
import cn.hangar.agp.service.model.datasource.DataSourceSaveArg;
import cn.hangar.agp.service.model.datasource.ResDataDict;
import com.alibaba.fastjson.JSON;
import com.greenpineyu.fel.Fel;
import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.context.FelContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.springframework.cache.Cache;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class CacheHelper {
    static ExecutorService executorService = ExecutorServiceHelper.newCachedThreadPool((String)"redis");
    private static FelEngine _engine;

    public static void redisSet(Object resid, Object data, Object field, Object val) {
        CacheHelper.redisSet(resid, data, field, val, false);
    }

    public static void redisSet(Object resid, Object data, Object field, int val, boolean syndb) {
        CacheHelper.redisSet(resid, data, field == null ? null : CollectionUtil.defaultMap((Object)field, (Object)val), syndb);
    }

    public static void redisSet(Object resid, Object data, Object field, Object val, boolean syndb) {
        CacheHelper.redisSet(resid, data, field == null ? null : CollectionUtil.defaultMap((Object)field, (Object)val), syndb);
    }

    public static void redisSet(final Object resid, final Object data, Map fields, boolean syndb) {
        block23: {
            if (data instanceof List) {
                for (Object d : (List)data) {
                    CacheHelper.redisSet(resid, d, fields, syndb);
                }
                return;
            }
            boolean isHasTimeout = false;
            Integer timeOut = null;
            if (fields != null) {
                for (Object field : fields.keySet()) {
                    if (field.toString().equalsIgnoreCase("timeout")) {
                        isHasTimeout = true;
                        timeOut = Convert.toInteger(fields.get(field));
                        continue;
                    }
                    PropertyValueHelper.setValue((Object)data, (String)field.toString(), fields.get(field));
                }
            }
            final IResDataDict dict = ResDataDict.getResDataDict((String)resid.toString());
            final AppContext context = AppContext.Current();
            final Integer finalTimeOut = timeOut;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AppContext.setCurrent((AppContext)context);
                    CacheService cache = CacheService.instance();
                    CacheHelper.saveToRedis(cache, resid, dict, data, AppContext.getCurrentAppId(), finalTimeOut);
                }
            };
            if (syndb) {
                Assert.notNull((Object)dict, (String)("\u65e0\u6cd5\u540c\u6b65\u5230db.\u672a\u77e5\u8d44\u6e90" + resid));
                try (DataSourceTransactionScope scope = new DataSourceTransactionScope();){
                    ArrayList<Map> dataList = new ArrayList<Map>();
                    dataList.add(BeanHelper.entityToMap((Object)data));
                    if (isHasTimeout) {
                        CacheHelper.doOpDatabase(dataList, resid.toString(), "del");
                    } else {
                        CacheHelper.doOpDatabase(dataList, resid.toString(), "add");
                    }
                    if (!DataSourceTransactionScope.registerSucceedSynchronization(o -> executorService.execute(runnable), null)) {
                        executorService.execute(runnable);
                    }
                    scope.commit();
                    break block23;
                }
                catch (Exception e) {
                    throw new AppException((Throwable)e);
                }
            }
            runnable.run();
        }
    }

    private static void doOpDatabase(List<Map> dataList, String resid, String op) {
        DataSourceItemSaveArg dataSourceItemSaveArg = new DataSourceItemSaveArg();
        dataSourceItemSaveArg.setSourceName(resid);
        if ("add".equals(op)) {
            dataSourceItemSaveArg.setAddItems(dataList);
        } else if ("del".equals(op)) {
            dataSourceItemSaveArg.setDeleteItems(dataList);
        }
        DataSourceSaveArg dataSourceSaveArg = new DataSourceSaveArg();
        dataSourceSaveArg.getItems().add(dataSourceItemSaveArg);
        DataSourceService dataSourceService = DataSourceService.instance();
        dataSourceService.saveEntity(dataSourceSaveArg);
    }

    public static Object redisGet(Object resid, String filters, String orderby, Object data, Class clazz) {
        return CacheHelper.redisGet(resid, filters, orderby, data, clazz, false);
    }

    public static Object redisGet(Object resid, String filters, String orderby, Object data, Class clazz, boolean syndb) {
        CacheService cache = CacheService.instance();
        List<Object> results = CacheHelper.loadFromRedis(cache, resid, filters, orderby, data);
        if (syndb && CollectionUtils.isEmpty(results)) {
            CacheHelper.loadFromDb(resid, filters, data, orderby);
        }
        if (clazz != null) {
            if (String.class.isAssignableFrom(clazz)) {
                return SerializeFactory.toJson(results);
            }
            return SerializeFactory.clone(results, (Class)clazz);
        }
        return results;
    }

    private static FelEngine getFelEngine() {
        if (_engine == null) {
            _engine = Fel.newEngine();
        }
        return _engine;
    }

    public static List<Object> loadFromRedis(CacheService cache, Object resid, String filters, String orderby, Object data) {
        List<Object> strs = null;
        boolean needFilter = false;
        if (StringUtils.isEmpty((String)filters)) {
            String region = String.format("%s.%s", AppContext.getCurrentAppId(), resid);
            strs = cache.findByRegion(region);
        } else {
            String appId = AppContext.getCurrentAppId();
            IResDataDict res = ResDataDict.getResDataDict((String)resid.toString(), (boolean)true);
            if (res != null) {
                String resIndexStr = CacheHelper.getResIndex(res);
                Set resIndexs = CollectionUtil.toSet((Object[])StringUtils.split((String)resIndexStr, (String[])new String[]{";", ","}, (boolean)true));
                resIndexs.add(res.getKeyColumnName());
                String key = "";
                String resIndex = null;
                Map<String, Object> map = CacheHelper.toDataByFilter(filters, data);
                for (String t2 : resIndexs) {
                    String tempT = CacheHelper.toIndexKey(t2, map, true);
                    if (tempT == null || tempT.length() <= key.length()) continue;
                    key = tempT;
                    resIndex = t2;
                }
                String region = StringUtils.isEmpty(resIndex) ? String.format("%s.%s", AppContext.getCurrentAppId(), resid) : (resIndex.equalsIgnoreCase(res.getKeyColumnName()) ? String.format("%s.%s.%s", appId, resid, key) : String.format("%s.%s.%s", appId, resid + "_index", key));
                boolean useIndex = !StringUtils.isEmpty((String)resIndex) && !resIndex.equalsIgnoreCase(res.getKeyColumnName());
                strs = cache.findByRegion(region);
                if (useIndex) {
                    ArrayList<Object> rstrs = new ArrayList<Object>();
                    for (Object k : strs) {
                        Object t3 = cache.get(k.toString(), appId);
                        rstrs.add(t3);
                    }
                    strs = rstrs;
                }
                needFilter = StringUtils.isEmpty((String)resIndex) || !CollectionUtil.toSet((Object[])resIndex.split("\\.")).containsAll(map.keySet());
            } else {
                String keyPrefix = ExpressHelper.replaceCommand((Object)data, (String)resid.toString());
                String region = String.format("%s.%s", AppContext.getCurrentAppId(), keyPrefix);
                strs = cache.findByRegion(region);
            }
        }
        ArrayList<Object> objs = new ArrayList<Object>();
        strs.forEach(s -> objs.add(SerializeFactory.parseJson((String)s.toString())));
        List<Object> results = objs;
        if (needFilter) {
            results = new ArrayList();
            String filterStr = CacheHelper.replaceParams(filters, data);
            String fliter = filterStr.replace("=", "==");
            fliter = fliter.replace(" and ", " && ");
            fliter = fliter.replace(" or ", " || ");
            for (Object e : objs) {
                ExpressHelper.CaseMapContext ctx = new ExpressHelper.CaseMapContext(BeanHelper.entityToMap(e));
                if (!Convert.toBoolean((Object)CacheHelper.getFelEngine().eval(fliter, (FelContext)ctx))) continue;
                results.add(e);
            }
        }
        String orderbyStr = CacheHelper.replaceParams(orderby, data);
        if (!results.isEmpty() && !StringUtils.isEmpty((String)orderbyStr)) {
            results = CollectionUtil.orderBy(results, t -> PropertyValueHelper.getValue((Object)t, (String)orderbyStr));
        }
        return results;
    }

    public static List<Object> loadFromDb(Object resid, String filters, Object data, String orderby) {
        String orderbyStr;
        IResDataDict dict = ResDataDict.getResDataDict((String)resid.toString());
        String tableName = dict.getStorageName();
        String sql = "SELECT * FROM " + tableName;
        String filterStr = CacheHelper.replaceParams(filters, data);
        if (StringUtils.isNotBlank((String)filterStr)) {
            sql = sql + " WHERE " + filterStr;
        }
        if (StringUtils.isNotBlank((String)(orderbyStr = CacheHelper.replaceParams(orderby, data)))) {
            sql = sql + " order by " + orderbyStr;
        }
        IDB dataBase = DbHelper.createDataBase("Default");
        List resultList = dataBase.selectMaps(sql, null);
        List list = null;
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            CacheService cache = CacheService.instance();
            String appId = AppContext.getCurrentAppId();
            for (Map result : resultList) {
                CacheHelper.saveToRedis(cache, resid, dict, result, appId);
            }
            list = JSON.parseArray((String)JSON.toJSONString((Object)resultList), Object.class);
        }
        return list;
    }

    public static void saveToRedis(CacheService cache, IResDataDict dict, Object data, String region) {
        CacheHelper.saveToRedis(cache, dict == null ? null : dict.getResId(), dict, data, region, null);
    }

    public static void saveToRedis(CacheService cache, Object resid, IResDataDict dict, Object data, String region) {
        CacheHelper.saveToRedis(cache, resid, dict, data, region, null);
    }

    public static void saveToRedis(CacheService cache, Object resid, IResDataDict dict, Object data, String region, Integer timeOut) {
        if (dict != null) {
            String[] resIndexs;
            String key = Convert.toString((Object)PropertyValueHelper.getValue((Object)data, (String)dict.getKeyColumnName()));
            key = String.format("%s.%s", dict.getResId(), key);
            String dataStr = SerializeFactory.toJson((Object)data);
            cache.put(key, dataStr, region, timeOut);
            Logger.info(CacheHelper.class, (String)String.format("\u66f4\u65b0\u7f13\u5b58key:%s timeOut:%s value:\r\n%s", key, timeOut, dataStr));
            String resIndexStr = CacheHelper.getResIndex(dict);
            for (String resIndex : resIndexs = StringUtils.split((String)resIndexStr, (String[])new String[]{";", ","}, (boolean)true)) {
                String ikey = CacheHelper.toIndexKey(resIndex, data, false);
                String string = ikey = StringUtils.isEmpty((String)ikey) ? null : String.format("%s.%s", dict.getResId() + "_index", ikey);
                if (StringUtils.isEmpty((String)ikey) || ikey.equals(key)) continue;
                cache.put(ikey, key, region, timeOut);
            }
        } else {
            String key = ExpressHelper.replaceCommand((Object)data, (String)resid.toString());
            String dataStr = SerializeFactory.toJson((Object)data);
            cache.put(key, dataStr, region, timeOut);
            Logger.info(CacheHelper.class, (String)String.format("\u66f4\u65b0\u7f13\u5b58key:%s timeOut:%s value:\r\n%s", key, timeOut, dataStr));
        }
    }

    static String getResIndex(Object resid) {
        IResDataDict resDict = ResDataDict.getResDataDict((String)Convert.toString((Object)resid), (boolean)true);
        return CacheHelper.getResIndex(resDict);
    }

    static String getResIndex(IResDataDict resDict) {
        return resDict == null ? null : resDict.getRedisKey();
    }

    static String toIndexKey(String indexStr, Object data, boolean isRegionSearch) {
        String field;
        Object o;
        if (indexStr == null) {
            return null;
        }
        Map map = BeanHelper.entityToMap((Object)data);
        String[] fields = indexStr.split("\\.");
        String v = "";
        String[] stringArray = fields;
        int n = stringArray.length;
        for (int i = 0; !(i >= n || (o = map.get(field = stringArray[i])) == null && isRegionSearch); ++i) {
            v = v + (o == null ? "" : o) + ".";
        }
        v = v.length() > 0 ? v.substring(0, v.length() - 1) : v;
        return v;
    }

    private static Map<String, Object> toDataByFilter(String filters, Object data) {
        return ExpressHelper.getSqlParams((String)filters, (Object)data);
    }

    private static String replaceParams(String exp, Object data) {
        return ExpressHelper.replaceSqlParams((String)exp, (Object)data);
    }

    public static <T, K extends ICacheKey> T fetchFromCache(String methodName, K argument, Function<K, T> fetchFromDB, boolean acceptNull) {
        return CacheHelper.fetchFromCache(methodName, argument, fetchFromDB, acceptNull, 0);
    }

    public static <T, K extends ICacheKey> T fetchFromCache(String methodName, K argument, Function<K, T> fetchFromDB, boolean acceptNull, int timeOut) {
        Cache.ValueWrapper wrapper;
        IRegionCache cache = ICacheManager.instance().getDefaultCache();
        String key = argument.getCacheKey(null, methodName, new Object[]{argument});
        if (argument.isEnableCache() && (wrapper = cache.get((Object)key)) != null && (acceptNull || wrapper.get() != null)) {
            return (T)wrapper.get();
        }
        T t = fetchFromDB.apply(argument);
        if ((t != null || acceptNull) && argument.isEnableCache()) {
            cache.put((Object)key, t);
            if (timeOut > 0) {
                cache.expire(key, timeOut);
            }
        }
        return t;
    }

    public static <T, K extends ICacheKey> void clearCache(String methodName, K argument) {
        IRegionCache cache = ICacheManager.instance().getDefaultCache();
        String key = argument.getCacheKey(null, methodName, new Object[]{argument});
        cache.expire(key, 1);
    }
}

