/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.config.ConfigManager;
import cn.hangar.agp.platform.core.data.FileItem;
import cn.hangar.agp.platform.core.db.ConnectStringElement;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.core.rest.WebHelper;
import cn.hangar.agp.platform.core.serialize.SerializeFactory;
import cn.hangar.agp.platform.core.util.UrlHelper;
import cn.hangar.agp.platform.utils.CmdUtils;
import cn.hangar.agp.platform.utils.CollectionUtil;
import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.platform.utils.HttpUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.DBService;
import cn.hangar.agp.service.core.FileResolver;
import cn.hangar.agp.service.core.IAttachProvider;
import cn.hangar.agp.service.core.util.AppHelper;
import cn.hangar.agp.service.model.doc.AttachAddArgument;
import cn.hangar.agp.service.model.file.FileResolveArgument;
import cn.hangar.agp.service.model.sys.SysAppCfg;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class AttachHelper {
    public static String[] CanGenerateThumbnailList = new String[]{"png", "gif", "jpg", "jpeg", "ico", "bmp"};
    public static String[] ImageExtList = new String[]{"png", "gif", "jpg", "jpeg", "ico", "bmp"};
    public static String[] VideoExtList = new String[]{"avi", "mpg", "mpeg", "mp4", "mkv", "rm", "ram", "rmvb", "flv"};
    public static String[] AudioExtList = new String[]{"mp3", "wav", "wma", "ogg", "ape", "flac", "aac"};
    public static Map<String, String[]> ExtMap = new HashMap<String, String[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("access", new String[]{"mdb", "mda", "mde"});
            this.put("excel", new String[]{"xls", "xlsx", "xslm"});
            this.put("word", new String[]{"doc", "docx"});
            this.put("ppt", new String[]{"ppt", "pptx"});
            this.put("exe", new String[]{"exe", "dll"});
            this.put("html", new String[]{"htm", "html", "mht", "mhtml"});
            this.put("music", new String[]{"wav", "aif", "au", "mp3"});
            this.put("video", new String[]{"avi", "mpg", "mpeg", "mp4", "mkv", "rm", "ram", "rmvb"});
            this.put("text", new String[]{"txt", "log"});
            this.put("xml", new String[]{"xml"});
            this.put("zip", new String[]{"zip", "rar", "7z"});
        }
    };

    public static boolean canGenerateThumbnail(String ext) {
        if (StringUtils.isEmpty((String)ext)) {
            return false;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(0, 0) + ext.substring(1);
        }
        String exts = ext;
        return CollectionUtil.any((Object[])CanGenerateThumbnailList, s -> StringUtils.equals((String)s, (String)exts));
    }

    public static boolean isImage(String ext) {
        if (StringUtils.isBlank((String)ext)) {
            return false;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        String temp = ext;
        return CollectionUtil.any((Object[])ImageExtList, s -> s.equalsIgnoreCase(temp));
    }

    public static boolean isAudio(String ext) {
        if (StringUtils.isBlank((String)ext)) {
            return false;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        String temp = ext;
        return CollectionUtil.any((Object[])AudioExtList, s -> s.equalsIgnoreCase(temp));
    }

    public static boolean isVideo(String ext) {
        if (StringUtils.isBlank((String)ext)) {
            return false;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        String temp = ext;
        return CollectionUtil.any((Object[])VideoExtList, s -> s.equalsIgnoreCase(temp));
    }

    public static String getExtKey(String ext) {
        if (StringUtils.isEmpty((String)ext)) {
            return null;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        for (Map.Entry<String, String[]> en : ExtMap.entrySet()) {
            for (String ss : en.getValue()) {
                if (!StringUtils.equalsIgnoreCase((String)ss, (String)ext)) continue;
                return en.getKey();
            }
        }
        return null;
    }

    public static IAttachProvider getAttachProvide(String refId, String attachType) {
        if (!StringUtils.isEmpty((String)attachType)) {
            return (IAttachProvider)ContextManager.find((String)attachType, IAttachProvider.class);
        }
        String name = null;
        boolean isUseShareFileServer = StringUtils.equals((String)ConfigManager.getProperty((String)"isUseShareFileServer"), (String)"true");
        if (isUseShareFileServer) {
            name = "share_file_attach";
        } else {
            ConnectStringElement cee;
            String providerName = null;
            DBService dbService = (DBService)ContextManager.findService(DBService.class);
            if (!StringUtils.isEmpty((String)refId)) {
                cee = dbService.getConnectSetting(refId);
                String string = providerName = cee == null ? null : cee.getProviderName();
            }
            if (providerName == null) {
                cee = dbService.getConnectSetting("AttachDatabase");
                String string = providerName = cee == null ? null : cee.getProviderName();
            }
            name = StringUtils.equalsIgnoreCase((String)"Db", providerName) ? "db_attach" : (StringUtils.equalsIgnoreCase((String)"Ftp", (String)providerName) ? "ftp_attach" : (StringUtils.equalsIgnoreCase((String)"File", (String)providerName) ? "file_attach" : (StringUtils.equalsIgnoreCase((String)"FastDFS", (String)providerName) ? "fastdfs_attach" : "file_attach")));
        }
        return (IAttachProvider)ContextManager.find((String)name, IAttachProvider.class);
    }

    public static String getTemplatePath() {
        String tepmplateFiles = ConfigManager.getProperty((String)"template_files_path");
        tepmplateFiles = StringUtils.isEmpty((String)tepmplateFiles) ? "templates" : tepmplateFiles;
        return tepmplateFiles;
    }

    public static IAttachProvider getAttachProvider() {
        String url = AttachHelper.getUrl(null, null, null);
        if (url.contains("aliyuncs")) {
            return (IAttachProvider)ContextManager.find((String)"aliyun_attach");
        }
        return (IAttachProvider)ContextManager.find((String)"file_attach");
    }

    public static String getUrl(String refId, String pappid, Map<String, String> properties) {
        String str;
        String protocol;
        String ftpPath;
        URL url = null;
        String appId = AppContext.getCurrentAppId();
        if (StringUtils.isEmpty((String)pappid)) {
            pappid = AppHelper.getParentAppIdWithBrh(AppContext.getCurrentAppId());
        }
        if (properties != null && properties.containsKey("file_path_url")) {
            url = UrlHelper.getUrl((String)properties.get("file_path_url"));
        }
        SysAppCfg appCfg = SysAppCfg.getSysAppCfg((String)appId, (boolean)true);
        String string = ftpPath = ConfigManager.isRelease() ? null : appCfg.getFtpPath();
        if (ftpPath != null) {
            if ("smb://root:hangar18@192.168.1.18/fileAttach".equals(ftpPath) && "linux".equals(CmdUtils.getSystem()) && !ConfigManager.isRelease()) {
                ftpPath = "/home/fileAttach";
            }
            if (ftpPath.contains("aliyuncs")) {
                if (!ConfigManager.isRelease()) {
                    if ("linux".equals(CmdUtils.getSystem())) {
                        return "/home/fileAttach";
                    }
                    return "smb://root:hangar18@192.168.1.18/fileAttach";
                }
                return ftpPath;
            }
            return !ftpPath.endsWith("/") && !ftpPath.endsWith("\\") ? ftpPath + "/" + pappid + "/" : ftpPath + pappid + "/";
        }
        if (url == null && ftpPath == null) {
            url = UrlHelper.getUrl((String)refId, (String)pappid);
        }
        if (url == null && ftpPath == null) {
            url = UrlHelper.getUrl((String)"AttachDatabase", (String)pappid);
        }
        if ("http".equals(protocol = url.getProtocol()) || "https".equals(protocol)) {
            return url.toString();
        }
        String string2 = str = "file".equalsIgnoreCase(protocol) ? url.getPath() : url.toString();
        if (str.indexOf(":") != -1 || str.startsWith("\\\\")) {
            str = StringUtils.trimStart((String)str, (char)'/');
        }
        if (str.indexOf("smb:") != -1) {
            if (!str.endsWith("/")) {
                str = str + "/";
            }
            if ((str = str.substring(str.indexOf("smb:"))).indexOf("smb://") == -1) {
                str = str.substring(0, 4) + "/" + str.substring(4);
            }
            str = str + pappid + "/";
        } else {
            if (!str.endsWith("/") && !str.endsWith("\\")) {
                str = str + File.separator;
            }
            str = str + pappid + File.separator;
        }
        return str;
    }

    public static AttachAddArgument prepareAttachArgument(HttpServletRequest request) {
        Map params = WebHelper.requestToMapString((HttpServletRequest)request);
        String filePath = params.getOrDefault("filePath", "");
        boolean insertDoc = "1".equals(WebHelper.getParameter((HttpServletRequest)request, (String)"insdoc"));
        if ("1".equals(params.getOrDefault("extMode", "0"))) {
            return AttachHelper.prepareAttachArgumentByServer(insertDoc, params, filePath);
        }
        if (StringUtils.isBlank((String)((String)params.get("POINTID")))) {
            CommonsMultipartResolver commonsMultipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            request = commonsMultipartResolver.resolveMultipart(request);
            params = WebHelper.requestToMapString((HttpServletRequest)request);
        }
        FileItem file = null;
        String imgBase64 = (String)params.get("imgBase64");
        if (StringUtils.isBlank((String)imgBase64)) {
            try {
                BufferedReader reader = request.getReader();
                StringBuilder builder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    builder.append(line);
                    line = reader.readLine();
                }
                reader.close();
                String reqBody = builder.toString();
                JSONObject jb = JSONObject.parseObject((String)reqBody);
                imgBase64 = jb.getString("imgBase64");
            }
            catch (Exception reader) {
                // empty catch block
            }
        }
        if (FileItem.isIllegal((String)(file = StringUtils.isBlank((String)imgBase64) ? FileItem.getFile((HttpServletRequest)request, (Map)params) : FileItem.getFile((String)imgBase64, (String)((String)params.get("POINTID")))).getName())) {
            throw new AppException("\u6587\u4ef6\u7c7b\u578b\u975e\u6cd5!");
        }
        Map extArg = new HashMap();
        if (insertDoc && (extArg = (Map)SerializeFactory.parseJson((String)WebHelper.getParameter((HttpServletRequest)request, (String)"extArgument"), Map.class)) != null && extArg.containsKey("DOCNAME")) {
            file.setName((String)extArg.get("DOCNAME"));
        }
        int chunk = 0;
        int chunks = 1;
        String chk = (String)params.get("chunk");
        if (StringUtils.isNotBlank((String)chk)) {
            chunk = Integer.parseInt(chk);
            chunks = Integer.parseInt((String)params.get("chunks"));
        }
        AttachAddArgument arg = new AttachAddArgument();
        arg.setAppId((String)params.get("appid"));
        arg.setPointId((String)params.get("POINTID"));
        arg.setFileName(file.getName());
        if (StringUtils.isNotBlank((String)file.getTempFilePath())) {
            arg.setTempFilePath(file.getTempFilePath());
            arg.setFileSize(file.getFileSize());
        } else {
            arg.setFileSize(file.getData().length);
            arg.setData(file.getData());
        }
        arg.setPackageCount(chunks);
        arg.setPackageNumber(chunk);
        arg.setSource((String)params.get("src"));
        arg.setRefId((String)params.get("RESID"));
        arg.setRefAId((String)params.get("RESINSID"));
        arg.setDocOrder((String)params.get("DOCORDER"));
        arg.setProperties(params);
        arg.setExtArgument(extArg);
        arg.setInsertDoc(insertDoc);
        arg.setFilePath(filePath);
        return arg;
    }

    private static AttachAddArgument prepareAttachArgumentByServer(boolean insertDoc, Map<String, String> params, String realPath) {
        if (realPath != null) {
            byte[] bytes = null;
            String fileName = null;
            try {
                if (realPath.startsWith("http://") || realPath.startsWith("https://")) {
                    bytes = HttpUtil.getFileByUrl((String)realPath, (int)600000);
                    fileName = realPath.substring(realPath.lastIndexOf("/") + 1);
                    if (fileName.contains("?")) {
                        fileName = fileName.substring(0, fileName.indexOf("?"));
                    }
                    if (StringUtils.isBlank((String)fileName)) {
                        fileName = params.get("POINTID");
                    }
                } else if (FileUtil.checkExist((String)realPath)) {
                    File file = new File(realPath);
                    bytes = FileUtil.readByteArray((InputStream)new FileInputStream(file));
                    fileName = file.getName();
                }
            }
            catch (Exception e) {
                return null;
            }
            if (bytes != null) {
                AttachAddArgument arg = new AttachAddArgument();
                arg.setAppId(params.get("appid"));
                arg.setPointId(params.get("POINTID"));
                arg.setFileName(fileName);
                arg.setFileSize(bytes.length);
                arg.setData(bytes);
                arg.setSource(params.get("src"));
                arg.setDocOrder(params.get("DOCORDER"));
                arg.setRefId(params.get("RESID"));
                arg.setRefAId(params.get("RESINSID"));
                arg.setProperties(params);
                arg.setInsertDoc(insertDoc);
                return arg;
            }
        }
        return null;
    }

    public static FileResolveArgument prepareFileResolverArgument(AttachAddArgument argument) {
        FileResolver fileResolver = FileResolver.getFileResolver(FileItem.getExt((String)argument.getFileName()));
        if (fileResolver == null) {
            return null;
        }
        Object resolveArg = fileResolver.createResolveArgument();
        resolveArg.setAppId(argument.getAppId());
        resolveArg.setId(argument.getPointId());
        resolveArg.setMissionId(argument.getRefAId());
        resolveArg.setFileName(argument.getFileName());
        if (StringUtils.isNotBlank((String)argument.getTempFilePath())) {
            resolveArg.setTempFilePath(argument.getTempFilePath());
        } else {
            resolveArg.setData(argument.getData());
        }
        resolveArg.setFileSize(argument.getFileSize());
        resolveArg.setInsertDoc(argument.isInsertDoc());
        return resolveArg;
    }
}

