/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.util;

import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.utils.RefObject;
import cn.hangar.agp.service.model.sys.SysAppAuthCfg;
import cn.hangar.agp.service.model.sys.SysAppCfg;

public class AppHelper {
    static Logger log = LoggerFactory.getLogger(AppHelper.class);

    public static SysAppAuthCfg getSysAppAuthCfg(String appId) {
        return SysAppAuthCfg.getSysAppAuthCfg((String)appId, (boolean)true);
    }

    public static String getAppSecretMode(String appId) {
        SysAppCfg appcfg = AppHelper.getSysAppCfg(appId);
        StringBuilder secretMode = new StringBuilder();
        appcfg.tryGetParamer("PAM_ENCRYPTTYPE", secretMode);
        return secretMode.toString();
    }

    public static SysAppCfg getSysAppCfg(String appId) {
        return AppHelper.getSysAppCfg(appId, null, true);
    }

    public static SysAppCfg getSysAppCfg(String appId, String themeid, boolean needCache) {
        SysAppCfg appcfg = SysAppCfg.getSysAppCfg((String)appId, (String)themeid, (boolean)needCache);
        return appcfg;
    }

    public static String getParentAppIdWithBrh(String appId) {
        try {
            SysAppCfg app = AppHelper.getSysAppCfg(appId);
            if (app != null && app.getParentAppCfg() != null) {
                return app.getParentAppCfg().getAppIdWithBrh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return appId;
        }
        return appId;
    }

    public static String getParentAppId(String appId) {
        try {
            SysAppCfg app = AppHelper.getSysAppCfg(appId);
            if (app != null && app.getParentAppCfg() != null) {
                return app.getParentAppCfg().getAppId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return appId;
        }
        return appId;
    }

    public static boolean tryGetAppParamer(String appId, String param, StringBuilder builder) {
        SysAppCfg app = AppHelper.getSysAppCfg(appId);
        if (app == null) {
            log.warn("APP\u914d\u7f6e\u4e0d\u5b58\u5728 :" + appId);
            return false;
        }
        if (app.tryGetParamer(param, builder)) {
            return true;
        }
        SysAppAuthCfg cfg = SysAppAuthCfg.getSysAppAuthCfg((String)appId, (boolean)true);
        if (cfg == null) {
            log.warn("APP\u914d\u7f6e\u4e0d\u5b58\u5728\uff1afetchSysAppAuthCfg :" + appId);
            return false;
        }
        RefObject ref = new RefObject();
        boolean flag = cfg.tryGetValue(param, ref);
        return flag;
    }
}

