/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.policy;

import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.app.ServiceInvokeContext;
import cn.hangar.agp.platform.core.config.ConfigManager;
import cn.hangar.agp.platform.core.data.IColumnInfo;
import cn.hangar.agp.platform.core.data.IParamerValueResolver;
import cn.hangar.agp.platform.core.data.IPolicy;
import cn.hangar.agp.platform.core.data.IResDataDict;
import cn.hangar.agp.platform.core.data.MobileDictionary;
import cn.hangar.agp.platform.core.data.PropertyValueHelper;
import cn.hangar.agp.platform.core.db.IDB;
import cn.hangar.agp.platform.express.ExpressHelper;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.RefObject;
import cn.hangar.agp.platform.utils.ReflectUtils;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.policy.IPolicyHandler;
import cn.hangar.agp.service.core.policy.IPolicyHandlerContainer;
import cn.hangar.agp.service.model.datasource.ResDataDict;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public abstract class PolicyHandlerBase
implements IPolicyHandler,
IParamerValueResolver {
    private IPolicy policy;
    private IPolicyHandlerContainer container;
    private ServiceInvokeContext context;
    private Object source;
    private IResDataDict resDict;
    private String resId;
    IDB provider;

    @Override
    public IDB getCmdExecutorProvider() {
        return this.provider;
    }

    @Override
    public void setCmdExecutorProvider(IDB provider) {
        this.provider = provider;
    }

    @Override
    public String getResId() {
        return this.resId;
    }

    @Override
    public void setResId(String resId) {
        this.resId = resId;
        this.resDict = ResDataDict.getResDataDict((String)resId, (boolean)true);
    }

    public IResDataDict getResDict() {
        return this.resDict;
    }

    public void setResDict(IResDataDict resDict) {
        this.resDict = resDict;
    }

    public void dispose() {
    }

    public boolean getNeedRegisterResult() {
        return false;
    }

    @Override
    public Serializable createPolicyArgument() {
        return new MobileDictionary(true);
    }

    @Override
    public abstract Object handle(Object var1) throws Exception;

    @Override
    public boolean isNeedRegisterResult() {
        return false;
    }

    @Override
    public IPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void setPolicy(IPolicy policy) {
        this.policy = policy;
    }

    @Override
    public IPolicyHandlerContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(IPolicyHandlerContainer container) {
        this.container = container;
    }

    @Override
    public ServiceInvokeContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ServiceInvokeContext invokeContext) {
        this.context = invokeContext;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public void setSource(Object source) {
        this.source = source;
    }

    public <T> T getParam(String name, boolean calc) throws Exception {
        String paraString = this.getParam(name);
        if (paraString == null) {
            return null;
        }
        int exptype = ExpressHelper.getExpressType((String)paraString, null);
        if (exptype > 0) {
            if (calc) {
                Object objValue = null;
                RefObject tempRef_objValue = new RefObject(objValue);
                boolean tempVar = !ExpressHelper.calculateExpress((String)paraString, (RefObject)tempRef_objValue, (Object[])new Object[]{this.getSource(), this.getContainer()});
                objValue = tempRef_objValue.argValue;
                if (tempVar) {
                    throw new AppException(paraString);
                }
                return (T)objValue;
            }
            String objValue = null;
            RefObject tempRef_objValue2 = new RefObject(objValue);
            boolean tempVar2 = ExpressHelper.replace((String)paraString, (RefObject)tempRef_objValue2, (Object[])new Object[]{this.getSource(), this.getContainer()});
            objValue = (String)tempRef_objValue2.argValue;
            if (tempVar2) {
                return (T)objValue;
            }
            return (T)paraString;
        }
        return (T)paraString;
    }

    protected String getParam(String name) {
        if (this.getPolicy() == null || this.getPolicy().getArgument() == null || this.getPolicy().getArgument().size() == 0) {
            return null;
        }
        List arguments = this.getPolicy().getArgument();
        for (IColumnInfo argument : arguments) {
            if (!argument.getColumnName().equalsIgnoreCase(name)) continue;
            return argument.getColumnExpress();
        }
        return null;
    }

    public boolean resolveParamerValue(String paramerName, String[] paramerNameRange, RefObject value) {
        value.argValue = null;
        if ((paramerNameRange == null || paramerNameRange.length == 0) && this.source != null && paramerName != null) {
            try {
                if (PropertyValueHelper.getPropertyObject((Object)this.source, (String)paramerName.toUpperCase(), (boolean)true, (RefObject)value)) {
                    return true;
                }
                switch (paramerName) {
                    case "PAM_SelectedResIDS": 
                    case "PAM_SELECTEDRESIDS": {
                        value.argValue = this.getResId();
                        return true;
                    }
                    case "PAM_SelectedIDS": 
                    case "PAM_SELECTEDIDS": {
                        if (this.getResDict() == null || StringUtils.isBlank((String)this.getResDict().getKeyColumnName()) || !PropertyValueHelper.getPropertyObject((Object)this.source, (String)this.resDict.getKeyColumnName(), (boolean)true, (RefObject)value)) break;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected String getSql(String sqlId) {
        String pkName = ConfigManager.getPropertyValue((String)"pkName", (String)"cn.app");
        String clazzName = pkName + ".cons.BussCons";
        Map map = (Map)ReflectUtils.getFieldValue((String)clazzName, (String)"SYSSQLS", Map.class);
        return Convert.toString(map.get(sqlId));
    }
}

