/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.logic;

import cn.hangar.agp.platform.core.serialize.SerializeFactory;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.Endecrypt;
import cn.hangar.agp.platform.utils.GeneralUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.util.EncryptHelper;
import cn.hangar.agp.service.core.util.encrypt.EncryptType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public interface LogicStringBase {
    default public String base64(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return Endecrypt.toBase64((byte[])((byte[])value));
        }
        return EncryptHelper.encrypt(EncryptType.Base64, value.toString(), null);
    }

    default public String md5(Object value) {
        return value == null ? null : EncryptHelper.encrypt(EncryptType.MD5, value.toString(), null);
    }

    default public Integer charIndex(Object search, Object wholeStr) {
        if (search == null || wholeStr == null) {
            return 0;
        }
        return wholeStr.toString().indexOf(search.toString()) + 1;
    }

    default public boolean contains(String str, String t) {
        return str != null && t != null && str.contains(t);
    }

    default public Integer indexOf(Object str, String t) {
        return str == null ? -1 : this.indexOf(str.toString(), t);
    }

    default public Integer indexOf(String str, String t) {
        if (StringUtils.isBlank((String)str) || StringUtils.isBlank((String)t)) {
            return -1;
        }
        return str.indexOf(t);
    }

    default public String insert(String str, Integer id, String v) {
        return StringUtils.insert((String)str, (int)id, (String)v);
    }

    default public boolean isChinese(String str) {
        return StringUtils.isChinese((String)str);
    }

    default public Integer isContain(String subIds, String ids) {
        if (StringUtils.isNotBlank((String)subIds) && StringUtils.isNotBlank((String)ids)) {
            List<String> idsSplit = Arrays.asList(ids.split(","));
            String[] subIdsSplit = subIds.split(",");
            int count = 0;
            for (int i = 0; i < subIdsSplit.length; ++i) {
                String s = subIdsSplit[i];
                if (idsSplit.contains(s)) {
                    ++count;
                    continue;
                }
                if (count > 0) break;
            }
            if (count > 0) {
                return count < subIdsSplit.length ? 2 : 1;
            }
        }
        return 0;
    }

    default public boolean isEmpty(Object str) {
        return str == null || StringUtils.isEmpty((String)str.toString());
    }

    default public String join(List lst) {
        return this.join(lst, ",");
    }

    default public String join(List lst, String splitter) {
        if (lst == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object val : lst) {
            if (val == null) continue;
            if (sb.length() > 0) {
                sb.append(splitter);
            }
            sb.append(val);
        }
        return sb.toString();
    }

    default public Integer lastIndexOf(Object str, String t) {
        return str == null ? -1 : this.lastIndexOf(str.toString(), t);
    }

    default public Integer lastIndexOf(String str, String t) {
        if (StringUtils.isBlank((String)str) || StringUtils.isBlank((String)t)) {
            return -1;
        }
        return str.lastIndexOf(t);
    }

    default public String left(String v, Integer length) {
        if (v == null || length == null) {
            return null;
        }
        if (length > v.length()) {
            return v;
        }
        return v.substring(0, length);
    }

    default public Integer len(Object value) {
        if (value instanceof Map) {
            return ((Map)value).size();
        }
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length;
        }
        return value == null ? 0 : value.toString().length();
    }

    default public String lower(Object x) {
        return x == null ? null : x.toString().toLowerCase();
    }

    default public String replace(Object str, String target, String replacement) {
        return str == null ? null : this.replace(str.toString(), target, replacement);
    }

    default public String replace(String str, String target, String replacement) {
        if (StringUtils.isNotBlank((String)str) && StringUtils.isNotBlank((String)target)) {
            return str.replace(target, replacement == null ? "" : replacement);
        }
        return str;
    }

    default public String reverse(String str) {
        return StringUtils.reverse((String)str);
    }

    default public String reverseIds(Object o) {
        if (o == null) {
            return null;
        }
        List ids = StringUtils.splitRemoveEmpty((String)o.toString(), (String)",");
        if (ids != null && !ids.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = ids.size() - 1; i >= 0; --i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append((String)ids.get(i));
            }
            return sb.toString();
        }
        return null;
    }

    default public String right(String v, Integer length) {
        if (v == null || length == null) {
            return null;
        }
        if (length > v.length()) {
            return v;
        }
        return v.substring(v.length() - length);
    }

    default public List<String> split(String str) {
        return this.split(str, ",");
    }

    default public List<String> split(String str, String split) {
        if (str == null) {
            return new ArrayList<String>(0);
        }
        return StringUtils.spiltToList((String)str, (String)split);
    }

    default public Number split(Number value) {
        return value;
    }

    default public List<Integer> splitOrder(String str) {
        return this.splitOrder(str, ",");
    }

    default public List<Integer> splitOrder(String str, String split) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (str != null) {
            int count = 0;
            int idx = 0;
            do {
                result.add(++count);
            } while ((idx = str.indexOf(split, idx + 1)) > -1);
        }
        return result;
    }

    default public Integer strMatch(Object str, String regex) {
        return str != null && Pattern.compile(regex).matcher(str.toString()).find() ? 1 : 0;
    }

    default public String sub(String str, Integer from, Integer end) {
        return StringUtils.sub((CharSequence)str, (int)from, (int)end);
    }

    default public String trim(Object value, String t) {
        return value == null ? null : StringUtils.trim((String)value.toString(), (String)t);
    }

    default public String trimStart(Object value, String t) {
        return value == null ? null : StringUtils.trimStart((String)value.toString(), (String)t);
    }

    default public String trimEnd(Object value, String t) {
        return value == null ? null : StringUtils.trimEnd((String)value.toString(), (String)t);
    }

    default public String toChar(Object value) {
        return Convert.toString((Object)value);
    }

    default public String toJson(Object value) {
        return value == null ? null : SerializeFactory.toJson((Object)value);
    }

    default public String fromChar(Integer charCode) {
        return Character.toString((char)charCode.intValue());
    }

    default public String newId() {
        return GeneralUtil.UUID();
    }

    default public String upper(Object x) {
        return x == null ? null : x.toString().toUpperCase();
    }
}

