/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.logic;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.IUser;
import cn.hangar.agp.platform.core.data.MobileDictionary;
import cn.hangar.agp.platform.core.rest.WebHelper;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.RefObject;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.model.logicservice.LogicUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.servlet.http.HttpServletRequest;

public interface LogicObjectBase {
    default public Integer isNull(Object value) {
        return value == null ? 1 : 0;
    }

    default public Object isNull(Object value, Object defValue) {
        return value == null ? defValue : value;
    }

    default public Number isNull(Number value, Number defValue) {
        return value == null ? (Number)defValue : (Number)value;
    }

    default public Object ifNull(Object value, Object defValue) {
        return this.isNull(value, defValue);
    }

    default public Object setWhenEmpty(Object value, Object defValue) {
        return this.isNull(value, defValue);
    }

    default public Object isEmpty(Object value, Object defValue) {
        return value == null || StringUtils.isBlank((String)value.toString()) ? defValue : value;
    }

    default public Object ifEmpty(Object value, Object defValue) {
        return this.isEmpty(value, defValue);
    }

    default public boolean in(Object val, List list) {
        if (val != null && list != null) {
            for (Object o : list) {
                if (!this.equalTo(val, o)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean in(Object val, Object ... datas) {
        if (val != null && datas != null) {
            for (Object data : datas) {
                if (!(data instanceof List ? this.in(val, (List)data) : this.equalTo(data, val))) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean equalTo(Object o1, Object o2) {
        return LogicUtil.equalTo((Object)o1, (Object)o2);
    }

    default public boolean greaterThan(Object o1, Object o2) {
        return LogicUtil.greaterThan((Object)o1, (Object)o2);
    }

    default public boolean lowerThan(Object o1, Object o2) {
        return LogicUtil.lowerThan((Object)o1, (Object)o2);
    }

    default public boolean greaterThanOrEqualTo(Object o1, Object o2) {
        return this.greaterThan(o1, o2) || this.equalTo(o1, o2);
    }

    default public boolean lowerThanOrEqualTo(Object o1, Object o2) {
        return this.lowerThan(o1, o2) || this.equalTo(o1, o2);
    }

    default public boolean equalTo(int o1, int o2) {
        return this.equalTo((Object)o1, (Object)o2);
    }

    default public boolean equalTo(int o1, Object o2) {
        return this.equalTo((Object)o1, o2);
    }

    default public boolean equalTo(Object o1, int o2) {
        return this.equalTo(o1, (Object)o2);
    }

    default public boolean equalTo(double o1, double o2) {
        return this.equalTo((Object)o1, (Object)o2);
    }

    default public boolean equalTo(double o1, Object o2) {
        return this.equalTo((Object)o1, o2);
    }

    default public boolean equalTo(Object o1, double o2) {
        return this.equalTo(o1, (Object)o2);
    }

    default public boolean equalTo(boolean o1, boolean o2) {
        return o1 != o2;
    }

    default public boolean equalTo(Object o1, boolean o2) {
        return Convert.toBoolean((Object)o1) == o2;
    }

    default public boolean equalTo(boolean o1, Object o2) {
        return o1 == Convert.toBoolean((Object)o2);
    }

    default public boolean lowerThan(int o1, int o2) {
        return this.lowerThan((Object)o1, (Object)o2);
    }

    default public boolean lowerThan(int o1, Object o2) {
        return this.lowerThan((Object)o1, o2);
    }

    default public boolean lowerThan(Object o1, int o2) {
        return this.lowerThan(o1, (Object)o2);
    }

    default public boolean lowerThan(double o1, double o2) {
        return this.lowerThan((Object)o1, (Object)o2);
    }

    default public boolean lowerThan(double o1, Object o2) {
        return this.lowerThan((Object)o1, o2);
    }

    default public boolean lowerThan(Object o1, double o2) {
        return this.lowerThan(o1, (Object)o2);
    }

    default public boolean greaterThan(int o1, int o2) {
        return this.greaterThan((Object)o1, (Object)o2);
    }

    default public boolean greaterThan(int o1, Object o2) {
        return this.greaterThan((Object)o1, o2);
    }

    default public boolean greaterThan(Object o1, int o2) {
        return this.greaterThan(o1, (Object)o2);
    }

    default public boolean greaterThan(double o1, double o2) {
        return this.greaterThan((Object)o1, (Object)o2);
    }

    default public boolean greaterThan(double o1, Object o2) {
        return this.greaterThan((Object)o1, o2);
    }

    default public boolean greaterThan(Object o1, double o2) {
        return this.greaterThan(o1, (Object)o2);
    }

    default public Object box(Object o) {
        return o;
    }

    default public Integer box(int o) {
        return o;
    }

    default public Double box(double o) {
        return o;
    }

    default public Long box(long o) {
        return o;
    }

    default public Boolean box(boolean o) {
        return o;
    }

    default public Byte box(byte o) {
        return o;
    }

    default public void clear(Object map) {
        if (map instanceof Map) {
            ((Map)map).clear();
        } else if (map instanceof List) {
            ((List)map).clear();
        }
    }

    default public String getSessionId() {
        HttpServletRequest request = WebHelper.getCurrentRequest();
        if (request != null) {
            return request.getSession().getId();
        }
        return null;
    }

    default public String getUserProperty(String prop) {
        IUser user = AppContext.getCurrentUser();
        if (user != null && user.isAuthenticated()) {
            if (prop.equalsIgnoreCase("SID")) {
                return user.getSessionId();
            }
            MobileDictionary dic = user.getExtArgument();
            RefObject result = new RefObject();
            if (dic != null && dic.tryGetValue(prop, result)) {
                return (String)result.getArgValue();
            }
        }
        return null;
    }

    default public Integer isExist(Object value) {
        return value != null ? 1 : 0;
    }

    default public Integer isNotExist(Object value) {
        return value == null ? 1 : 0;
    }

    default public <T extends Map, V> List<T> setArrayField(List<T> list, String prop, Object[] values, Class<T> itemClass, Class<V> propClass) {
        return this.setArrayField(list, prop, Arrays.asList(values), itemClass, propClass);
    }

    default public <T extends Map, V> List<T> setArrayField(List<T> list, String prop, List<Object> values, Class<T> itemClass, Class<V> propClass) {
        if (list != null && values != null && values.size() > 0) {
            try {
                for (int i = 0; i < values.size(); ++i) {
                    Map item;
                    Object value = values.get(i);
                    if (list.size() > i) {
                        item = (Map)list.get(i);
                    } else {
                        item = (Map)itemClass.newInstance();
                        LogicUtil.markNew((Object)item);
                        list.add(item);
                    }
                    item.put(prop, LogicUtil.parseDim((Object)value, propClass));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    default public <T extends Map, V> List<T> setArrayField(List<T> list, String prop, Object value, Class<T> itemClass, Class<V> propClass) {
        if (list != null) {
            for (Map item : list) {
                item.put(prop, LogicUtil.parseDim((Object)value, propClass));
            }
        }
        return list;
    }

    default public Object hjTopValue(List<Map> list, String prop) {
        return this.hjTopValue(list, prop, null);
    }

    default public Object hjTopValue(List<Map> list, String prop, String orderBy) {
        if (list != null && list.size() > 0) {
            Map first;
            if (StringUtils.isNotBlank((String)orderBy)) {
                ArrayList<Map> tempList = new ArrayList<Map>(list);
                LogicUtil.sortArray(tempList, (String)orderBy);
                first = (Map)tempList.get(0);
            } else {
                first = list.get(0);
            }
            return first.get(prop);
        }
        return null;
    }

    default public Integer hjCount(List list) {
        return list == null ? 0 : list.size();
    }

    default public Integer hjCount(List<Map> list, String prop) {
        ArrayList<String> values = new ArrayList<String>();
        if (list != null) {
            for (Map map : list) {
                String value = Convert.toString(map.get(prop));
                if (values.contains(value)) continue;
                values.add(value);
            }
        }
        return values.size();
    }

    default public Integer count(List list) {
        return list == null ? 0 : list.size();
    }

    default public String hjJoint(List<Map> list, String prop) {
        if (list != null && list.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map map : list) {
                Object value = map.get(prop);
                if (value == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(value);
            }
            return sb.toString();
        }
        return null;
    }

    default public <T> T min(List<T> list) {
        return (T)this.compareObject(list, this::lowerThan);
    }

    default public <T> T min(List<Map<String, T>> list, String prop) {
        return (T)this.compareObject(list, prop, this::lowerThan);
    }

    default public <T> T max(List<T> list) {
        return (T)this.compareObject(list, this::greaterThan);
    }

    default public <T> T max(List<Map<String, T>> list, String prop) {
        return (T)this.compareObject(list, prop, this::greaterThan);
    }

    default public <T> T compareObject(List<T> list, BiPredicate<T, T> compareTo) {
        if (list != null && list.size() > 0) {
            T result = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                T item = list.get(i);
                if (!compareTo.test(item, result)) continue;
                result = item;
            }
            return result;
        }
        return null;
    }

    default public <T> T compareObject(List<Map<String, T>> list, String prop, BiPredicate<T, T> compareTo) {
        if (list != null && list.size() > 0) {
            T result = list.get(0).get(prop);
            for (int i = 1; i < list.size(); ++i) {
                T item = list.get(i).get(prop);
                if (!compareTo.test(item, result)) continue;
                result = item;
            }
            return result;
        }
        return null;
    }
}

