/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.logic;

import cn.hangar.agp.platform.utils.Arith;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface LogicMathBase {
    default public Double variance(Object arg) {
        if (arg instanceof List) {
            return this.variance((List)arg);
        }
        return this.variance(Collections.singletonList(arg));
    }

    default public Double variance(Object ... args) {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (Object arg : args) {
            if (arg instanceof List) {
                vals.addAll((List)arg);
                continue;
            }
            vals.add(arg);
        }
        return this.variance(vals);
    }

    default public Double variance(List<Map> list, String prop) {
        ArrayList vals = new ArrayList();
        if (list != null) {
            for (Map map : list) {
                vals.add(map.get(prop));
            }
        }
        return this.variance(vals);
    }

    default public Double variance(List vals) {
        if (vals == null || vals.isEmpty()) {
            return 0.0;
        }
        int len = vals.size();
        double sum = 0.0;
        for (Object val : vals) {
            sum += Convert.todouble(val);
        }
        double avg = sum / (double)len;
        double var = 0.0;
        for (Object val : vals) {
            var += Math.pow(Convert.todouble(val) - avg, 2.0);
        }
        return var / (double)len;
    }

    default public Double sum(Object arg) {
        if (arg instanceof List) {
            return this.sum((List)arg);
        }
        return this.sum(Collections.singletonList(arg));
    }

    default public Double sum(Object ... args) {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (Object arg : args) {
            if (arg instanceof List) {
                vals.addAll((List)arg);
                continue;
            }
            vals.add(arg);
        }
        return this.sum(vals);
    }

    default public Double sum(List<Map> list, String prop) {
        ArrayList vals = new ArrayList();
        if (list != null) {
            for (Map map : list) {
                vals.add(map.get(prop));
            }
        }
        return this.sum(vals);
    }

    default public Double sum(List vals) {
        double sum = 0.0;
        if (vals != null) {
            for (Object val : vals) {
                sum += Convert.todouble(val);
            }
        }
        return sum;
    }

    default public Double avg(Object arg) {
        if (arg instanceof List) {
            return this.avg((List)arg);
        }
        return this.avg(Collections.singletonList(arg));
    }

    default public Double avg(Object ... args) {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (Object arg : args) {
            if (arg instanceof List) {
                vals.addAll((List)arg);
                continue;
            }
            vals.add(arg);
        }
        return this.avg(vals);
    }

    default public Double avg(List<Map> list, String prop) {
        ArrayList vals = new ArrayList();
        if (list != null) {
            for (Map map : list) {
                vals.add(map.get(prop));
            }
        }
        return this.avg(vals);
    }

    default public Double avg(List vals) {
        double avg = 0.0;
        if (vals != null && vals.size() > 0) {
            double sum = 0.0;
            for (Object val : vals) {
                sum += Convert.todouble(val);
            }
            avg = sum / (double)vals.size();
        }
        return avg;
    }

    default public Integer add(Integer a, Integer b) {
        return (a == null ? 0 : a) + (b == null ? 0 : b);
    }

    default public Double add(Integer a, Double b) {
        return (double)(a == null ? 0 : a) + (b == null ? 0.0 : b);
    }

    default public Long add(Integer a, Long b) {
        return (long)(a == null ? 0 : a) + (b == null ? 0L : b);
    }

    default public Long add(Long a, Long b) {
        return (a == null ? 0L : a) + (b == null ? 0L : b);
    }

    default public Double add(Long a, Double b) {
        return (double)(a == null ? 0L : a) + (b == null ? 0.0 : b);
    }

    default public Long add(Long a, Integer b) {
        return (a == null ? 0L : a) + (long)(b == null ? 0 : b);
    }

    default public Double add(Double a, Double b) {
        return (a == null ? 0.0 : a) + (b == null ? 0.0 : b);
    }

    default public Double add(Double a, Integer b) {
        return (a == null ? 0.0 : a) + (double)(b == null ? 0 : b);
    }

    default public Double add(Double a, Long b) {
        return (a == null ? 0.0 : a) + (double)(b == null ? 0L : b);
    }

    default public Double add(Number a, Number b) {
        return (a == null ? 0.0 : a.doubleValue()) + (b == null ? 0.0 : b.doubleValue());
    }

    default public Object add(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return this.add((Number)a, (Number)b);
        }
        return Convert.toString((Object)a) + Convert.toString((Object)b);
    }

    default public Integer subtract(Integer a, Integer b) {
        return (a == null ? 0 : a) - (b == null ? 0 : b);
    }

    default public Double subtract(Integer a, Double b) {
        return (double)(a == null ? 0 : a) - (b == null ? 0.0 : b);
    }

    default public Long subtract(Integer a, Long b) {
        return (long)(a == null ? 0 : a) - (b == null ? 0L : b);
    }

    default public Long subtract(Long a, Long b) {
        return (a == null ? 0L : a) - (b == null ? 0L : b);
    }

    default public Double subtract(Long a, Double b) {
        return (double)(a == null ? 0L : a) - (b == null ? 0.0 : b);
    }

    default public Long subtract(Long a, Integer b) {
        return (a == null ? 0L : a) - (long)(b == null ? 0 : b);
    }

    default public Double subtract(Double a, Double b) {
        return (a == null ? 0.0 : a) - (b == null ? 0.0 : b);
    }

    default public Double subtract(Double a, Integer b) {
        return (a == null ? 0.0 : a) - (double)(b == null ? 0 : b);
    }

    default public Double subtract(Double a, Long b) {
        return (a == null ? 0.0 : a) - (double)(b == null ? 0L : b);
    }

    default public Integer multiply(Integer a, Integer b) {
        return (a == null ? 0 : a) * (b == null ? 0 : b);
    }

    default public Double multiply(Integer a, Double b) {
        return (double)(a == null ? 0 : a) * (b == null ? 0.0 : b);
    }

    default public Long multiply(Integer a, Long b) {
        return (long)(a == null ? 0 : a) * (b == null ? 0L : b);
    }

    default public Double multiply(Double a, Double b) {
        return (a == null ? 0.0 : a) * (b == null ? 0.0 : b);
    }

    default public Double multiply(Double a, Integer b) {
        return (a == null ? 0.0 : a) * (double)(b == null ? 0 : b);
    }

    default public Double multiply(Double a, Long b) {
        return (a == null ? 0.0 : a) * (double)(b == null ? 0L : b);
    }

    default public Long multiply(Long a, Long b) {
        return (a == null ? 0L : a) * (b == null ? 0L : b);
    }

    default public Double multiply(Long a, Double b) {
        return (double)(a == null ? 0L : a) * (b == null ? 0.0 : b);
    }

    default public Long multiply(Long a, Integer b) {
        return (a == null ? 0L : a) * (long)(b == null ? 0 : b);
    }

    default public Double divide(Integer a, Integer b) {
        return (a == null ? 0.0 : a.doubleValue()) / (b == null ? 0.0 : b.doubleValue());
    }

    default public Double divide(Integer a, Double b) {
        return (a == null ? 0.0 : a.doubleValue()) / (b == null ? 0.0 : b);
    }

    default public Double divide(Integer a, Long b) {
        return (a == null ? 0.0 : a.doubleValue()) / (b == null ? 0.0 : b.doubleValue());
    }

    default public Double divide(Double a, Double b) {
        return (a == null ? 0.0 : a) / (b == null ? 0.0 : b);
    }

    default public Double divide(Double a, Long b) {
        return (a == null ? 0.0 : a) / (b == null ? 0.0 : b.doubleValue());
    }

    default public Double divide(Double a, Integer b) {
        return (a == null ? 0.0 : a) / (b == null ? 0.0 : b.doubleValue());
    }

    default public Double divide(Long a, Long b) {
        return (a == null ? 0.0 : a.doubleValue()) / (b == null ? 0.0 : b.doubleValue());
    }

    default public Double divide(Long a, Double b) {
        return (a == null ? 0.0 : a.doubleValue()) / (b == null ? 0.0 : b);
    }

    default public Double divide(Long a, Integer b) {
        return (a == null ? 0.0 : a.doubleValue()) / (b == null ? 0.0 : b.doubleValue());
    }

    default public Integer modulo(Integer a, Integer b) {
        return (a == null ? 0 : a) % (b == null ? 0 : b);
    }

    default public Double modulo(Integer a, Double b) {
        return (double)(a == null ? 0 : a) % (b == null ? 0.0 : b);
    }

    default public Long modulo(Integer a, Long b) {
        return (long)(a == null ? 0 : a) % (b == null ? 0L : b);
    }

    default public Double modulo(Double a, Double b) {
        return (a == null ? 0.0 : a) % (b == null ? 0.0 : b);
    }

    default public Double modulo(Double a, Integer b) {
        return (a == null ? 0.0 : a) % (double)(b == null ? 0 : b);
    }

    default public Double modulo(Double a, Long b) {
        return (a == null ? 0.0 : a) % (double)(b == null ? 0L : b);
    }

    default public Long modulo(Long a, Long b) {
        return (a == null ? 0L : a) % (b == null ? 0L : b);
    }

    default public Double modulo(Long a, Double b) {
        return (double)(a == null ? 0L : a) % (b == null ? 0.0 : b);
    }

    default public Long modulo(Long a, Integer b) {
        return (a == null ? 0L : a) % (long)(b == null ? 0 : b);
    }

    default public Integer abs(Integer value) {
        return Math.abs(value);
    }

    default public Double abs(Double value) {
        return Math.abs(value);
    }

    default public Long abs(Long value) {
        return Math.abs(value);
    }

    default public Double asin(Number value) {
        return Math.asin(value.doubleValue());
    }

    default public Double acos(Number value) {
        return Math.acos(value.doubleValue());
    }

    default public Double atan(Number value) {
        return Math.atan(value.doubleValue());
    }

    default public Double atan2(Number y, Number x) {
        return Math.atan2(y.doubleValue(), x.doubleValue());
    }

    default public Integer ceil(Number value) {
        return (int)Math.ceil(value.doubleValue());
    }

    default public Double cos(Number value) {
        return Math.cos(value.doubleValue());
    }

    default public Double exp(Number value) {
        return Math.exp(value.doubleValue());
    }

    default public Integer floor(Number value) {
        return (int)Math.floor(value.doubleValue());
    }

    default public Integer isNumber(Object str) {
        if (str instanceof Number) {
            return 1;
        }
        return StringUtils.isNumber((Object)str);
    }

    default public boolean isPrime(Number value) {
        return Arith.isPrime((int)value.intValue());
    }

    default public Double log(Number value) {
        return Math.log(value.doubleValue());
    }

    default public Integer max(Integer a, Integer b) {
        return Math.max(a, b);
    }

    default public Long max(Long a, Long b) {
        return Math.max(a, b);
    }

    default public Double max(Number a, Number b) {
        return Math.max(a.doubleValue(), b.doubleValue());
    }

    default public Object max(Object a, Object b) {
        int result = 0;
        if (a instanceof Comparable) {
            result = ((Comparable)a).compareTo(b);
        } else if (b instanceof Comparable) {
            result = -((Comparable)b).compareTo(a);
        }
        return result >= 0 ? a : b;
    }

    default public Integer min(Integer a, Integer b) {
        return Math.min(a, b);
    }

    default public Long min(Long a, Long b) {
        return Math.min(a, b);
    }

    default public Double min(Number a, Number b) {
        return Math.min(a.doubleValue(), b.doubleValue());
    }

    default public Object min(Object a, Object b) {
        int result = 0;
        if (a instanceof Comparable) {
            result = ((Comparable)a).compareTo(b);
        } else if (b instanceof Comparable) {
            result = -((Comparable)b).compareTo(a);
        }
        return result <= 0 ? a : b;
    }

    default public Double pi() {
        return Math.PI;
    }

    default public Double pow(Number a, Number b) {
        return Math.pow(a.doubleValue(), b.doubleValue());
    }

    default public Integer random(Integer a, Integer b) {
        return this.floor(Math.random() * (double)(b - a + 1) + (double)a.intValue());
    }

    default public Integer round(Number value) {
        return (int)Math.round(value.doubleValue());
    }

    default public Double round(Number value, Integer range) {
        return Convert.round((Double)value.doubleValue(), (int)range);
    }

    default public Double sin(Number value) {
        return Math.sin(value.doubleValue());
    }

    default public Double sqrt(Number value) {
        return Math.sqrt(value.doubleValue());
    }

    default public Double tan(Number value) {
        return Math.tan(value.doubleValue());
    }

    default public Double toFloat(Object value) {
        return Convert.todouble((Object)value);
    }

    default public Integer toInt(Object value) {
        return Convert.toInt((Object)value);
    }
}

