/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.logic;

import java.util.Optional;

public interface LogicGeometryBase {
    public static final double EARTH_RADIUS = 6378137.0;

    default public Double toRadians(Double angle) {
        return Optional.ofNullable(angle).orElse(0.0) / 180.0 * Math.PI;
    }

    default public Double toAngle(Double radians) {
        return Optional.ofNullable(radians).orElse(0.0) / Math.PI * 180.0;
    }

    default public Double toX(String longitude) {
        return this.toX(Double.parseDouble(longitude));
    }

    default public Double toX(Double longitude) {
        return this.toRadians(longitude) * 6378137.0;
    }

    default public Double toY(String latitude) {
        return this.toY(Double.parseDouble(latitude));
    }

    default public Double toY(Double latitude) {
        double temp = Math.log(Math.tan(this.toRadians(45.0 + latitude / 2.0)));
        return temp * 6378137.0;
    }

    default public Double getAngle(Double x0, Double y0, Double x1, Double y1) {
        if (x0 == null) {
            x0 = 0.0;
        }
        if (y0 == null) {
            y0 = 0.0;
        }
        if (x1 == null) {
            x1 = 0.0;
        }
        if (y1 == null) {
            y1 = 0.0;
        }
        if (x0.equals(x1) && y0.equals(y1)) {
            return 0.0;
        }
        double temp = this.toAngle(Math.atan2(y1 - y0, x1 - x0));
        if (temp < 0.0) {
            temp += 360.0;
        }
        return temp;
    }

    default public Double getDistance(Double x0, Double y0, Double x1, Double y1) {
        return 6378137.0 * Math.acos(Math.cos(this.toRadians(x0) - this.toRadians(x1)) * Math.cos(this.toRadians(y0)) * Math.cos(this.toRadians(y1)) + Math.sin(this.toRadians(y0)) * Math.sin(this.toRadians(y1)));
    }
}

