/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core.logic;

import cn.hangar.agp.platform.utils.DateUtil;
import cn.hangar.agp.service.core.ICalendarServiceCore;
import java.util.Date;

public interface LogicDateBase {
    default public Date addDay(Object date, Integer value) {
        return DateUtil.addDay((Date)this.toDate(date), (Integer)value);
    }

    default public Date addHour(Object date, Integer i) {
        return DateUtil.addHours((Date)this.toDate(date), (Integer)i);
    }

    default public Date addMinute(Object date, Integer i) {
        return DateUtil.addMinutes((Date)this.toDate(date), (Integer)i);
    }

    default public Date addMonth(Object date, int i) {
        return DateUtil.addMonth((Date)this.toDate(date), (Integer)i);
    }

    default public Date addSecond(Object date, Integer i) {
        return DateUtil.addSeconds((Date)this.toDate(date), (Integer)i);
    }

    default public Date addYear(Object date, Integer i) {
        return DateUtil.addYear((Date)this.toDate(date), (Integer)i);
    }

    default public Date createDate(Integer year, Integer month, Integer date) {
        return DateUtil.createDate((int)year, (int)month, (int)date);
    }

    default public Date createDate(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second) {
        return DateUtil.createDate((int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second);
    }

    default public Long date(Object date) {
        return this.toDate(date).getTime();
    }

    default public Long date() {
        return this.date(this.now());
    }

    default public Integer day(Object date) {
        return DateUtil.getDayOfMonth((Date)this.toDate(date));
    }

    default public Integer day() {
        return this.day(this.now());
    }

    default public Integer diffMonth(Object a, Object b) {
        return this.month(b) - this.month(a) + (this.year(b) - this.year(a)) * 12;
    }

    default public Integer diffDay(Object a, Object b) {
        return (int)((this.toDate(b).getTime() - this.toDate(a).getTime()) / 86400000L);
    }

    default public Integer diffHour(Object a, Object b) {
        return (int)((this.toDate(b).getTime() - this.toDate(a).getTime()) / 3600000L);
    }

    default public Integer diffMinute(Object a, Object b) {
        return (int)((this.toDate(b).getTime() - this.toDate(a).getTime()) / 60000L);
    }

    default public Integer diffSecond(Object a, Object b) {
        return (int)((this.toDate(b).getTime() - this.toDate(a).getTime()) / 1000L);
    }

    default public Integer getSeconds() {
        return (int)System.currentTimeMillis() / 1000;
    }

    default public Integer hour(Object date) {
        return DateUtil.getHourOfDay((Date)this.toDate(date));
    }

    default public Integer hour() {
        return this.hour(this.now());
    }

    default public Integer minute() {
        return this.minute(this.now());
    }

    default public Integer minute(Object date) {
        return DateUtil.getMinute((Date)this.toDate(date));
    }

    default public Integer month(Object date) {
        return DateUtil.getMonth((Date)this.toDate(date)) + 1;
    }

    default public Integer month() {
        return this.month(this.now());
    }

    default public Integer quatumn(Object date) {
        return (int)Math.ceil((double)this.month(date).intValue() / 3.0);
    }

    default public Integer quatumn() {
        return this.quatumn(this.now());
    }

    default public Integer second(Object date) {
        return DateUtil.getSecond((Date)this.toDate(date));
    }

    default public Integer second() {
        return this.second(this.now());
    }

    default public Date toDate(Object date) {
        if (date == null) {
            return this.now();
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        return DateUtil.toDate((String)date.toString());
    }

    default public Date toDate(String str, String format) {
        return DateUtil.toDate((String)str, (String)format);
    }

    default public Integer week(Object date) {
        int day = DateUtil.getDayOfWeek((Date)this.toDate(date));
        if (DateUtil.isSundayFirst() && --day < 1) {
            day = 1;
        }
        return day;
    }

    default public Integer week() {
        return this.week(this.now());
    }

    default public Integer weekOfYear(Object date) {
        return DateUtil.getWeekOfMonth((Date)this.toDate(date));
    }

    default public Integer year(Object date) {
        return DateUtil.getYear((Date)this.toDate(date));
    }

    default public Integer year() {
        return this.year(this.now());
    }

    default public Date now() {
        return new Date();
    }

    default public String yearMonth(Object date, Integer inc) {
        Date dt = this.addMonth(date, inc);
        String year = this.year(dt).toString();
        String month = this.month(dt).toString();
        if (month.length() == 1) {
            month = "0" + month;
        }
        return year + month;
    }

    default public String yearMonth(Object date) {
        return this.yearMonth(date, 0);
    }

    default public String yearQuatumn(Object date, Integer inc) {
        Date dt = this.addMonth(date, inc * 3);
        String year = this.year(dt).toString();
        String quatumn = this.quatumn(dt).toString();
        return year + quatumn;
    }

    default public String yearQuatumn(Object date) {
        return this.yearQuatumn(date, 0);
    }

    default public String yearWeek(Object date, Integer inc) {
        Date dt = this.addDay(date, inc * 7);
        String year = this.year(dt).toString();
        String week = this.weekOfYear(dt).toString();
        return year + week;
    }

    default public String yearWeek(Object date) {
        return this.yearWeek(date, 0);
    }

    default public String dateHour(Object date, Integer inc) {
        String hour;
        String day;
        Date dt = this.addHour(date, inc);
        String year = this.year(dt).toString();
        String month = this.month(dt).toString();
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((day = this.day(dt).toString()).length() == 1) {
            day = "0" + day;
        }
        if ((hour = this.hour(dt).toString()).length() == 1) {
            hour = "0" + hour;
        }
        return year + month + day + hour;
    }

    public ICalendarServiceCore getCalendarService();

    default public Integer isWorkTime(Date time) {
        int dayOfWeek;
        Date currentDate = DateUtil.createDate((int)this.year(time), (int)this.month(time), (int)this.day(time));
        ICalendarServiceCore calendarServiceCore = this.getCalendarService();
        if (calendarServiceCore != null) {
            try {
                Date endDate = calendarServiceCore.addDurationToTime(currentDate, 0);
                endDate = DateUtil.createDate((int)this.year(endDate), (int)this.month(endDate), (int)this.day(endDate));
                if (this.year(currentDate).equals(this.year(endDate)) && this.month(currentDate).equals(this.month(endDate)) && this.day(currentDate).equals(this.day(endDate))) {
                    return 1;
                }
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (dayOfWeek = DateUtil.getDayOfWeek((Date)time)) == 7 || dayOfWeek == 1 ? 0 : 1;
    }

    default public Date workTimeAdd(Date time, Integer inc) {
        ICalendarServiceCore calendarServiceCore = this.getCalendarService();
        if (calendarServiceCore != null) {
            try {
                return calendarServiceCore.addDurationToTime(time, inc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return time;
    }

    default public Integer workTimeSub(Date start, Date end) {
        ICalendarServiceCore calendarServiceCore = this.getCalendarService();
        if (calendarServiceCore != null) {
            try {
                return calendarServiceCore.calculateDuration(start, end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (int)(end.getTime() - start.getTime()) / 1000;
    }
}

