/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core;

import cn.hangar.agp.platform.core.data.BeanHelper;
import cn.hangar.agp.platform.core.data.ColumnRelation;
import cn.hangar.agp.platform.core.data.IColumnInfo;
import cn.hangar.agp.platform.core.data.IResDataDict;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.BaseLogicService;
import cn.hangar.agp.service.model.datasource.ResDataDict;
import cn.hangar.agp.service.model.logicservice.LogicServiceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class DataSourceAbstractLogicData
extends BaseLogicService {
    public void abstractChildByRelatedId(LogicServiceContext context, String parentDictRes, String parentChildKey, String childDictRes, List<?> childData, Function childCreator) {
        IResDataDict parentDict = ResDataDict.getResDataDict((String)parentDictRes, (boolean)true);
        IResDataDict childDict = ResDataDict.getResDataDict((String)childDictRes, (boolean)true);
        this.abstractChildByRelatedId(context, parentDict, parentChildKey, childDict, childData, childCreator);
    }

    public void abstractChildByRelatedId(LogicServiceContext context, IResDataDict parentDict, String parentChildKey, IResDataDict childDict, List<?> childData, Function childCreator) {
        String parentKeyField = parentDict.getKeyColumnName();
        String childRelatedParentIdField = null;
        for (IColumnInfo fd : childDict.getColumns()) {
            if (fd.getRelation() == null || fd.getRelation() != ColumnRelation.ForeignKeyWithSingle || StringUtils.isBlank((String)fd.getRelationId()) || !fd.getRelationId().equals(parentDict.getResId())) continue;
            childRelatedParentIdField = fd.getColumnName();
            break;
        }
        this.abstractChildByRelatedId(context, parentDict.getResId(), parentKeyField, parentChildKey, childDict.getResId(), childRelatedParentIdField, childData, childCreator);
    }

    public void abstractChildByRelatedId(LogicServiceContext context, String parentResId, String parentKeyField, String parentChildKey, String childResId, String childRelatedParentIdField, List<?> childData, Function childCreator) {
        ArrayList<Map> parentList;
        Object parentData = context.getUserDatas().get("_" + parentResId);
        if (childData == null || parentData == null || childData.size() == 0) {
            return;
        }
        if (parentData instanceof Map) {
            parentList = new ArrayList<Map>();
            parentList.add((Map)parentData);
        } else {
            parentList = (ArrayList<Map>)parentData;
        }
        HashMap mapParent = new HashMap(parentList.size());
        for (Map parentMap : parentList) {
            Object id = parentMap.get(parentKeyField);
            if (id == null) continue;
            mapParent.putIfAbsent(id, parentMap);
        }
        if (StringUtils.isBlank((String)childRelatedParentIdField)) {
            return;
        }
        ArrayList allChilds = new ArrayList();
        for (Object childDt : childData) {
            Map parent;
            Object pid;
            Map childMap = childDt instanceof Map ? (Map)childDt : BeanHelper.entityToMap(childDt);
            if (childMap == null || (pid = childMap.get(childRelatedParentIdField)) == null || (parent = (Map)mapParent.get(pid)) == null) continue;
            List childItem = (List)parent.computeIfAbsent(parentChildKey, t -> new ArrayList());
            if (childCreator != null) {
                Map childInstance = (Map)childCreator.apply(childMap);
                childItem.add(childInstance);
            } else {
                childItem.add(childMap);
            }
            allChilds.addAll(childItem);
        }
        context.getUserDatas().put("_" + childResId, allChilds);
    }
}

