/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core;

import cn.hangar.agp.platform.core.data.BeanHelper;
import cn.hangar.agp.platform.core.data.DataType;
import cn.hangar.agp.platform.core.data.IColumnInfo;
import cn.hangar.agp.platform.core.data.IResDataDict;
import cn.hangar.agp.platform.core.data.table.DataTable;
import cn.hangar.agp.platform.core.db.ConnectStringElement;
import cn.hangar.agp.platform.core.db.IDB;
import cn.hangar.agp.platform.core.db.TableSchema;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.service.core.util.DbHelper;
import cn.hangar.agp.service.model.nosql.Aggregation;
import cn.hangar.agp.service.model.nosql.AggregationResults;
import cn.hangar.agp.service.model.nosql.Criteria;
import cn.hangar.agp.service.model.nosql.DeleteResult;
import cn.hangar.agp.service.model.nosql.GroupBy;
import cn.hangar.agp.service.model.nosql.GroupByResults;
import cn.hangar.agp.service.model.nosql.INoSqlCreater;
import cn.hangar.agp.service.model.nosql.Query;
import cn.hangar.agp.service.model.nosql.Update;
import cn.hangar.agp.service.model.nosql.UpdateResult;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface DBService {
    public static final String DefaultDatabase = "Default";
    public static final String ConfigDatabase = "ConfigDatabase";
    public static final String AttachDatabase = "AttachDatabase";

    public static DBService instance() {
        return (DBService)ContextManager.findOne(DBService.class);
    }

    public static IDB createDB(String dbName) {
        IDB db = DbHelper.createDB(dbName);
        return db;
    }

    public void regiestConnectSetting(String var1);

    public void unRegiestBussDb(String var1);

    public ConnectStringElement getConnectSetting(String var1);

    public Map<String, ConnectStringElement> getConnectSettings();

    public String getDbType(String var1);

    default public void mapToEntity(Map map, Object obj) {
        BeanHelper.mapToEntity((Map)map, (Object)obj);
    }

    default public <T> T mapToEntity(Map map, Class<T> clazz) {
        return (T)BeanHelper.mapToEntity((Map)map, clazz);
    }

    public List handleResultData(List var1, String[] var2);

    public SqlService getSqlService();

    public NoSqlService getNoSqlService();

    public static interface ISqlBuilder {
        public void addTable(String var1);

        public void addColumn(IColumnInfo var1);

        public void addFieldOrderBy(IColumnInfo var1);

        public void addFilter(String var1);

        public void addFilter(String var1, IColumnInfo var2, Integer var3, String var4);

        public String builderSql();

        public Map<String, Object> builderParams(Object var1);
    }

    public static interface NoSqlService {
        public INoSqlCreater getNoSqlCreater(String var1);

        public boolean collectionExists(String var1, String var2);

        public Object createCollection(String var1, String var2);

        public Object getCollection(String var1, String var2);

        public void dropCollection(String var1, String var2);

        public <T> List<T> findAll(String var1, Class<T> var2, String var3);

        public <T> GroupByResults<T> group(String var1, String var2, GroupBy var3, Class<T> var4);

        public <T> GroupByResults<T> group(String var1, Criteria var2, String var3, GroupBy var4, Class<T> var5);

        public <O> AggregationResults<O> aggregate(String var1, Aggregation var2, String var3, Class<O> var4);

        public <T> T findOne(String var1, Query var2, Class<T> var3, String var4);

        public boolean exists(String var1, Query var2, String var3);

        public <T> List<T> find(String var1, Query var2, Class<T> var3, String var4);

        public <T> T findById(String var1, Object var2, Class<T> var3, String var4);

        public <T> T findAndModify(String var1, Query var2, Update var3, Class<T> var4, String var5);

        public <T> T findAndRemove(String var1, Query var2, Class<T> var3, String var4);

        public long count(String var1, Query var2, Class<?> var3, String var4);

        public void insert(String var1, Object var2);

        public void insert(String var1, Object var2, String var3);

        public void insert(String var1, Collection<? extends Object> var2, String var3);

        public void insertAll(String var1, Collection<? extends Object> var2);

        public void save(String var1, Object var2);

        public void save(String var1, Object var2, String var3);

        public UpdateResult upsert(String var1, Query var2, Update var3, Class<?> var4, String var5);

        public UpdateResult updateFirst(String var1, Query var2, Update var3, Class<?> var4, String var5);

        public UpdateResult updateMulti(String var1, Query var2, Update var3, Class<?> var4, String var5);

        public DeleteResult remove(String var1, Object var2);

        public DeleteResult remove(String var1, Query var2, Class<?> var3, String var4);

        public <T> List<T> findAllAndRemove(String var1, Query var2, Class<T> var3, String var4);
    }

    public static interface SqlService {
        public Date getDbTime(String var1);

        public String buildParameterName(String var1, String var2);

        public String buildParamHolder(String var1, String var2);

        public <T> List<T> select(String var1, String var2, Map<String, Object> var3, Class<T> var4);

        public <T> T selectOne(String var1, String var2, Map<String, Object> var3, Class<T> var4);

        public List<Map<String, Object>> selectMaps(String var1, String var2, Map<String, Object> var3);

        public Map<String, Object> selectMapOne(String var1, String var2, Map<String, Object> var3);

        public List selectObjs(String var1, String var2, Map<String, Object> var3);

        public Object selectObjOne(String var1, String var2, Map<String, Object> var3);

        public Object executeScalar(String var1, String var2, Map<String, Object> var3);

        public void executeNonQuery(String var1, String var2, Map<String, Object> var3);

        public int executeUpdate(String var1, String var2, Map<String, Object> var3);

        public int insert(String var1, Object var2, String var3);

        public int delete(String var1, Object var2, String var3);

        public DataTable executeDataSet(String var1, String var2, Map<String, Object> var3);

        public boolean hasTable(String var1, String var2);

        public boolean hasField(String var1, String var2, String var3);

        public boolean exist(String var1, String var2, Map<String, Object> var3);

        public int delete(String var1, IResDataDict var2, Object var3);

        public int update(String var1, IResDataDict var2, Object var3, Map<String, Object> var4);

        public int insert(String var1, IResDataDict var2, Map<String, Object> var3);

        public boolean fillDictionary(String var1, IResDataDict var2, Object var3, String[] var4, Map<String, Object> var5);

        public String executeAnonymousProcedure(String var1, String var2, Map<String, Object> var3);

        public Map<String, Object> executeProcedure(String var1, String var2, Map<String, Object> var3, Map<String, Integer> var4);

        public void executeBatch(String var1, String var2, List<Map> var3);

        public String buildDateTime(String var1, String var2, DataType var3);

        public int update(String var1, Object var2, String var3);

        public int delete(String var1, String var2, Map<String, Object> var3);

        public int executeUpdate(String var1, String var2, Map<String, Object> var3, int var4);

        public <T1> List<T1> findAll(String var1, Class<T1> var2);

        public <T1> T1 findFirst(String var1, Class<T1> var2, String var3, Object var4);

        public <T> long count(String var1, Class<T> var2);

        public <T> boolean exist(String var1, T var2);

        public Object getDataSource(String var1);

        public TableSchema getTableSchema(String var1, String var2);

        public void clearTableSchemaCache(String var1);
    }
}

