/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.cache.ICacheManager;
import cn.hangar.agp.platform.core.data.IColumnInfo;
import cn.hangar.agp.platform.core.data.IColumnInfoOwner;
import cn.hangar.agp.platform.core.data.IPolicyGroup;
import cn.hangar.agp.platform.core.data.IResDataDict;
import cn.hangar.agp.platform.core.data.MobileBoolean;
import cn.hangar.agp.platform.core.data.PropertyValueHelper;
import cn.hangar.agp.platform.core.db.IDB;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.sqlbuilder.FilterType;
import cn.hangar.agp.platform.express.ExpressHelper;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.DateUtil;
import cn.hangar.agp.platform.utils.GeneralUtil;
import cn.hangar.agp.platform.utils.RefObject;
import cn.hangar.agp.platform.utils.ReflectUtils;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.repository.core.BaseViewReposiotry;
import cn.hangar.agp.repository.core.IOperatorProvider;
import cn.hangar.agp.service.core.DBService;
import cn.hangar.agp.service.core.DataSourceService;
import cn.hangar.agp.service.core.IActsCallHandler;
import cn.hangar.agp.service.core.IIndexService;
import cn.hangar.agp.service.core.LogicService;
import cn.hangar.agp.service.core.util.DbHelper;
import cn.hangar.agp.service.log.IAgpLogger;
import cn.hangar.agp.service.model.datasource.ActsCallArg;
import cn.hangar.agp.service.model.datasource.ActsCallResult;
import cn.hangar.agp.service.model.datasource.DataColumnArgs;
import cn.hangar.agp.service.model.datasource.DataSourceCheckDataExistArg;
import cn.hangar.agp.service.model.datasource.DataSourceItemLoadArg;
import cn.hangar.agp.service.model.datasource.DataSourceItemSaveArg;
import cn.hangar.agp.service.model.datasource.DataSourceLoadArg;
import cn.hangar.agp.service.model.datasource.DataSourceSaveArg;
import cn.hangar.agp.service.model.datasource.FilterPart;
import cn.hangar.agp.service.model.datasource.PageInitArg;
import cn.hangar.agp.service.model.datasource.ResDataDict;
import cn.hangar.agp.service.model.datasource.SelectListResult;
import cn.hangar.agp.service.model.datasource.SelectResult;
import cn.hangar.agp.service.model.datasource.StatusGroup;
import cn.hangar.agp.service.model.datasource.StatusItem;
import cn.hangar.agp.service.model.datatemplate.DefaultExportArgument;
import cn.hangar.agp.service.model.dsinterface.InvokeLogicArgument;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.util.Assert;

public abstract class BaseViewService {
    public abstract BaseViewReposiotry getViewReposiotry();

    public SelectListResult exeSqlComD(DataSourceLoadArg arg) {
        for (DataSourceItemLoadArg item : arg.getItems()) {
            if (StringUtils.isBlank((String)item.getPreActInsId()) || StringUtils.isBlank((String)item.getPreSqlId())) continue;
            this.getViewReposiotry().execSqlCmd(item);
        }
        return null;
    }

    public SelectListResult exeSqlComd(DataSourceLoadArg arg) {
        for (DataSourceItemLoadArg item : arg.getItems()) {
            if (StringUtils.isBlank((String)item.getPreActInsId()) || StringUtils.isBlank((String)item.getPreSqlId())) continue;
            this.getViewReposiotry().execSqlCmd(item);
        }
        return null;
    }

    public void setFieldValue(Object obj, String fieldName, Object fieldValue) {
        if (obj == null) {
            return;
        }
        Field field = ReflectUtils.getField(obj.getClass(), (String)fieldName);
        if (field == null) {
            return;
        }
        int mod = field.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(obj, fieldValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object pageInIt(PageInitArg arg) {
        BaseViewReposiotry view = this.getViewReposiotry();
        return view.pageInIt(arg);
    }

    public Object pageinit(PageInitArg arg) {
        BaseViewReposiotry view = this.getViewReposiotry();
        return view.pageinit(arg);
    }

    public Object defaultExportData(DefaultExportArgument arg) {
        return null;
    }

    protected BaseViewService getUrlBaseViewService(String urlOrResId, Map<String, Object> urlParams) {
        HashMap urlargs = urlParams == null ? new HashMap() : urlParams;
        BaseViewService viewService = null;
        if (!StringUtils.isEmpty((String)urlOrResId)) {
            boolean isUrl = urlOrResId.contains("/") || urlOrResId.contains("\\");
            BaseViewService baseViewService = viewService = isUrl ? DataSourceService.instance().getBaseViewService(urlOrResId, "") : DataSourceService.instance().getBaseViewService(urlOrResId, Convert.toString(urlargs.get("version")));
            if (viewService == null) {
                List initPageServices = ContextManager.findList(DataSourceService.InitPageHandle.class);
                initPageServices.forEach(i -> i.init(urlOrResId, urlargs));
                BaseViewService baseViewService2 = viewService = isUrl ? DataSourceService.instance().getBaseViewService(urlOrResId, "") : DataSourceService.instance().getBaseViewService(urlOrResId, Convert.toString(urlargs.get("version")));
                if (viewService == null) {
                    Logger.warn(this.getClass(), (String)("\u672a\u77e5\u9875\u9762:" + urlOrResId + ",\u4f7f\u7528\u5f53\u524d\u9875\u9762\u670d\u52a1."));
                }
            }
        }
        return viewService == null ? this : viewService;
    }

    public static BaseViewService getViewService(String urlOrResId, Map<String, Object> urlargs) {
        BaseViewService viewService = null;
        if (!StringUtils.isEmpty((String)urlOrResId)) {
            boolean isUrl = urlOrResId.contains("/") || urlOrResId.contains("\\");
            BaseViewService baseViewService = viewService = isUrl ? DataSourceService.instance().getBaseViewService(urlOrResId, "") : DataSourceService.instance().getBaseViewService(urlOrResId, Convert.toString((Object)urlargs.get("version")));
            if (viewService == null) {
                List initPageServices = ContextManager.findList(DataSourceService.InitPageHandle.class);
                initPageServices.forEach(i -> i.init(urlOrResId, urlargs));
                viewService = isUrl ? DataSourceService.instance().getBaseViewService(urlOrResId, "") : DataSourceService.instance().getBaseViewService(urlOrResId, Convert.toString((Object)urlargs.get("version")));
            }
        }
        return viewService;
    }

    public List<List<DataSourceItemLoadArg>> groupDatasrouce(List<DataSourceItemLoadArg> dataSourceItemLoadArgList) {
        ArrayList<List<DataSourceItemLoadArg>> dataSourceItemLoadArgLists = new ArrayList<List<DataSourceItemLoadArg>>();
        for (DataSourceItemLoadArg dataSourceItemLoadArg : dataSourceItemLoadArgList) {
            if (dataSourceItemLoadArg.getParentName() == null) {
                ArrayList<DataSourceItemLoadArg> tempList = new ArrayList<DataSourceItemLoadArg>();
                tempList.add(dataSourceItemLoadArg);
                dataSourceItemLoadArgLists.add(tempList);
                continue;
            }
            for (List list : dataSourceItemLoadArgLists) {
                if (!((DataSourceItemLoadArg)list.get(0)).getSourceName().equals(dataSourceItemLoadArg.getParentName())) continue;
                list.add(dataSourceItemLoadArg);
            }
        }
        return dataSourceItemLoadArgLists;
    }

    public SelectListResult loadDataSource(DataSourceLoadArg arg) {
        BaseViewService viewService;
        if (arg != null) {
            arg.checkBadChar();
        }
        if ((viewService = this.getUrlBaseViewService(arg.getUrl(), arg.getUrlParams())) != null && !viewService.equals(this)) {
            return viewService.loadDataSource(arg);
        }
        Assert.notNull((Object)arg.getItems(), (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a\uff01");
        SelectListResult resultList = new SelectListResult();
        IOperatorProvider serializeProvider = this.getOperatorProvider(arg);
        Assert.notNull((Object)serializeProvider, (String)"\u7b56\u7565\u670d\u52a1\u4e3a\u7a7a\uff01");
        ArrayList<DataSourceItemLoadArg> reportItems = new ArrayList<DataSourceItemLoadArg>();
        ArrayList noReportItems = new ArrayList();
        arg.getItems().forEach(i -> {
            if (i.isReport()) {
                reportItems.add((DataSourceItemLoadArg)i);
            } else {
                noReportItems.add(i);
            }
        });
        if (reportItems.size() > 0) {
            List<List<DataSourceItemLoadArg>> dataSourceItemLoadArgLists = this.groupDatasrouce(reportItems);
            for (List<DataSourceItemLoadArg> dataSourceItemLoadArgList : dataSourceItemLoadArgLists) {
                SelectResult result = this.getViewReposiotry().queryDataSourceItemRPT(dataSourceItemLoadArgList);
                resultList.getData().add(result);
            }
        }
        if (noReportItems.size() > 0) {
            for (int i2 = 0; i2 < noReportItems.size(); ++i2) {
                DataSourceItemLoadArg itemArg = (DataSourceItemLoadArg)noReportItems.get(i2);
                SelectResult result = this.fetchFromCache(serializeProvider, itemArg);
                if (result == null) continue;
                resultList.getData().add(result);
                serializeProvider.afterQueryEntity(null, resultList.getData());
            }
        }
        return resultList;
    }

    private SelectResult fetchFromCache(IOperatorProvider serializeProvider, DataSourceItemLoadArg itemArg) {
        boolean needCache = false;
        String key = null;
        if (itemArg.getCacheValidTime() != null && itemArg.getCacheValidTime() > 0) {
            needCache = true;
            key = itemArg.getSourceName() + (itemArg.getQueryData() == null ? "" : "_" + JSON.toJSONString((Object)itemArg.getQueryData()));
            key = key + (itemArg.getExtArgument() == null ? "" : "_" + JSON.toJSONString((Object)itemArg.getExtArgument()));
            key = key + itemArg.getDataSourceId();
        }
        if (needCache) {
            String selectResultJson = (String)ICacheManager.instance().getDefaultCache().get(key, String.class);
            SelectResult selectResult = (SelectResult)JSONObject.parseObject((String)selectResultJson, SelectResult.class);
            if (selectResult != null) {
                Date recordTime = selectResult.getRecordTime();
                if (DateUtil.before((Date)DateUtil.addMinutes((Date)recordTime, (Integer)itemArg.getCacheValidTime()), (Date)new Date())) {
                    selectResult = this.fetchFromDb(serializeProvider, itemArg, key);
                }
            } else {
                selectResult = this.fetchFromDb(serializeProvider, itemArg, key);
            }
            return selectResult;
        }
        return this.fetchFromDb(serializeProvider, itemArg, key);
    }

    private SelectResult fetchFromDb(IOperatorProvider serializeProvider, DataSourceItemLoadArg itemArg, String key) {
        if (itemArg.isLogic()) {
            InvokeLogicArgument logicArg = new InvokeLogicArgument();
            logicArg.setLogicId(itemArg.getUniqueId());
            logicArg.setLogicArgument(itemArg.getExtArgument());
            List<Map> logicResult = this.transLogicResult(this.callProcessingLogic(logicArg));
            itemArg.setLogicResult(logicResult);
        }
        serializeProvider.setPolicies(this.getPolicys(itemArg.getSourceName()), itemArg);
        serializeProvider.setSource(itemArg.getSourceName());
        serializeProvider.setArgument(itemArg);
        serializeProvider.beforeQueryEntity(null);
        SelectResult result = null;
        try {
            result = this.getViewReposiotry().queryDataSourceItem(itemArg);
        }
        catch (Exception e) {
            IAgpLogger.logApiBuilder().apiName("\u52a0\u8f7d\u6570\u636e\u6e90").error(e);
        }
        if (result != null) {
            this.transSpecialColumns(itemArg, result);
            if (StringUtils.isBlank((String)result.getUniqueId())) {
                result.setUniqueId(itemArg.getUniqueId());
            }
            if (StringUtils.isBlank((String)result.getSourceName())) {
                result.setSourceName(itemArg.getSourceName());
            }
            if (itemArg.getLoadFinishedCallback() != null) {
                itemArg.getLoadFinishedCallback().apply(result);
            }
            result.setRecordTime(new Date());
            if (key != null) {
                ICacheManager.instance().getDefaultCache().put((Object)key, (Object)JSONObject.toJSONString((Object)result));
            }
        }
        return result;
    }

    private void transSpecialColumns(DataSourceItemLoadArg itemArg, SelectResult result) {
        IColumnInfoOwner dsi = itemArg.getDataColumns();
        if (dsi == null || result.getResult() == null || result.getResult().isEmpty()) {
            return;
        }
        IIndexService indexService = (IIndexService)ContextManager.findOne(IIndexService.class);
        String appid = AppContext.getCurrentAppId();
        for (IColumnInfo column : dsi.getColumns()) {
            if (column.checkImageColumn()) {
                for (Object obj : result.getResult()) {
                    String path;
                    Object value = PropertyValueHelper.getValue(obj, (String)column.getColumnName());
                    if (value == null || value.toString().contains("/") || (path = indexService.fetchCfgImagePath(value.toString(), appid)) == null) continue;
                    PropertyValueHelper.setValue(obj, (String)column.getColumnName(), (Object)path);
                }
                continue;
            }
            if (!column.checkKeyNameParentColumn()) continue;
            String showName = null;
            String displayName = null;
            String tableNmae = null;
            String pIdName = null;
            String idName = null;
            String type = null;
            String filter = null;
            String idNameTemp = null;
            if (column.getRelationId() == null) {
                showName = column.getColumnName();
                String express = column.getColumnExpress();
                String[] pList = express.substring(express.indexOf("(") + 1, express.indexOf(")")).split(",");
                idName = pList[0].replace("'", "");
                tableNmae = pList[1].replace("'", "");
                filter = pList[2].replace("'", "");
                pIdName = pList[3].replace("'", "");
                type = pList[4].replace("'", "");
                IResDataDict resDataDict = ResDataDict.getResDataDict((String)tableNmae);
                displayName = resDataDict.getDisplayColumnName();
                idNameTemp = idName;
            } else {
                IResDataDict resDataDict = ResDataDict.getResDataDict((String)column.getRelationId());
                displayName = resDataDict.getDisplayColumnName();
                pIdName = null;
                tableNmae = column.getRelationId();
                idName = column.getColumnName();
                idNameTemp = resDataDict.getPkeyfield();
                List resDictFieldList = resDataDict.getDataColumns();
                for (Object resDictField : resDictFieldList) {
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(resDictField));
                    if (jsonObject.get((Object)"resId") == null || !jsonObject.get((Object)"resId").equals(jsonObject.get((Object)"relationId"))) continue;
                    pIdName = jsonObject.getString("columnName");
                    break;
                }
                showName = idName + "_T";
                if (pIdName == null) continue;
            }
            IDB db = DbHelper.createDataBase();
            String sql = "SELECT " + pIdName + "," + displayName + "," + idNameTemp + " FROM " + tableNmae;
            if (filter != null) {
                sql = sql + " WHERE " + filter;
            }
            List resultMapList = db.selectMaps(sql, new HashMap());
            HashMap<String, Map<String, Object>> tempMap = new HashMap<String, Map<String, Object>>();
            for (Map resultMap : resultMapList) {
                tempMap.put((String)resultMap.get(idNameTemp), resultMap);
            }
            StringBuilder sb = new StringBuilder();
            for (Object obj : result.getResult()) {
                Object value = PropertyValueHelper.getValue(obj, (String)idName);
                if (value == null) continue;
                ArrayList<String> dataList = new ArrayList<String>();
                this.getKeyNameParentData(dataList, value.toString(), tempMap, pIdName, displayName, type);
                for (int x = dataList.size() - 1; x >= 0; --x) {
                    if (type != null) {
                        sb.append((String)dataList.get(x)).append(",");
                        continue;
                    }
                    sb.append((String)dataList.get(x)).append(">");
                }
                if (sb.length() <= 1) continue;
                PropertyValueHelper.setValue(obj, (String)showName, (Object)sb.substring(0, sb.length() - 1));
                sb.delete(0, sb.length());
            }
        }
    }

    private void getKeyNameParentData(List<String> data, String id, Map<String, Map<String, Object>> map, String pidName, String displayName, String type) {
        Map<String, Object> tempMap = map.get(id);
        if (tempMap == null) {
            return;
        }
        if (type != null && type.equals("0")) {
            data.add(tempMap.get(pidName).toString());
        } else {
            data.add(tempMap.get(displayName).toString());
        }
        if (tempMap.get(pidName) != null) {
            this.getKeyNameParentData(data, tempMap.get(pidName).toString(), map, pidName, displayName, type);
        }
    }

    public SelectListResult saveDataSource(DataSourceSaveArg arg) {
        if (arg != null) {
            arg.checkBadChar();
        }
        Assert.notNull((Object)arg.getItems(), (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a\uff01");
        BaseViewService viewService = this.getUrlBaseViewService(arg.getUrl(), arg.getUrlParams());
        if (viewService != null && !viewService.equals(this)) {
            return viewService.saveDataSource(arg);
        }
        SelectListResult resultList = new SelectListResult();
        IOperatorProvider serializeProvider = this.getOperatorProvider(arg);
        serializeProvider.setPolicies(this.getPolicys(arg.getPolicyGroupName()), arg);
        serializeProvider.beginOperate();
        serializeProvider.enableCachedUpdate(true);
        DataSourceLoadArg loadArg = new DataSourceLoadArg();
        HashMap<String, List> urlArgs = new HashMap<String, List>();
        HashMap<String, HashMap<Object, Object>> mapKeyIds = new HashMap<String, HashMap<Object, Object>>();
        for (int i = 0; i < arg.getItems().size(); ++i) {
            DataSourceItemSaveArg itemArg = (DataSourceItemSaveArg)arg.getItems().get(i);
            serializeProvider.setSource(itemArg.getSourceName());
            serializeProvider.setArgument(itemArg);
            if (!(StringUtils.isEmpty((String)itemArg.getUrl()) || StringUtils.equals((String)arg.getUrl(), (String)itemArg.getUrl()) || (viewService = this.getUrlBaseViewService(itemArg.getUrl(), null)) == null || viewService.equals(this))) {
                List list = urlArgs.getOrDefault(itemArg.getUrl(), new ArrayList());
                urlArgs.putIfAbsent(itemArg.getUrl(), list);
                list.add(itemArg);
                continue;
            }
            itemArg.setValidate(true);
            String string = itemArg.getSourceName();
            boolean flag = this.getViewReposiotry().saveDataSourceItem(serializeProvider, itemArg);
            if (!flag || !itemArg.isNeedReloadData() || itemArg.getLoadArgument() == null) continue;
            mapKeyIds.put(itemArg.getSourceName(), new HashMap());
            DataSourceItemLoadArg argLoad = itemArg.getLoadArgument();
            argLoad.setDataSourceId(itemArg.getDataSourceId());
            argLoad.setLoadFinishedCallback(o -> this.transIdRemapOldAndNewId((SelectResult)o, (HashMap)mapKeyIds.get(dsName)));
            loadArg.getItems().add(argLoad);
        }
        ArrayList<SelectListResult> subResults = new ArrayList<SelectListResult>();
        for (Map.Entry entry : urlArgs.entrySet()) {
            DataSourceSaveArg sarg = new DataSourceSaveArg();
            sarg.setUrl((String)entry.getKey());
            sarg.getItems().addAll((Collection)entry.getValue());
            sarg.setPolicyGroupName(arg.getPolicyGroupName());
            sarg.setExtArg(arg.getExtArg());
            SelectListResult subResult = this.getUrlBaseViewService(sarg.getUrl(), sarg.getUrlParams()).saveDataSource(sarg);
            if (subResult == null) continue;
            subResults.add(subResult);
        }
        if (arg.isIgnoreSaveData()) {
            serializeProvider.ignoreSaveData();
        }
        serializeProvider.cachedUpdate();
        this.translateKeyIds(arg, serializeProvider, mapKeyIds);
        serializeProvider.setArgument(arg);
        serializeProvider.endOperate();
        serializeProvider.postChangedMessage();
        SelectListResult result = null;
        result = this.loadDataSource(loadArg);
        if (result != null) {
            resultList.getData().addAll(result.getData());
            subResults.forEach(r -> resultList.getData().addAll(r.getData()));
        } else if (!subResults.isEmpty()) {
            subResults.forEach(r -> resultList.getData().addAll(r.getData()));
        }
        return resultList;
    }

    boolean transIdRemapOldAndNewId(SelectResult selectResult, HashMap mapNewAndOld) {
        if (selectResult == null || selectResult.getResult() == null || mapNewAndOld == null) {
            return true;
        }
        String keyField = selectResult.getKeyFieldName();
        String keyFieldRaw = "__PAM_VID__";
        RefObject refObject = new RefObject();
        for (Object entity : selectResult.getResult()) {
            Object oldId;
            if (!PropertyValueHelper.getValue(entity, (String)keyField, (RefObject)refObject) || refObject.getArgValue() == null || (oldId = mapNewAndOld.get(refObject.getArgValue().toString())) == null) continue;
            PropertyValueHelper.setValue(entity, (String)keyFieldRaw, oldId);
        }
        return true;
    }

    void reTransIdValue(DataSourceSaveArg arg, ArrayList<Boolean> needTrans, ArrayList<Object> oldTransIds, ArrayList<Object> newTransIds) {
        if (arg.getExtArg() != null && arg.getExtArg().size() > 0) {
            int len = oldTransIds.size();
            for (int i = 0; i < len; ++i) {
                Object oldId = oldTransIds.get(i);
                Object newId = newTransIds.get(i);
                Boolean need = needTrans.get(i);
                if (need == null || !need.booleanValue()) continue;
                this.translateArgument((Map)arg.getExtArg(), oldId, newId);
            }
        }
    }

    void reTransIdValue(DataSourceItemSaveArg arg, ArrayList<Boolean> needTrans, ArrayList<Object> oldTransIds, ArrayList<Object> newTransIds) {
        int len = oldTransIds.size();
        for (int i = 0; i < len; ++i) {
            Object oldId = oldTransIds.get(i);
            Object newId = newTransIds.get(i);
            Boolean need = needTrans.get(i);
            if (need == null || !need.booleanValue()) continue;
            if (arg.getExtArgument() != null && arg.getExtArgument().size() > 0) {
                this.translateArgument((Map)arg.getExtArgument(), oldId, newId);
            }
            if (!arg.isNeedReloadData() || arg.getLoadArgument() == null) continue;
            DataSourceItemLoadArg ldArg = arg.getLoadArgument();
            if (ldArg.getExtArgument() != null) {
                this.translateArgument((Map)ldArg.getExtArgument(), oldId, newId);
            }
            if (ldArg.getFilterIds() == null) continue;
            String v = ldArg.getFilterIds();
            v = v.replace(oldId.toString(), newId.toString());
            ldArg.setFilterIds(v);
        }
    }

    boolean isObjectEqual(Object src, Object dst) {
        if (src == null || dst == null) {
            return false;
        }
        if (src == dst || src.equals(dst)) {
            return true;
        }
        return src.toString().equals(dst.toString());
    }

    void translateArgument(Map map, Object oldId, Object newId) {
        Set entries = map.entrySet();
        for (Map.Entry ent : entries) {
            Object value = ent.getValue();
            if (!this.isObjectEqual(oldId, value)) continue;
            map.put(ent.getKey(), newId);
        }
    }

    public boolean saveDataSourceForEntity(IOperatorProvider operatorProvider, String entityClazz, DataSourceItemSaveArg arg) {
        return this.getViewReposiotry().saveDataSourceForEntity(operatorProvider, entityClazz, arg);
    }

    public static boolean doSaveDataSourceForEntity(IOperatorProvider operatorProvider, String entityClazz, DataSourceItemSaveArg arg) {
        return BaseViewReposiotry.doSaveDataSourceForEntity(operatorProvider, entityClazz, arg);
    }

    public SelectListResult autoSaveDataSource(DataSourceSaveArg arg) {
        Assert.notNull((Object)arg.getItems(), (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a\uff01");
        SelectListResult resultList = new SelectListResult();
        IOperatorProvider serializeProvider = this.getOperatorProvider(arg);
        serializeProvider.beginOperate();
        serializeProvider.enableCachedUpdate(true);
        DataSourceLoadArg loadArg = new DataSourceLoadArg();
        HashMap urlArgs = new HashMap();
        HashMap<String, HashMap<Object, Object>> mapKeyIds = new HashMap<String, HashMap<Object, Object>>();
        for (int i = 0; i < arg.getItems().size(); ++i) {
            DataSourceItemSaveArg itemArg = (DataSourceItemSaveArg)arg.getItems().get(i);
            if (!StringUtils.isEmpty((String)itemArg.getUrl()) && !StringUtils.equals((String)arg.getUrl(), (String)itemArg.getUrl())) {
                ((List)urlArgs.getOrDefault(itemArg.getUrl(), new ArrayList())).add(itemArg);
                continue;
            }
            serializeProvider.setSource(itemArg.getSourceName());
            serializeProvider.setArgument(itemArg);
            String string = itemArg.getSourceName();
            boolean flag = this.getViewReposiotry().saveDataSourceItem(serializeProvider, itemArg);
            if (!flag || !itemArg.isNeedReloadData() || itemArg.getLoadArgument() == null) continue;
            loadArg.getItems().add(itemArg.getLoadArgument());
            mapKeyIds.put(itemArg.getSourceName(), new HashMap());
            DataSourceItemLoadArg argLoad = itemArg.getLoadArgument();
            argLoad.setLoadFinishedCallback(o -> this.transIdRemapOldAndNewId((SelectResult)o, (HashMap)mapKeyIds.get(dsName)));
        }
        ArrayList<SelectListResult> subResults = new ArrayList<SelectListResult>();
        for (Map.Entry entry : urlArgs.entrySet()) {
            DataSourceSaveArg sarg = new DataSourceSaveArg();
            sarg.setUrl((String)entry.getKey());
            sarg.getItems().addAll((Collection)entry.getValue());
            SelectListResult subResult = DataSourceService.instance().saveDataSource(sarg);
            if (subResult == null) continue;
            subResults.add(subResult);
        }
        serializeProvider.cachedUpdate();
        this.translateKeyIds(arg, serializeProvider, mapKeyIds);
        serializeProvider.endOperate();
        serializeProvider.postChangedMessage();
        SelectListResult result = null;
        result = this.loadDataSource(loadArg);
        if (result != null) {
            resultList.getData().addAll(result.getData());
            subResults.forEach(r -> resultList.getData().addAll(r.getData()));
        } else if (!subResults.isEmpty()) {
            subResults.forEach(r -> resultList.getData().addAll(r.getData()));
        }
        return resultList;
    }

    private void translateKeyIds(DataSourceSaveArg arg, IOperatorProvider serializeProvider, HashMap<String, HashMap<Object, Object>> mapKeyIds) {
        ArrayList<Object> oldTransIds = new ArrayList<Object>();
        ArrayList<Object> newTransIds = new ArrayList<Object>();
        ArrayList<String> dsName = new ArrayList<String>();
        ArrayList<Boolean> needTrans = new ArrayList<Boolean>();
        serializeProvider.getTranslatedObjects(dsName, needTrans, oldTransIds, newTransIds);
        if (oldTransIds.size() > 0) {
            int i;
            int len = oldTransIds.size();
            for (i = 0; i < len; ++i) {
                HashMap<Object, Object> m = mapKeyIds.get(dsName.get(i));
                if (m == null) continue;
                m.put(newTransIds.get(i).toString(), oldTransIds.get(i));
            }
            this.reTransIdValue(arg, needTrans, oldTransIds, newTransIds);
            for (i = 0; i < arg.getItems().size(); ++i) {
                DataSourceItemSaveArg itemArg = (DataSourceItemSaveArg)arg.getItems().get(i);
                this.reTransIdValue(itemArg, needTrans, oldTransIds, newTransIds);
            }
        }
    }

    public IOperatorProvider getOperatorProvider(Object arg) {
        DataSourceService dataSourceService = (DataSourceService)ContextManager.find(DataSourceService.class);
        IOperatorProvider serializeProvider = dataSourceService.createOperatorProvider();
        serializeProvider.setArgument(arg);
        return serializeProvider;
    }

    public Object checkDataExist(DataSourceCheckDataExistArg arg) {
        Assert.notNull((Object)arg, (String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a\uff01");
        boolean result = this.getViewReposiotry().checkDataExist(arg);
        return result;
    }

    public Object checkUniqueKey(DataColumnArgs args) {
        IResDataDict resDict = ResDataDict.getResDataDict((String)args.getResId(), (boolean)true);
        IColumnInfo column = resDict.getColumnInfo(args.getColName());
        IColumnInfo keyColumn = resDict.getKeyColumnInfo();
        DBService.ISqlBuilder sqlBuilder = DataSourceService.instance().createSqlBuilder();
        sqlBuilder.addColumn(keyColumn);
        sqlBuilder.addTable(resDict.getStorageName());
        if (resDict != null && StringUtils.isNotBlank((String)resDict.getFixedFilter())) {
            sqlBuilder.addFilter(resDict.getFixedFilter());
        }
        sqlBuilder.addFilter(String.format("%1$s='@@%1$s@@'", column.getColumnName()));
        RefObject key = new RefObject();
        if (args.resolveParamerValue(keyColumn.getStorageName(), null, key)) {
            sqlBuilder.addFilter(String.format("%1$s<>'@@%1$s@@'", keyColumn.getStorageName()));
        } else {
            sqlBuilder.addFilter(String.format("%1$s<>'%2$s'", keyColumn.getStorageName(), GeneralUtil.UUID()));
        }
        if (StringUtils.isNotBlank((String)column.getRefAid())) {
            sqlBuilder.addFilter(column.getRefAid());
        }
        String sqlsb = sqlBuilder.builderSql();
        RefObject sqlref = new RefObject();
        RefObject paramsref = new RefObject();
        Object result = null;
        if (ExpressHelper.parseCommand((String)sqlsb.toString(), (RefObject)sqlref, (RefObject)paramsref, (Object[])new Object[]{args})) {
            DBService dbService = (DBService)ContextManager.find(DBService.class);
            result = dbService.getSqlService().selectObjOne(null, (String)sqlref.argValue, (Map)paramsref.argValue);
        }
        if (result != null) {
            return new MobileBoolean(false);
        }
        return new MobileBoolean(true);
    }

    public IPolicyGroup getPolicys(String policyGroupName) {
        return null;
    }

    public Object handleMsg(List list, Object msgError) {
        return this.getViewReposiotry().handleMsg(list, msgError);
    }

    public boolean handleValidateMsg(List list, RefObject result) {
        return this.getViewReposiotry().handleValidateMsg(list, result);
    }

    public Object defaultActCall(String actId, ActsCallArg arg) {
        List handlers = ContextManager.findList(IActsCallHandler.class);
        if (handlers != null) {
            for (IActsCallHandler handler : handlers) {
                if (!handler.getEnableActins().containsKey(actId)) continue;
                ActsCallResult result = handler.executeActins(arg);
                return result.getData();
            }
        }
        return null;
    }

    public byte[] compressImageCreate(BufferedImage image, String type) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).outputFormat(type).scale(1.0).outputQuality(0.5f).toOutputStream((OutputStream)out);
        return out.toByteArray();
    }

    protected String[] getStatusItemList(String statusGroupId) {
        if (StringUtils.isBlank((String)statusGroupId)) {
            return null;
        }
        StatusGroup statusGroup = StatusGroup.getStatusGroup((String)statusGroupId, (boolean)true);
        if (statusGroup != null && statusGroup.getItems() != null && statusGroup.getItems().size() != 0) {
            List<String> values = statusGroup.getItems().stream().map(StatusItem::getStatusname).collect(Collectors.toList());
            String[] array = new String[values.size()];
            return values.toArray(array);
        }
        return null;
    }

    public Object callProcessingLogic(InvokeLogicArgument arg) {
        List services = ContextManager.findList(LogicService.class);
        if (services != null) {
            for (LogicService service : services) {
                if (!StringUtils.equals((String)arg.getLogicId(), (String)service.getLogicId())) continue;
                return service.invokeLogicService(arg);
            }
        }
        return null;
    }

    public List<Map> transLogicResult(Object logicResult) {
        if (logicResult != null) {
            if (logicResult instanceof List) {
                return (List)logicResult;
            }
            if (logicResult instanceof Map) {
                return Collections.singletonList((Map)logicResult);
            }
        }
        return null;
    }

    public SelectListResult loadDataSourceWithParent(DataSourceLoadArg loadArg, String keyField, String pField) {
        Assert.notEmpty((Collection)loadArg.getItems(), (String)"\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570");
        DataSourceItemLoadArg loadItem = (DataSourceItemLoadArg)loadArg.getItems().get(0);
        ArrayList<List> levelItems = new ArrayList<List>();
        ArrayList allItems = new ArrayList();
        this.loadDataSourceWithParent(loadArg, levelItems, keyField, pField, null);
        SelectListResult result = new SelectListResult();
        SelectResult resultItem = new SelectResult();
        result.getData().add(resultItem);
        resultItem.setUniqueId(loadItem.getUniqueId());
        resultItem.setSourceName(loadItem.getSourceName());
        resultItem.setResult(allItems);
        this.handleLevelItems(levelItems, 0, null, pField, keyField, allItems);
        return result;
    }

    private void handleLevelItems(List<List> levelItems, int level, Object pid, String pField, String keyField, List allItems) {
        if (level < levelItems.size()) {
            Iterator iterator = levelItems.get(level).iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (pid != null && !pid.equals(PropertyValueHelper.getValue(item, (String)pField))) continue;
                allItems.add(item);
                this.handleLevelItems(levelItems, level + 1, PropertyValueHelper.getValue(item, (String)keyField), pField, keyField, allItems);
                iterator.remove();
            }
        }
    }

    private void loadDataSourceWithParent(DataSourceLoadArg loadArg, List<List> levelItems, String keyField, String pField, List<Object> pIds) {
        SelectResult selectResult;
        SelectListResult result;
        DataSourceItemLoadArg loadItem = (DataSourceItemLoadArg)loadArg.getItems().get(0);
        loadItem.setRetrieveTotalRowCount(false);
        if (pIds != null && pIds.size() > 0) {
            FilterPart filterPart = new FilterPart(pField, FilterType.In.getValue(), (Object)StringUtils.join((String)",", pIds));
            loadItem.setFilters(Collections.singletonList(filterPart));
        }
        if ((result = this.loadDataSource(loadArg)) != null && result.getData() != null && result.getData().size() > 0 && (selectResult = (SelectResult)result.getData().get(0)).getResult() != null && selectResult.getResult().size() > 0) {
            List items = selectResult.getResult();
            ArrayList<Object> ids = new ArrayList<Object>();
            for (Object item : items) {
                Object id = PropertyValueHelper.getValue(item, (String)keyField);
                ids.add(id);
            }
            levelItems.add(items);
            if (ids.size() > 0) {
                this.loadDataSourceWithParent(loadArg, levelItems, keyField, pField, ids);
            }
        }
    }
}

