/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.cache.ICacheManager;
import cn.hangar.agp.platform.core.cache.IRegionCache;
import cn.hangar.agp.platform.core.data.CaseMap;
import cn.hangar.agp.platform.core.data.PropertyValueHelper;
import cn.hangar.agp.platform.core.db.IDB;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.core.ioc.SpringUtil;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.core.serialize.SerializeFactory;
import cn.hangar.agp.platform.core.util.ExecutorServcieHelperEx;
import cn.hangar.agp.platform.core.util.XmlUtil;
import cn.hangar.agp.platform.utils.AssertHelper;
import cn.hangar.agp.platform.utils.CollectionUtil;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.ExecutorServiceHelper;
import cn.hangar.agp.platform.utils.HostUtil;
import cn.hangar.agp.platform.utils.KeyValue;
import cn.hangar.agp.platform.utils.ReflectUtils;
import cn.hangar.agp.platform.utils.SoftValueHashMap;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.CacheService;
import cn.hangar.agp.service.core.DataSourceService;
import cn.hangar.agp.service.core.IActsCallHandler;
import cn.hangar.agp.service.core.IActsCallService;
import cn.hangar.agp.service.core.ICalendarServiceCore;
import cn.hangar.agp.service.core.LogicService;
import cn.hangar.agp.service.core.logic.LogicCacheBase;
import cn.hangar.agp.service.core.logic.LogicDateBase;
import cn.hangar.agp.service.core.logic.LogicDebugBase;
import cn.hangar.agp.service.core.logic.LogicGeometryBase;
import cn.hangar.agp.service.core.logic.LogicMathBase;
import cn.hangar.agp.service.core.logic.LogicObjectBase;
import cn.hangar.agp.service.core.logic.LogicStringBase;
import cn.hangar.agp.service.core.util.EncryptHelper;
import cn.hangar.agp.service.core.util.SysUserRangeUtils;
import cn.hangar.agp.service.model.datasource.ActsCallArg;
import cn.hangar.agp.service.model.datasource.ActsCallResult;
import cn.hangar.agp.service.model.datasource.FetchEntityModeArgument;
import cn.hangar.agp.service.model.datasource.StatusGroup;
import cn.hangar.agp.service.model.datasource.StatusItem;
import cn.hangar.agp.service.model.logicservice.DebugData;
import cn.hangar.agp.service.model.logicservice.ILogicPlugIn;
import cn.hangar.agp.service.model.logicservice.ListData;
import cn.hangar.agp.service.model.logicservice.ListDataDeserializer;
import cn.hangar.agp.service.model.logicservice.LogicServiceContext;
import cn.hangar.agp.service.model.logicservice.LogicUtil;
import cn.hangar.agp.service.model.logicservice.StructData;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.sun.media.sound.WaveFileReader;
import com.sun.media.sound.WaveFileWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.util.Assert;

public abstract class BaseLogicService
implements LogicService,
LogicCacheBase,
LogicStringBase,
LogicDebugBase,
LogicDateBase,
LogicMathBase,
LogicObjectBase,
LogicGeometryBase {
    protected static Logger log = LoggerFactory.getLogger(BaseLogicService.class);
    static Map<String, AtomicInteger> forpoints = new SoftValueHashMap();
    static final int maxForCount = 10000;
    static ExecutorService executorService = ExecutorServiceHelper.newCachedThreadPool((String)"redis");
    static Executor executor = ExecutorServcieHelperEx.newFixedThreadPool((int)2, (String)"LogicService");
    private static CacheService _cacheService;
    private Map<String, Class> useMap = new HashMap<String, Class>();
    private static ICalendarServiceCore iCalendarServiceCore;
    private static MySqlFieldHolderProvider mySqlFieldHolderProvider;
    private static MsSqlFieldHolderProvider msSqlFieldHolderProvider;
    private static OracleSqlFieldHolderProvider oracleSqlFieldHolderProvider;

    protected boolean innerStart(LogicServiceContext context) {
        ILogicPlugIn debugger = context.debugger();
        return debugger == null ? false : debugger.exec((Object)this, context);
    }

    @Override
    public Object redisGet(Object key, int idx) {
        Object list = this.redisGet(key);
        if (list instanceof String) {
            list = SerializeFactory.parseJson((String)list.toString());
        }
        return list == null ? null : this.get(list, idx);
    }

    public static void breakPoint(String point) {
        int c;
        AtomicInteger count = forpoints.computeIfAbsent(point, k -> new AtomicInteger());
        int n = c = count == null ? 0 : count.incrementAndGet();
        if (c > 10000) {
            throw new AppException("\u4ee3\u7801\u7591\u4f3c\u6b7b\u5faa\u73af\uff1a" + point);
        }
    }

    public ActsCallResult execSysAct(String actInsId, Map params) {
        IActsCallService service = (IActsCallService)ContextManager.find(IActsCallService.class);
        ActsCallArg arg = new ActsCallArg();
        arg.setActInsId(actInsId);
        arg.setParams(params);
        return service.exeActIns(arg);
    }

    public void execSysActAsync(Object target, String actInsId, Map params) {
        if (target instanceof IActsCallHandler) {
            IActsCallHandler handler = (IActsCallHandler)target;
            AppContext context = AppContext.Current();
            ActsCallArg arg = new ActsCallArg();
            arg.setActInsId(actInsId);
            arg.setParams(params);
            executor.execute(() -> {
                AppContext.setCurrent((AppContext)context);
                handler.executeActins(arg);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLocalFile(String localPath, String content) throws IOException {
        AssertHelper.notEmpty((String)localPath, (String)"\u6587\u4ef6\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        File local = new File(localPath);
        File parentDir = local.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        OutputStreamWriter fw = null;
        BufferedWriter bw = null;
        try {
            File file = new File(localPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            fw = new FileWriter(file, false);
            bw = new BufferedWriter(fw);
            bw.write(content);
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (fw != null) {
                fw.close();
            }
        }
    }

    static ILogicPlugIn getDebugger(LogicServiceContext context) {
        if (context != null && context.debugger() != null) {
            return context.debugger();
        }
        Object debug = AppContext.getCurrentData((String)"_currentDebugger");
        return (ILogicPlugIn)debug;
    }

    public static void debugPoint(LogicServiceContext context, String nodeId_no, Boolean isExpression, Object keyValues) {
        ILogicPlugIn debuger = BaseLogicService.getDebugger(context);
        if (debuger != null) {
            debuger.waitForNext(context, nodeId_no, isExpression, keyValues);
        }
    }

    public static void debugPoint(LogicServiceContext context, String nodeId_no, Boolean isExpression, Object keyValues, String msg) {
        ILogicPlugIn debuger = BaseLogicService.getDebugger(context);
        if (debuger != null) {
            debuger.waitForNext(context, nodeId_no, isExpression, keyValues, msg);
        }
        log.info(msg);
    }

    public static void debugMsg(LogicServiceContext context, String nodeId, String msg) {
        ILogicPlugIn debuger = BaseLogicService.getDebugger(context);
        if (debuger != null) {
            debuger.getLog().debugMessage(nodeId, msg);
        }
    }

    public static void debugError(LogicServiceContext context, String nodeId, String msg) {
        ILogicPlugIn debuger = BaseLogicService.getDebugger(context);
        if (debuger != null) {
            debuger.getLog().debugError(nodeId, msg);
        }
    }

    public void writeLog(Object info, int type) {
        switch (type) {
            case 1: {
                log.debug(Convert.toString((Object)info));
                break;
            }
            case 2: {
                log.error(Convert.toString((Object)info));
                break;
            }
            default: {
                log.info(Convert.toString((Object)info));
            }
        }
    }

    public void writeLog(int info, int type) {
        this.writeLog((Object)info, type);
    }

    public void writeLog(double info, int type) {
        this.writeLog((Object)info, type);
    }

    public void writeLog(boolean info, int type) {
        this.writeLog((Object)info, type);
    }

    public int setBit(int s, int offist, int v) {
        Assert.isTrue((v >= 0 && v <= 1 ? 1 : 0) != 0, (String)"setBit\u7b2c\u4e09\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a0\u62161");
        Assert.isTrue((offist >= 0 && offist < 8 ? 1 : 0) != 0, (String)"setBit\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a0-7\u4e4b\u95f4");
        String str = Integer.toBinaryString(s);
        String vstr = "";
        if (offist < 0 || offist > str.length() - 1) {
            return s;
        }
        vstr = offist == 0 ? v + str.substring(offist + 1) : (offist == str.length() - 1 ? str.substring(0, offist) + v : str.substring(0, offist) + v + str.substring(offist + 1));
        return Integer.parseInt(vstr, 2);
    }

    public Map newMap() {
        return new HashMap();
    }

    public List newList() {
        return new ArrayList();
    }

    public Set newSet() {
        return new HashSet();
    }

    public byte weekdayToBit(Object weekday) {
        String days = weekday.toString();
        String v = "0b";
        List ds = CollectionUtil.list((Object[])new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"});
        for (String d : ds) {
            if (days.contains(d)) {
                v = v + 1;
                continue;
            }
            v = v + 0;
        }
        v = v + 0;
        return Byte.parseByte(v, 2);
    }

    public Object putAll(Object obj1, Object obj2) {
        if (obj1 instanceof Map && obj2 instanceof Map) {
            ((Map)obj1).putAll((Map)obj2);
        }
        if (obj1 instanceof Collection && obj2 instanceof Collection) {
            ((Collection)obj1).addAll((Collection)obj2);
        }
        return obj1;
    }

    public Object removeAll(Object obj1, Object obj2) {
        if (obj1 instanceof Map && obj2 instanceof Map) {
            ((Map)obj2).forEach((k, v) -> ((Map)obj1).remove(k));
        }
        if (obj1 instanceof Collection && obj2 instanceof Collection) {
            ((Collection)obj2).forEach(v -> ((Collection)obj1).remove(v));
        }
        return obj1;
    }

    public Object put(Object obj1, Object obj2) {
        if (obj1 instanceof Collection) {
            ((Collection)obj1).add(obj2);
        }
        return obj1;
    }

    public Object remove(Object list, Object item) {
        if (list instanceof Collection) {
            Collection lst = (Collection)list;
            if (item instanceof Collection) {
                for (Object o : (Collection)item) {
                    lst.remove(o);
                }
            } else {
                lst.remove(item);
            }
        }
        return list;
    }

    public Object delFromDim(Object list, Object item) {
        return this.remove(list, item);
    }

    public Object get(List list, int idx) {
        return --idx > -1 && idx < list.size() ? list.get(idx) : null;
    }

    public Object get(List list, int idx, String field) {
        Object item = this.get(list, idx);
        return this.get(item, field);
    }

    public Object get(Object obj, int idx) {
        if (obj instanceof List) {
            return this.get((List)obj, idx);
        }
        return this.get(obj, String.valueOf(idx));
    }

    public Object get(Object obj, int idx, String field) {
        if (obj instanceof List) {
            return this.get((List)obj, idx, field);
        }
        return this.get(obj, field);
    }

    public Object get(Object obj, String field) {
        if (obj instanceof List) {
            ArrayList result = new ArrayList();
            ((List)obj).forEach(o -> result.add(PropertyValueHelper.getValue((Object)o, (String)field)));
            return result;
        }
        return PropertyValueHelper.getValue((Object)obj, (String)field);
    }

    public Object get(List list, String field, Integer topN) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (list != null) {
            for (int i = 0; i < topN && i < list.size(); ++i) {
                result.add(this.get(list.get(i), field));
            }
        }
        return StringUtils.join((String)",", result);
    }

    public void set(Object obj, Object field, Object value) {
        if (field == null) {
            return;
        }
        String kes = field.toString();
        if (kes.contains(".")) {
            String[] ims = kes.split("\\.");
            String[] range = new String[ims.length - 1];
            int len = ims.length - 1;
            for (int i = 0; i < len; ++i) {
                range[i] = ims[i];
            }
            try {
                PropertyValueHelper.setValue((Object)obj, (String)ims[ims.length - 1], (String[])range, (boolean)true, (Object)value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PropertyValueHelper.setValue((Object)obj, (String)kes, (Object)value);
        }
    }

    public void set(Object obj, Object field, int value) {
        this.set(obj, (Object)field.toString(), new Integer(value));
    }

    public void set(Object obj, Object field, long value) {
        this.set(obj, (Object)field.toString(), new Long(value));
    }

    public void set(Object obj, Object field, float value) {
        this.set(obj, (Object)field.toString(), new Float(value));
    }

    public void set(Object obj, Object field, double value) {
        this.set(obj, (Object)field.toString(), new Double(value));
    }

    public void set(Object obj, Object field, char value) {
        this.set(obj, (Object)field.toString(), new Character(value));
    }

    public List<String> base64List(Object text, int len) {
        ArrayList<String> result = new ArrayList<String>();
        if (text instanceof byte[]) {
            byte[] source = (byte[])text;
            int pos = 0;
            do {
                byte[] dest = new byte[len];
                int length = Math.min(len, source.length - pos);
                System.arraycopy(source, pos, dest, 0, length);
                result.add(this.base64(dest));
            } while ((pos += len) < source.length);
        } else {
            result.add(this.base64(text));
        }
        return result;
    }

    public String toXml(Object obj) {
        return BaseLogicService.beanToXml(obj);
    }

    public String toXml(Object obj, String name) {
        if (obj != null) {
            try {
                Document doc = DocumentHelper.createDocument();
                Element root = doc.addElement("ROOT");
                StringBuilder sb = new StringBuilder();
                if (obj instanceof StructData) {
                    sb.append(BaseLogicService.beanToXml(obj));
                } else if (obj instanceof ArrayList) {
                    ArrayList lst = (ArrayList)obj;
                    for (Object o : lst) {
                        sb.append(BaseLogicService.serialize(o, name));
                    }
                } else if (obj instanceof HashMap) {
                    HashMap map = (HashMap)obj;
                    for (Object k : map.keySet()) {
                        Object v = map.get(k);
                        sb.append(String.format("<entry><key>%1$s<key/><value>%2$s<value/><entry/>", String.valueOf(k), BaseLogicService.serialize(v, name)));
                    }
                }
                root.setContent(XmlUtil.parseXmlNoRoot2((String)sb.toString()));
                return doc.asXML();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String beanToXml(Object bean) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"GBK");
            marshaller.setProperty("jaxb.fragment", (Object)true);
            StringWriter writer = new StringWriter();
            marshaller.marshal(bean, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String serialize(Object obj, String name) {
        if (obj instanceof StructData) {
            return BaseLogicService.beanToXml(obj);
        }
        return String.format("<%1$s>%2$s</%1$s>", name, String.valueOf(obj));
    }

    public Object parseDim(int data, Class target) {
        return this.parseDim(new Integer(data), (Class<T>)target);
    }

    public Object parseDim(double data, Class target) {
        return this.parseDim(new Double(data), (Class<T>)target);
    }

    public Object parseDim(long data, Class target) {
        return this.parseDim(new Long(data), (Class<T>)target);
    }

    public <T> T parseDim(Object data, Class<T> target) {
        return (T)LogicUtil.parseDim((Object)data, target);
    }

    public <T, V extends ArrayList> ArrayList<T> parseDimListData(Object data, Class<T> target) {
        return this.parseDimListData(data, target, ArrayList.class);
    }

    public <T, V extends ArrayList> ArrayList<T> parseDimListData(Object data, Class<T> target, Class<V> listCls) {
        return LogicUtil.parseDimListData((Object)data, target, listCls);
    }

    public <T, V extends HashMap<String, T>> V parseDimHashMap(Object data, Class<T> target, Class<V> resultType) {
        try {
            HashMap result = (HashMap)resultType.newInstance();
            result.putAll(this.parseDimHashMap(data, target));
            return (V)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> HashMap<String, T> parseDimHashMap(Object data, Class<T> target) {
        return LogicUtil.parseDimHashMap((Object)data, target);
    }

    public String format(Object obj, String formatPattern) {
        if (obj instanceof Date) {
            String dateTimeFormatPattern = BaseLogicService.getDateTimeFormatPattern(formatPattern);
            return StringUtils.formatDate((Date)((Date)obj), (String)dateTimeFormatPattern);
        }
        if (Number.class.isAssignableFrom(obj.getClass())) {
            DecimalFormat formatter = new DecimalFormat(formatPattern);
            return formatter.format(obj);
        }
        return Convert.toString((Object)obj);
    }

    public boolean isXml(Object x) {
        if (x == null) {
            return false;
        }
        try {
            StringReader stringReader = new StringReader(x.toString());
            SAXReader saxReader = new SAXReader();
            saxReader.read((Reader)stringReader);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isJson(Object x) {
        if (x != null) {
            try {
                JSONObject.parse((String)x.toString());
            }
            catch (JSONException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public <T> T fromXml(Object x, Class<T> clz) {
        if (x == null) {
            return null;
        }
        try {
            return (T)XmlUtil.xmlToBean((String)x.toString(), clz);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T fromJson(Object x, Class<T> clz) {
        if (x == null) {
            return null;
        }
        try {
            String json = String.class.isAssignableFrom(x.getClass()) ? x.toString() : JSON.toJSONString((Object)x);
            return (T)JSON.parseObject((String)json, clz);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object fromXml(Object x) {
        return x;
    }

    public Object fromJson(Object x) {
        return x;
    }

    public String toJsonStr(Object x) {
        return x == null ? null : JSON.toJSONString((Object)x);
    }

    public DebugData debug(Object x) {
        System.out.println(x);
        return new DebugData(x);
    }

    @Override
    public CacheService getCacheService() {
        if (_cacheService == null) {
            _cacheService = (CacheService)ContextManager.find(CacheService.class);
        }
        return _cacheService;
    }

    private static String getDateTimeFormatPattern(String formatPattern) {
        switch (formatPattern.toLowerCase()) {
            case "yyyy-mm-dd hh:mm:ss": {
                return "yyyy-MM-dd HH:mm:ss";
            }
            case "yyyy-mm-dd hh:mm": {
                return "yyyy-MM-dd HH:mm";
            }
            case "yyyy-mm-dd": {
                return "yyyy-MM-dd";
            }
            case "yyyy-mm": {
                return "yyyy-MM";
            }
            case "yyyymmddhhmmss": {
                return "yyyyMMddHHmmss";
            }
            case "yyyy-mm-dd hh24:mi:ss": {
                return "yyyy-MM-dd HH:mm:ss";
            }
        }
        return formatPattern;
    }

    protected void registerDeserializers() {
    }

    protected void registerDeserializer(Class type) {
        ListDataDeserializer.instance.registerType(type);
        if (ListData.class.isAssignableFrom(type)) {
            ParserConfig.getGlobalInstance().putDeserializer((Type)type, (ObjectDeserializer)ListDataDeserializer.instance);
        }
    }

    protected BaseLogicService() {
        this.registerDeserializers();
    }

    protected void putJsonParam(Map params, String key, Object val) {
        if (val != null && (val instanceof ListData || val instanceof StructData || val instanceof HashMap)) {
            String strVal = SerializeFactory.toJson((Object)val);
            params.put(key, strVal);
            log.info("\u4f20\u5165\u53c2\u6570%s: %s", (Object)key, (Object)strVal);
        } else {
            params.put(key, val);
            log.info("\u4f20\u5165\u53c2\u6570%s: %s", (Object)key, val);
        }
    }

    protected void putParam(Map params, String key, Object val) {
        JSONObject object;
        String json;
        boolean isJson = false;
        if ("input".equals(key) && val instanceof String && (json = ((String)val).trim()).startsWith("{") && json.endsWith("}") && (object = JSON.parseObject((String)json)) != null) {
            isJson = true;
            params.putAll(object);
            log.info("\u4f20\u5165\u53c2\u6570%s: %s", (Object)key, (Object)object);
        }
        if (!isJson) {
            params.put(key, val);
            log.info("\u4f20\u5165\u53c2\u6570%s: %s", (Object)key, val);
        }
    }

    public String toMacStr(Object value, String sp, boolean toUpper) {
        return HostUtil.toMacStr((Object)value, (String)sp, (boolean)toUpper);
    }

    public Long toMacInt(Object value) {
        return HostUtil.toMacInt((Object)value);
    }

    public List splitStrToMapList(Object contentO, String fieldName) {
        String content;
        ArrayList<CaseMap> array = new ArrayList<CaseMap>();
        String string = content = contentO == null ? null : contentO.toString();
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        for (String s : StringUtils.stringToList((String)content, (char)',', (boolean)false)) {
            try {
                CaseMap o = new CaseMap();
                o.put((Object)fieldName, (Object)s);
                array.add(o);
            }
            catch (Throwable throwable) {}
        }
        return array;
    }

    public List splitStrToObjectList(String content, String fieldName, Class objClz) {
        ArrayList array = new ArrayList();
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        Method set = null;
        for (String s : StringUtils.stringToList((String)content, (char)',', (boolean)false)) {
            try {
                Object o = objClz.newInstance();
                if (o instanceof Map) {
                    ((Map)o).put(fieldName, s);
                } else {
                    if (set == null) {
                        for (Method m : objClz.getMethods()) {
                            String name;
                            int modifer = m.getModifiers();
                            if (!Modifier.isPublic(modifer) || Modifier.isStatic(modifer) || m.getParameterCount() != 1 || !(name = m.getName()).startsWith("set") || !(name = name.substring(3)).equalsIgnoreCase(fieldName)) continue;
                            set = m;
                            break;
                        }
                        if (set == null) {
                            return array;
                        }
                    }
                    set.invoke(o, s);
                }
                array.add(o);
            }
            catch (Throwable throwable) {}
        }
        return array;
    }

    public Object instance(String clsName) {
        try {
            Class<?> cls = this.useMap.get(clsName);
            if (cls == null) {
                cls = Class.forName(clsName);
                this.useMap.put(clsName, cls);
            }
            try {
                return SpringUtil.getBean(cls);
            }
            catch (Exception exception) {
                return cls.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeFromList(ListData listData, String field, Object value) {
        if (listData != null) {
            for (int i = listData.size() - 1; i >= 0; --i) {
                Object item = listData.get(i);
                if (!this.equalTo(this.get(item, field), value)) continue;
                if (item instanceof StructData) {
                    ((StructData)item).markDeleted(true);
                    continue;
                }
                listData.remove(i);
            }
        }
    }

    public boolean isMarkDeleted(Object data) {
        return LogicUtil.isMarkDeleted((Object)data);
    }

    public boolean isMarkNew(Object data) {
        return LogicUtil.isMarkNew((Object)data);
    }

    public boolean isMarkRemoved(Object data) {
        return LogicUtil.isMarkRemoved((Object)data);
    }

    public <T> T markNew(T data) {
        return (T)LogicUtil.markNew(data);
    }

    public <T> T markDeleted(T data) {
        return (T)LogicUtil.markDeleted(data);
    }

    public <T> T markRemoved(T data) {
        return (T)LogicUtil.markRemoved(data);
    }

    public Object importClass(String cls) {
        return this.importClass(null, cls);
    }

    public Object newInstance(String cls) {
        return this.newInstance(null, cls);
    }

    public Object importClass(String jarName, String cls) {
        try {
            return Class.forName(cls);
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public Object newInstance(String jarName, String cls) {
        try {
            Class clazz = (Class)this.importClass(jarName, cls);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public Object invoke(Object obj, String methodName) {
        try {
            if (obj instanceof Class) {
                return ReflectUtils.invoke((Class)((Class)obj), (String)methodName, (Object[])new Object[0]);
            }
            return ReflectUtils.invoke((Object)obj, (String)methodName, (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public Object invoke(Object obj, String methodName, Object[] prarms) {
        try {
            if (obj instanceof Class) {
                return ReflectUtils.invoke((Class)((Class)obj), (String)methodName, (Object[])prarms);
            }
            return ReflectUtils.invoke((Object)obj, (String)methodName, (Object[])prarms);
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public KeyValue keyValue(String key, Object v) {
        return new KeyValue((Object)key, v);
    }

    public List splitString(Object str, Object split) {
        if (str != null) {
            return StringUtils.spiltToList((String)str.toString(), (String)(split == null ? "" : split.toString()));
        }
        return null;
    }

    public List toList(List array, String field) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (array != null) {
            for (Object o : array) {
                list.add(this.get(o, field));
            }
        }
        return list;
    }

    public String encrypt(String type, String msg) {
        return this.encrypt(type, msg, null);
    }

    public String encrypt(String type, String msg, String key) {
        return EncryptHelper.encrypt(type, msg, key);
    }

    public String decrypt(String type, String msg) {
        return this.decrypt(type, msg, null);
    }

    public String decrypt(String type, String msg, String key) {
        return EncryptHelper.decrypt(type, msg, key);
    }

    public String merge(List lst, String field) {
        return this.merge(lst, field, ",");
    }

    public String merge(List lst, String field, String splitter) {
        if (StringUtils.isNotBlank((String)field) && lst != null) {
            StringBuilder sb = new StringBuilder();
            for (Object o : lst) {
                Object val = this.get(o, field);
                if (val == null) continue;
                if (sb.length() > 0) {
                    sb.append(splitter);
                }
                sb.append(val);
            }
            return sb.toString();
        }
        return null;
    }

    public void distinct(List lst, String field) {
        this.distinct(lst, new Object[]{field});
    }

    public void distinct(List lst, Object ... fields) {
        if (lst != null) {
            HashSet<String> has = new HashSet<String>();
            Iterator iterator = lst.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                StringBuilder vals = new StringBuilder();
                for (int i = 0; i < fields.length; ++i) {
                    String field = (String)fields[i];
                    if (i > 0) {
                        vals.append(",");
                    }
                    vals.append(PropertyValueHelper.getValue(item, (String)field));
                }
                String key = vals.toString();
                if (has.contains(key)) {
                    iterator.remove();
                    continue;
                }
                has.add(key);
            }
        }
    }

    public void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
        }
    }

    public String geometrySTGeomFromText(String text, int coord) {
        return text;
    }

    public int executeBatchUpdate(String tableName, String keyField, String[] tableFields, IDB db, Map data) {
        if (data != null) {
            ArrayList<Map> lst = new ArrayList<Map>();
            lst.add(data);
            return this.executeBatchUpdate(tableName, keyField, tableFields, db, lst);
        }
        return 0;
    }

    public int executeBatchUpdate(String tableName, String keyField, String[] tableFields, IDB db, List<? extends Map> listData) {
        int dbVendor = db.getDbVendor();
        if (dbVendor == 3) {
            return this.executeBatchUpdateWithTempTable(tableName, keyField, tableFields, db, listData);
        }
        int result = 0;
        StringBuilder insertFields = new StringBuilder();
        StringBuilder insertValues = new StringBuilder();
        StringBuilder updateValues = new StringBuilder();
        String mapKeyField = keyField;
        String[] stringArray = tableFields;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String tableField;
            String field = tableField = stringArray[i];
            String fieldType = "";
            String dicField = tableField;
            if (tableField.contains(":")) {
                String[] ss = tableField.split(":");
                if (ss.length > 2) {
                    field = ss[0];
                    dicField = ss[1];
                    fieldType = ss[2];
                } else {
                    field = dicField = ss[0];
                    fieldType = ss[1];
                }
            }
            String fieldHolder = BaseLogicService.getFieldHolderFormat(dbVendor, fieldType, db.buildParamHolder(field));
            if (insertFields.length() > 0) {
                insertFields.append(", ");
                insertValues.append(", ");
            }
            insertFields.append(dicField);
            insertValues.append(fieldHolder);
            if (dicField.equalsIgnoreCase(keyField)) {
                mapKeyField = field;
                continue;
            }
            if (updateValues.length() > 0) {
                updateValues.append(", ");
            }
            updateValues.append(dicField).append(" = ");
            updateValues.append(fieldHolder);
        }
        ArrayList<CaseMap> adds = new ArrayList<CaseMap>();
        ArrayList<Object> upds = new ArrayList<Object>();
        ArrayList<CaseMap> dels = new ArrayList<CaseMap>();
        HashSet<String> addKeys = new HashSet<String>();
        String addSql = String.format("insert into %s (%s) values (%s)", tableName, insertFields, insertValues);
        String updateSql = String.format("update %s set %s where %s = %s", tableName, updateValues, keyField, db.buildParamHolder(mapKeyField));
        String deleteSql = String.format("delete from %s where %s = %s", tableName, keyField, db.buildParamHolder(mapKeyField));
        for (Map map : listData) {
            CaseMap clone = new CaseMap();
            clone.putAll(map);
            String key = Convert.toString(clone.get(keyField));
            if (StringUtils.isBlank((String)key)) {
                if (!this.isMarkNew(map)) continue;
                adds.add(clone);
                continue;
            }
            if (this.isMarkDeleted(map)) {
                dels.add(clone);
                continue;
            }
            if (this.isMarkNew(map)) {
                if (addKeys.contains(key)) continue;
                addKeys.add(key);
                adds.add(clone);
                continue;
            }
            upds.add(clone);
        }
        if (StringUtils.isNotBlank((String)keyField) && adds.size() > 0) {
            StringBuilder checkSql = new StringBuilder();
            HashSet hashSet = new HashSet();
            for (int i = 0; i < adds.size(); ++i) {
                Map add = (Map)adds.get(i);
                Object key = add.get(mapKeyField);
                if (i > 0 && i % 5000 == 0) {
                    checkSql.append(")");
                    for (Map map : db.selectMaps(checkSql.toString(), null)) {
                        hashSet.add(map.get(keyField));
                    }
                    checkSql.setLength(0);
                }
                if (checkSql.length() > 0) {
                    checkSql.append(", ");
                } else {
                    checkSql.append("SELECT ").append(keyField).append(" FROM ").append(tableName).append(" WHERE ").append(keyField).append(" IN (");
                }
                if (StringUtils.isNumber(key) == 1) {
                    checkSql.append(key);
                    continue;
                }
                checkSql.append("'").append(key).append("'");
            }
            if (checkSql.length() > 0) {
                checkSql.append(")");
                for (Map map : db.selectMaps(checkSql.toString(), null)) {
                    hashSet.add(map.get(keyField));
                }
            }
            if (hashSet.size() > 0) {
                Iterator iterator = adds.iterator();
                while (iterator.hasNext()) {
                    Map item = (Map)iterator.next();
                    if (!hashSet.contains(item.get(mapKeyField))) continue;
                    iterator.remove();
                    upds.add(item);
                }
            }
        }
        if (dels.size() > 0) {
            db.executeBatch(deleteSql, dels);
            result += dels.size();
        }
        if (upds.size() > 0) {
            db.executeBatch(updateSql, upds);
            result += upds.size();
        }
        if (adds.size() > 0) {
            db.executeBatch(addSql, adds);
            result += adds.size();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public int executeBatchUpdateWithTempTable(String tableName, String dicKeyField, String[] tableFields, IDB db, List<? extends Map> listData) {
        String tempTableName;
        int result = 0;
        int dbVendor = db.getDbVendor();
        if (listData == null || listData.size() < 1) {
            return result;
        }
        Object mapKeyField = dicKeyField;
        String tempTableKey = "TEMPTABLE_DATA_";
        String tempFieldKey = "TEMPTABLE_FIELD_";
        StringBuilder insertFields = new StringBuilder();
        StringBuilder insertValues = new StringBuilder();
        StringBuilder updateValues = new StringBuilder();
        StringBuilder fieldTypes = new StringBuilder();
        for (String fld : tableFields) {
            void var20_22;
            if (fieldTypes.length() > 0) {
                fieldTypes.append(",");
            }
            Object field = fld;
            Object var20_23 = null;
            String dicField = fld;
            if (fld.contains(":")) {
                void var20_26;
                String[] ss = fld.split(":");
                if (ss.length > 2) {
                    field = ss[0];
                    dicField = ss[1];
                    String string = ss[2];
                } else {
                    dicField = ss[0];
                    field = dicField;
                    String string = ss[1];
                }
                fieldTypes.append((String)field).append(":");
                if ("Geometry".equals(var20_26)) {
                    fieldTypes.append("String");
                } else {
                    fieldTypes.append((String)var20_26);
                }
            } else {
                fieldTypes.append((String)field).append(":").append("String");
            }
            if (insertFields.length() > 0) {
                insertFields.append(", ");
                insertValues.append(", ");
            }
            insertValues.append(BaseLogicService.getFieldHolderFormat(dbVendor, (String)var20_22, (String)field));
            insertFields.append(dicField);
            if (dicField.equalsIgnoreCase(dicKeyField)) {
                mapKeyField = field;
                continue;
            }
            if (updateValues.length() > 0) {
                updateValues.append(", ");
            }
            updateValues.append("a.").append(dicField).append(" = ");
            updateValues.append(BaseLogicService.getFieldHolderFormat(dbVendor, (String)var20_22, "temp." + (String)field));
        }
        ArrayList<Map> adds = new ArrayList<Map>();
        HashSet<String> addKeys = new HashSet<String>();
        LinkedHashMap<String, Map> upds = new LinkedHashMap<String, Map>();
        LinkedHashMap<String, Map> dels = new LinkedHashMap<String, Map>();
        for (Map map : listData) {
            Map clone = map;
            String key = Convert.toString(clone.get(mapKeyField));
            if (StringUtils.isBlank((String)key)) continue;
            if (this.isMarkDeleted(map)) {
                dels.put(key, clone);
                continue;
            }
            if (this.isMarkNew(map)) {
                if (addKeys.contains(key)) continue;
                addKeys.add(key);
                adds.add(clone);
                continue;
            }
            upds.put(key, clone);
        }
        if (dels.size() > 0) {
            tempTableName = tableName + System.currentTimeMillis();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("TEMPTABLE_DATA_" + tempTableName, dels.values());
            hashMap.put("TEMPTABLE_FIELD_" + tempTableName, fieldTypes.toString());
            String deleteSql = String.format("DELETE FROM %1$s WHERE %2$s IN (SELECT %3$s FROM %4$s temp)", tableName, dicKeyField, mapKeyField, tempTableName);
            result += db.executeUpdate(deleteSql, hashMap);
        }
        if (upds.size() > 0) {
            tempTableName = tableName + System.currentTimeMillis();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("TEMPTABLE_DATA_" + tempTableName, upds.values());
            hashMap.put("TEMPTABLE_FIELD_" + tempTableName, fieldTypes.toString());
            String updateSql = String.format("UPDATE a SET %1$s FROM %2$s a, %3$s temp WHERE a.%4$s = temp.%5$s", updateValues, tableName, tempTableName, dicKeyField, mapKeyField);
            result += db.executeUpdate(updateSql, hashMap);
        }
        if (adds.size() > 0) {
            tempTableName = tableName + System.currentTimeMillis();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("TEMPTABLE_DATA_" + tempTableName, adds);
            hashMap.put("TEMPTABLE_FIELD_" + tempTableName, fieldTypes.toString());
            String addSql = String.format("INSERT INTO %1$s (%2$s) SELECT %3$s FROM %4$s temp", tableName, insertFields, insertValues, tempTableName);
            result += db.executeUpdate(addSql, hashMap);
        }
        return result;
    }

    public void putToList(List from, List to, String keyField) {
        this.putToList(from, to, keyField, true);
    }

    public void putToList(List from, List to, String keyField, boolean markNew) {
        if (from != null && to != null) {
            Object key;
            HashMap duplicates = null;
            if (StringUtils.isNotBlank((String)keyField)) {
                duplicates = new HashMap();
                for (Object o : to) {
                    key = ((Map)o).get(keyField);
                    if (key == null) continue;
                    duplicates.put(key, o);
                }
            }
            for (Object map : from) {
                if (map instanceof Map) {
                    if (markNew) {
                        this.markNew(map);
                    }
                    if (duplicates != null && (key = ((Map)map).get(keyField)) != null) {
                        Object exist = duplicates.get(key);
                        if (exist != null) {
                            to.remove(exist);
                        }
                        duplicates.put(key, map);
                    }
                }
                to.add(map);
            }
        }
    }

    public void putToDim(List to, Map data) {
        try {
            Map copy;
            if (to instanceof ListData) {
                Class cls = ((ListData)to).getItemClassType();
                copy = (Map)cls.newInstance();
            } else {
                copy = (Map)data.getClass().newInstance();
            }
            copy.putAll(data);
            this.putToList(copy, to, null);
        }
        catch (Exception e) {
            this.putToList(data, to, null, LogicUtil.isMarkNew((Object)data));
        }
    }

    public void putToDim(List to, List from) {
        for (Object o : from) {
            if (o instanceof Map) {
                this.putToDim(to, (Map)o);
                continue;
            }
            to.add(o);
        }
    }

    public void putToDim(List to, Object data) {
        if (data instanceof List) {
            this.putToList((List)data, to, null);
        } else if (data instanceof Map) {
            this.putToList((Map)data, to, null);
        } else {
            to.add(data);
        }
    }

    public void putToDim(List to, int data) {
        to.add(data);
    }

    public void putToDim(List to, double data) {
        to.add(data);
    }

    public void putToDim(List to, long data) {
        to.add(data);
    }

    public void putToList(Map data, List to, String keyField) {
        this.putToList(data, to, keyField, true);
    }

    public void putToList(Map data, List to, String keyField, boolean markNew) {
        Object key;
        if (markNew) {
            this.markNew(data);
        }
        Object object = key = StringUtils.isNotBlank((String)keyField) ? (Object)data.get(keyField) : null;
        if (key != null) {
            Iterator iterator = to.iterator();
            while (iterator.hasNext()) {
                Map i = (Map)iterator.next();
                if (i == null || !key.equals(i.get(keyField))) continue;
                iterator.remove();
            }
        }
        to.add(data);
    }

    public void addToList(List list, String jsonString) {
        this.addToList(list, jsonString, ",");
    }

    public void addToList(List list, String jsonString, String splitter) {
        HashMap<String, String> map = null;
        try {
            map = (HashMap<String, String>)SerializeFactory.parseJson((String)jsonString, Map.class);
        }
        catch (Exception e) {
            String[] splits;
            map = new HashMap<String, String>();
            for (String split : splits = jsonString.split(splitter)) {
                int idx = split.indexOf(":");
                if (idx <= 0) continue;
                String key = split.substring(0, idx).trim();
                String value = split.substring(idx + 1);
                map.put(key, value);
            }
        }
        if (list.add(map)) {
            this.markNew(list.get(list.size() - 1));
        }
    }

    public String getStatusName(String stgId, String value) {
        StatusGroup statusGroup = StatusGroup.getStatusGroup((String)stgId, (boolean)true);
        if (statusGroup != null && statusGroup.getItems() != null) {
            for (StatusItem item : statusGroup.getItems()) {
                if (!item.getStatusvalue().equals(value)) continue;
                return item.getStatusname();
            }
        }
        return value;
    }

    public String getStatusValue(String stgId, String name) {
        StatusGroup statusGroup = StatusGroup.getStatusGroup((String)stgId, (boolean)true);
        if (statusGroup != null && statusGroup.getItems() != null) {
            for (StatusItem item : statusGroup.getItems()) {
                if (!item.getStatusname().equals(name)) continue;
                return item.getStatusvalue();
            }
        }
        return name;
    }

    public String getRefName(LogicServiceContext context, String value) {
        return this.getRefName(context, value, null);
    }

    public String getRefName(LogicServiceContext context, String value, String refId) {
        return this.getRefName(context, value, refId, null);
    }

    public String getRefName(LogicServiceContext context, String value, String refId, String refAid) {
        String refName;
        String key = value + "_" + refId + "_" + refAid;
        if (context != null && context.getRefNamesCache().containsKey(key)) {
            return (String)context.getRefNamesCache().get(key);
        }
        if ("SYSSTATUSITEM".equalsIgnoreCase(refId)) {
            refName = this.getStatusName(refAid, value);
        } else {
            FetchEntityModeArgument argument = new FetchEntityModeArgument();
            argument.setProvider(refId);
            argument.setKeyId(value);
            argument.setExtPara1((Object)refAid);
            DataSourceService dataSourceService = (DataSourceService)ContextManager.find(DataSourceService.class);
            Map<String, String> result = dataSourceService.selectResName(argument);
            String string = refName = result == null ? null : result.get("value");
        }
        if (context != null) {
            context.getRefNamesCache().put(key, refName);
        }
        return refName;
    }

    public String getRefObjId(String value) {
        return this.getRefObjId(value, null);
    }

    public String getRefObjId(String value, String refId) {
        return this.getRefObjId(value, refId, null);
    }

    public String getRefObjId(String value, String refId, String refAid) {
        if ("SYSSTATUSITEM".equalsIgnoreCase(refId)) {
            return this.getStatusValue(refAid, value);
        }
        FetchEntityModeArgument argument = new FetchEntityModeArgument();
        argument.setProvider(refId);
        argument.setKeyId(value);
        DataSourceService dataSourceService = (DataSourceService)ContextManager.find(DataSourceService.class);
        Map<String, String> result = dataSourceService.selectResKey(argument);
        return result == null ? null : result.get("value");
    }

    @Override
    public ICalendarServiceCore getCalendarService() {
        if (iCalendarServiceCore == null) {
            iCalendarServiceCore = (ICalendarServiceCore)ContextManager.find(ICalendarServiceCore.class);
        }
        return iCalendarServiceCore;
    }

    public boolean isRoleMatched(String role) {
        return SysUserRangeUtils.isRoleMatched(role);
    }

    public <T extends Map> T mergeData(T to, Map from, String keyField, Class<T> clz) {
        if (from == null) {
            return null;
        }
        boolean newInstance = false;
        if (to == null || StringUtils.isBlank((String)keyField)) {
            newInstance = true;
        } else {
            Object toKey = to.get(keyField);
            Object fromKey = from.get(keyField);
            if (toKey == null || fromKey == null || !toKey.equals(fromKey)) {
                newInstance = true;
            }
        }
        if (newInstance) {
            try {
                to = (Map)clz.newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        to.putAll(from);
        return to;
    }

    public void throwException(String msg) {
        throw new LogicAppException(msg);
    }

    public Object tryGetCurrent(Object data) {
        if (data instanceof ListData) {
            return ((ListData)data).current();
        }
        return null;
    }

    public Object unsupportedMethod(String methodName, Object ... params) {
        throw new AppException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5: " + methodName);
    }

    private static IFieldHolderProvider getFieldHolderProvider(int vendor) {
        switch (vendor) {
            case 1: {
                return mySqlFieldHolderProvider;
            }
            case 2: {
                return oracleSqlFieldHolderProvider;
            }
            case 3: {
                return msSqlFieldHolderProvider;
            }
        }
        return null;
    }

    private static String getFieldHolderFormat(int vendor, String fieldType, String holder) {
        IFieldHolderProvider provider;
        if (StringUtils.isNotBlank((String)fieldType) && (provider = BaseLogicService.getFieldHolderProvider(vendor)) != null) {
            switch (fieldType) {
                case "Geometry": {
                    return provider.getGeometry(holder);
                }
            }
        }
        return holder;
    }

    public Object resamplingWavFile(Object data, int targetRate) {
        return this.resamplingWavFile((byte[])data, targetRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resamplingWavFile(byte[] data, int targetRate) {
        WaveFileReader reader = new WaveFileReader();
        AudioInputStream inputStream = null;
        AudioInputStream dstInputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            byte[] bytes;
            inputStream = reader.getAudioInputStream(new ByteArrayInputStream(data));
            AudioFormat srcFormat = inputStream.getFormat();
            AudioFormat dstFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, targetRate, 16, srcFormat.getChannels(), srcFormat.getChannels() * 2, srcFormat.getFrameRate(), false);
            dstInputStream = AudioSystem.getAudioInputStream(dstFormat, inputStream);
            WaveFileWriter writer = new WaveFileWriter();
            outputStream = new ByteArrayOutputStream();
            writer.write(dstInputStream, AudioFileFormat.Type.WAVE, outputStream);
            byte[] pcm2channel = outputStream.toByteArray();
            inputStream.close();
            outputStream.close();
            dstInputStream.close();
            inputStream = reader.getAudioInputStream(new ByteArrayInputStream(pcm2channel));
            dstFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, targetRate, 16, 1, 2, srcFormat.getFrameRate(), false);
            dstInputStream = AudioSystem.getAudioInputStream(dstFormat, inputStream);
            outputStream = new ByteArrayOutputStream();
            writer.write(dstInputStream, AudioFileFormat.Type.WAVE, outputStream);
            byte[] byArray = bytes = outputStream.toByteArray();
            return byArray;
        }
        catch (UnsupportedAudioFileException e) {
            log.error((Throwable)e);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
            if (dstInputStream != null) {
                try {
                    dstInputStream.close();
                }
                catch (Exception e) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    static IRegionCache getCache() {
        return ICacheManager.instance().getDefaultCache();
    }

    static {
        mySqlFieldHolderProvider = new MySqlFieldHolderProvider();
        msSqlFieldHolderProvider = new MsSqlFieldHolderProvider();
        oracleSqlFieldHolderProvider = new OracleSqlFieldHolderProvider();
    }

    private static class OracleSqlFieldHolderProvider
    implements IFieldHolderProvider {
        private OracleSqlFieldHolderProvider() {
        }

        @Override
        public String getGeometry(String holder) {
            return String.format("sdo_geometry(%s, 4326)", holder);
        }
    }

    private static class MsSqlFieldHolderProvider
    implements IFieldHolderProvider {
        private MsSqlFieldHolderProvider() {
        }

        @Override
        public String getGeometry(String holder) {
            return String.format("geometry::STGeomFromText(%s, 4326)", holder);
        }
    }

    private static class MySqlFieldHolderProvider
    implements IFieldHolderProvider {
        private MySqlFieldHolderProvider() {
        }

        @Override
        public String getGeometry(String holder) {
            return String.format("ST_GeomFromText(%s, 4326)", holder);
        }
    }

    static interface IFieldHolderProvider {
        default public String getGeometry(String holder) {
            return holder;
        }
    }

    public static class LogicAppException
    extends AppException {
        public LogicAppException(String msg) {
            super(msg);
        }
    }
}

